/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model;

import ch.elexis.base.ch.arzttarife.model.service.ConfigServiceHolder;
import ch.elexis.base.ch.arzttarife.model.service.ContextServiceHolder;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLeistung;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class TarmedUtil {
    private static Properties increasedTreatment;

    public static boolean getConfigValue(Class<?> requestor, Class<?> configSource, String parameter, boolean fallback) {
        IConfigService configService;
        IContact contact;
        IContextService contextService = ContextServiceHolder.get().orElse(null);
        if (contextService != null && (contact = configSource.equals(IMandator.class) ? (IContact)contextService.getActiveMandator().orElse(null) : (IContact)contextService.getActiveUser().map(u -> u.getAssignedContact()).orElse(null)) != null && (configService = (IConfigService)ConfigServiceHolder.get().orElse(null)) != null) {
            boolean value = configService.get(contact, parameter, fallback);
            if (value != fallback) {
                LoggerFactory.getLogger(requestor).info("[{}] Overriden [{}] with [{}]", new Object[]{contact.getDescription3(), parameter, value});
            }
            return value;
        }
        return fallback;
    }

    public static Optional<String> getIncreasedTreatmentCode(TarmedLeistung code) {
        if (increasedTreatment == null) {
            increasedTreatment = new Properties();
            try {
                increasedTreatment.load(TarmedUtil.class.getResourceAsStream("/rsc/increasedtreatment.properties"));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(TarmedUtil.class).error("Loading increasedtreatment.properties failed", (Throwable)e);
            }
        }
        return Optional.ofNullable((String)increasedTreatment.get(code.getCode()));
    }

    public static boolean isIncreasedTreatment(IPatient patient) {
        Object info;
        if (patient != null && (info = patient.getExtInfo((Object)"IncreasedTreatment")) instanceof String) {
            return Boolean.parseBoolean((String)info);
        }
        return false;
    }
}

