/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher;

import ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher.CasemasterService;
import ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher.MapperService;
import ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher.PatientClassificationSystemService;
import ch.elexis.core.utils.CoreUtil;
import ch.oaat_otma.PatientCase;
import ch.oaat_otma.Service;
import ch.oaat_otma.Side;
import ch.oaat_otma.casemaster.Casemaster;
import ch.oaat_otma.casemaster.CasemasterResult;
import ch.oaat_otma.casemaster.Patient;
import ch.oaat_otma.casemaster.Session;
import ch.oaat_otma.grouper.ClassificationSystemReader;
import ch.oaat_otma.grouper.PatientClassificationSystem;
import ch.oaat_otma.grouper.parser.ParseError;
import ch.oaat_otma.mapper.Mapper;
import ch.oaat_otma.mapper.MapperLogEntry;
import ch.oaat_otma.mapper.MapperResult;
import ch.oaat_otma.mapper.ServiceCatalog;
import ch.oaat_otma.mapper.TardocCatalog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class TestTarifMatcher {
    private static final String CAP_ASSIGNMENT_FILENAME = "system_ambP_11c_cap_assignment.json";
    private static final String TARDOC_FILENAME = "tardoc_TARDOC_1.4c_de.json";
    private static final String LKAAT_FILENAME = "lkaat_1.0c.json";
    private static final String CLASS_LKAAT_FILENAME = "system_ambP_11c_lkaat.json";
    private Casemaster caseMaster;
    private PatientClassificationSystem patientClassificationSystemService;
    private Mapper mapper;

    public TestTarifMatcher() {
        this.initCasemaster();
        this.initClassificationSystem();
        this.initMapper();
    }

    public void run() {
        Session session = new Session(Integer.valueOf(1), LocalDate.of(2026, 1, 1));
        session.addService(new Service("AA.00.0010", Side.NONE, 1, LocalDate.of(2026, 1, 1), Integer.valueOf(1)));
        Patient patient = new Patient();
        patient.setBirthDate(LocalDate.of(2000, 1, 1));
        patient.setSex("W");
        patient.setSessions(Collections.singletonList(session));
        CasemasterResult casemasterResult = this.caseMaster.apply(patient);
        for (PatientCase patientCase : casemasterResult.patientCases) {
            this.patientClassificationSystemService.evaluate(patientCase);
            if (!"NO.ambP".equals(patientCase.getGrouperResult().group)) continue;
            MapperResult mapperResult = this.mapper.map(patientCase);
            ArrayList<MapperLogEntry> noneInfoLog = new ArrayList<MapperLogEntry>(mapperResult.log.stream().filter(l -> l.level != MapperLogEntry.MapperLogEntryLevel.INFO && l.level != MapperLogEntry.MapperLogEntryLevel.WARNING).toList());
            if (noneInfoLog.isEmpty()) continue;
            System.out.println("Unerwartet! LKAAT_VALIDATION_DUPLICATE?");
        }
    }

    private void initMapper() {
        Throwable throwable;
        TardocCatalog tardocCatalog = null;
        ServiceCatalog serviceCatalog = null;
        File rootDir = CoreUtil.getWritableUserDir();
        File tarifmatcherdir = new File(rootDir, "tarifmatcher");
        if (!tarifmatcherdir.exists()) {
            tarifmatcherdir.mkdir();
        }
        File tardocFile = new File(tarifmatcherdir, TARDOC_FILENAME);
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (FileOutputStream out = new FileOutputStream(new File(tarifmatcherdir, TARDOC_FILENAME));){
                IOUtils.copy((InputStream)MapperService.class.getResourceAsStream("/rsc/mapper/tardoc_TARDOC_1.4c_de.json"), (OutputStream)out);
                tardocCatalog = TardocCatalog.readCatalog((File)tardocFile);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (ParseError | IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error initializing Mapper", e);
        }
        File lkaatFile = new File(tarifmatcherdir, LKAAT_FILENAME);
        try {
            throwable = null;
            Object var8_13 = null;
            try (FileOutputStream out = new FileOutputStream(new File(tarifmatcherdir, LKAAT_FILENAME));){
                IOUtils.copy((InputStream)MapperService.class.getResourceAsStream("/rsc/mapper/lkaat_1.0c.json"), (OutputStream)out);
                serviceCatalog = ServiceCatalog.readCatalog((File)lkaatFile);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (ParseError | IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error initializing Mapper", e);
        }
        this.mapper = new Mapper(serviceCatalog, tardocCatalog);
    }

    private void initCasemaster() {
        File rootDir = CoreUtil.getWritableUserDir();
        File tarifmatcherdir = new File(rootDir, "tarifmatcher");
        if (!tarifmatcherdir.exists()) {
            tarifmatcherdir.mkdir();
        }
        File capAssignmentFile = new File(tarifmatcherdir, CAP_ASSIGNMENT_FILENAME);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream out = new FileOutputStream(new File(tarifmatcherdir, CAP_ASSIGNMENT_FILENAME));){
                IOUtils.copy((InputStream)CasemasterService.class.getResourceAsStream("/rsc/casemaster/system_ambP_11c_cap_assignment.json"), (OutputStream)out);
                this.caseMaster = new Casemaster(capAssignmentFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error initializing Casemaster", (Throwable)e);
        }
    }

    private void initClassificationSystem() {
        File rootDir = CoreUtil.getWritableUserDir();
        File tarifmatcherdir = new File(rootDir, "tarifmatcher");
        if (!tarifmatcherdir.exists()) {
            tarifmatcherdir.mkdir();
        }
        File lkaatFile = new File(tarifmatcherdir, CLASS_LKAAT_FILENAME);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream out = new FileOutputStream(new File(tarifmatcherdir, CLASS_LKAAT_FILENAME));){
                IOUtils.copy((InputStream)PatientClassificationSystemService.class.getResourceAsStream("/rsc/grouper/system_ambP_11c_lkaat.json"), (OutputStream)out);
                ClassificationSystemReader reader = new ClassificationSystemReader();
                this.patientClassificationSystemService = reader.readFromFile(lkaatFile);
                List errors = this.patientClassificationSystemService.check();
                assert (errors.size() == 0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error initializing Casemaster", (Throwable)e);
        }
    }
}

