/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.coding;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.ICodingContribution;
import ch.elexis.core.findings.codes.TransientCoding;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"system=forumdatenaustausch_sectioncode"})
public class SectionCodeCodingContribution
implements ICodingContribution {
    private List<ICoding> codes;
    private Map<String, ICoding> dignitaetMap;
    private Map<String, Integer> dignitaetWeigthMap;

    @Activate
    public void activate() {
        this.codes = new ArrayList<ICoding>();
        this.dignitaetMap = new HashMap<String, ICoding>();
        this.dignitaetWeigthMap = new HashMap<String, Integer>();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(this.getClass().getResourceAsStream("/rsc/section_code_tardoc_dignitaet_mapping_weighted.csv"))).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(',').withQuoteChar('\"').build()).withKeepCarriageReturn(false).withSkipLines(1).build();){
                for (String[] line : reader.readAll()) {
                    if (!StringUtils.isNotBlank((CharSequence)line[2])) continue;
                    TransientCoding code = new TransientCoding("forumdatenaustausch_sectioncode", line[2], line[1]);
                    this.codes.add((ICoding)code);
                    if (!StringUtils.isNotBlank((CharSequence)line[0])) continue;
                    this.dignitaetMap.put(line[0], (ICoding)code);
                    if (!StringUtils.isNotBlank((CharSequence)line[5])) continue;
                    this.dignitaetWeigthMap.put(line[2], Integer.parseInt(line[5]));
                }
                this.codes.sort((l, r) -> l.getCode().compareTo(r.getCode()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CsvException | IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception on activation", e);
        }
    }

    public String getCodeSystem() {
        return "forumdatenaustausch_sectioncode";
    }

    public List<ICoding> getCodes() {
        return this.codes;
    }

    public Optional<ICoding> getCode(String code) {
        return this.codes.stream().filter(c -> c.getCode().equals(code)).findAny();
    }

    public Optional<ICoding> getMappedBySpecialistCode(List<ICoding> specialistCodes) {
        ArrayList<ICoding> canidates = new ArrayList<ICoding>(specialistCodes.stream().map(c -> this.dignitaetMap.get(c.getCode())).filter(c -> c != null).toList());
        if (!canidates.isEmpty()) {
            canidates.sort((l, r) -> {
                Integer lw = this.dignitaetWeigthMap.getOrDefault(l.getCode(), 0);
                Integer rw = this.dignitaetWeigthMap.getOrDefault(r.getCode(), 0);
                return rw.compareTo(lw);
            });
            return Optional.of((ICoding)canidates.get(0));
        }
        return Optional.empty();
    }
}

