/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.ambulatory.model;

import ch.elexis.base.ch.arzttarife.ambulatory.AmbulantePauschalenTyp;
import ch.elexis.base.ch.arzttarife.ambulatory.IAmbulatoryAllowance;
import ch.elexis.base.ch.arzttarife.ambulatory.model.AmbulatoryAllowanceOptifier;
import ch.elexis.base.ch.arzttarife.ambulatory.model.AmbulatoryAllowanceVerifier;
import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.model.service.ContextServiceHolder;
import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.core.jpa.entities.AmbulantePauschalen;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.types.VatInfo;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class AmbulatoryAllowance
extends AbstractIdDeleteModelAdapter<AmbulantePauschalen>
implements Identifiable,
IAmbulatoryAllowance {
    public static final String STS_CLASS = "ch.elexis.data.AmbulantePauschalen";
    private static IBillableOptifier<AmbulatoryAllowance> optifier;
    private IBillableVerifier verifier = new AmbulatoryAllowanceVerifier();

    public AmbulatoryAllowance(AmbulantePauschalen entity) {
        super((EntityWithId)entity);
    }

    public IBillableOptifier<AmbulatoryAllowance> getOptifier() {
        if (optifier == null) {
            optifier = new AmbulatoryAllowanceOptifier(CoreModelServiceHolder.get(), ContextServiceHolder.get().get());
        }
        return optifier;
    }

    protected Money getPrice(IEncounter iEncounter) {
        if (StringUtils.isNotBlank((CharSequence)((AmbulantePauschalen)this.getEntity()).getTp())) {
            try {
                int cents = Integer.parseInt(((AmbulantePauschalen)this.getEntity()).getTp());
                return new Money(cents);
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Ignoring non integer tp value [" + ((AmbulantePauschalen)this.getEntity()).getTp() + "] of [" + String.valueOf(this) + "]");
            }
        }
        return new Money();
    }

    public IBillableVerifier getVerifier() {
        return this.verifier;
    }

    public String getCodeSystemName() {
        return "Ambulantepauschalen";
    }

    public String getCodeSystemCode() {
        return this.getTyp() == AmbulantePauschalenTyp.PAUSCHALE ? "005" : "TMA";
    }

    public String getCode() {
        return ((AmbulantePauschalen)this.getEntity()).getCode();
    }

    public void setCode(String value) {
        ((AmbulantePauschalen)this.getEntity()).setCode(value);
    }

    public String getText() {
        return ((AmbulantePauschalen)this.getEntity()).getText();
    }

    public void setText(String value) {
        ((AmbulantePauschalen)this.getEntity()).setText(value);
    }

    @Override
    public LocalDate getValidFrom() {
        return ((AmbulantePauschalen)this.getEntity()).getValidFrom();
    }

    @Override
    public void setValidFrom(LocalDate value) {
    }

    @Override
    public LocalDate getValidTo() {
        return ((AmbulantePauschalen)this.getEntity()).getValidTo();
    }

    @Override
    public void setValidTo(LocalDate value) {
    }

    @Override
    public String getChapter() {
        return StringUtils.defaultString((String)((AmbulantePauschalen)this.getEntity()).getChapter());
    }

    @Override
    public void setChapter(String value) {
        ((AmbulantePauschalen)this.getEntity()).setChapter(value);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }

    public String getLabel() {
        return "(" + this.getCode() + ") " + this.getTyp().getCode() + " " + this.getChapter() + " - " + this.getText();
    }

    @Override
    public String getTP() {
        return ((AmbulantePauschalen)this.getEntity()).getTp();
    }

    @Override
    public void setTP(String value) {
        ((AmbulantePauschalen)this.getEntityMarkDirty()).setTp(value);
    }

    @Override
    public String getDigniQuali() {
        return ((AmbulantePauschalen)this.getEntity()).getDigniQuali();
    }

    @Override
    public AmbulantePauschalenTyp getTyp() {
        if (StringUtils.isNotBlank((CharSequence)((AmbulantePauschalen)this.getEntity()).getTyp())) {
            return AmbulantePauschalenTyp.fromCode(((AmbulantePauschalen)this.getEntity()).getTyp());
        }
        return AmbulantePauschalenTyp.PAUSCHALE;
    }

    @Override
    public void setTyp(AmbulantePauschalenTyp value) {
        ((AmbulantePauschalen)this.getEntityMarkDirty()).setTyp(value.getCode());
    }

    public static AmbulatoryAllowance getFromCode(String code, AmbulantePauschalenTyp typ, LocalDate date) {
        IQuery query = ArzttarifeModelServiceHolder.get().getQuery(IAmbulatoryAllowance.class);
        query.and("code", IQuery.COMPARATOR.EQUALS, (Object)code);
        if (typ != null) {
            query.and("typ", IQuery.COMPARATOR.EQUALS, (Object)typ.getCode());
        }
        List leistungen = query.execute();
        for (IAmbulatoryAllowance ambulanteLeistung : leistungen) {
            if (!date.isAfter(ambulanteLeistung.getValidFrom()) && !date.equals(ambulanteLeistung.getValidFrom()) || !date.isBefore(ambulanteLeistung.getValidTo()) && !date.equals(ambulanteLeistung.getValidTo())) continue;
            return (AmbulatoryAllowance)ambulanteLeistung;
        }
        return null;
    }

    public VatInfo getVatInfo() {
        return VatInfo.VAT_CH_ISTREATMENT;
    }
}

