/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedExtension;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedGroup;
import ch.elexis.base.ch.arzttarife.tarmed.TarmedKumulationArt;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedExclusion;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedKumulation;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLimitation;
import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TarmedGroup
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.TarmedGroup>
implements Identifiable,
ITarmedGroup {
    private LocalDate curTimeHelper = LocalDate.now();
    private ITarmedExtension extension;

    public TarmedGroup(ch.elexis.core.jpa.entities.TarmedGroup entity) {
        super((EntityWithId)entity);
    }

    @Override
    public String getCode() {
        return ((ch.elexis.core.jpa.entities.TarmedGroup)this.getEntity()).getCode();
    }

    @Override
    public List<String> getServices() {
        return ((ch.elexis.core.jpa.entities.TarmedGroup)this.getEntity()).getServices();
    }

    @Override
    public LocalDate getValidFrom() {
        return ((ch.elexis.core.jpa.entities.TarmedGroup)this.getEntity()).getValidFrom();
    }

    @Override
    public LocalDate getValidTo() {
        return ((ch.elexis.core.jpa.entities.TarmedGroup)this.getEntity()).getValidTo();
    }

    @Override
    public String getLaw() {
        return ((ch.elexis.core.jpa.entities.TarmedGroup)this.getEntity()).getLaw();
    }

    @Override
    public List<TarmedExclusion> getExclusions(IEncounter encounter) {
        this.curTimeHelper = encounter == null ? LocalDate.now() : encounter.getDate();
        return this.getExclusions(this.curTimeHelper);
    }

    public List<TarmedExclusion> getExclusions(LocalDate date) {
        return TarmedKumulation.getExclusions(this.getCode(), TarmedKumulationArt.GROUP, date, this.getLaw());
    }

    @Override
    public ITarmedExtension getExtension() {
        if (this.extension == null) {
            INamedQuery query = ArzttarifeModelServiceHolder.get().getNamedQuery(ITarmedExtension.class, new String[]{"code"});
            List found = query.executeWithParameters(query.getParameterMap(new Object[]{"code", this.getId()}));
            if (!found.isEmpty()) {
                this.extension = (ITarmedExtension)found.get(0);
            }
        }
        return this.extension;
    }

    @Override
    public List<TarmedLimitation> getLimitations() {
        String lim;
        ITarmedExtension _extension = this.getExtension();
        if (this.extension != null && (lim = _extension.getLimits().get("limits")) != null && !lim.isEmpty()) {
            String[] lines;
            ArrayList<TarmedLimitation> ret = new ArrayList<TarmedLimitation>();
            String[] stringArray = lines = lim.split("#");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                ret.add(TarmedLimitation.of(line).setTarmedGroup(this));
                ++n2;
            }
            return ret;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean validAt(LocalDate validTime) {
        TimeTool _validTime = new TimeTool(validTime);
        TimeTool validFrom = new TimeTool(this.getValidFrom());
        TimeTool validTo = new TimeTool(this.getValidTo());
        return _validTime.isAfterOrEqual(validFrom) && _validTime.isBeforeOrEqual(validTo);
    }

    public static Optional<ITarmedGroup> find(String groupName, String law, LocalDate validFrom) {
        IQuery query = ArzttarifeModelServiceHolder.get().getQuery(ITarmedGroup.class);
        query.and("groupName", IQuery.COMPARATOR.EQUALS, (Object)groupName);
        if (law != null) {
            if (!ArzttarifeUtil.isAvailableLaw(law)) {
                query.startGroup();
                query.or("law", IQuery.COMPARATOR.EQUALS, (Object)"");
                query.or("law", IQuery.COMPARATOR.EQUALS, null);
                query.andJoinGroups();
            } else {
                query.and("law", IQuery.COMPARATOR.EQUALS, (Object)law, true);
            }
        }
        List groups = query.execute();
        if (!(groups = groups.stream().filter(g -> g.validAt(validFrom)).collect(Collectors.toList())).isEmpty()) {
            return Optional.of((ITarmedGroup)groups.get(0));
        }
        return Optional.empty();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }
}

