/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.nutrition.model;

import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.base.ch.arzttarife.nutrition.INutritionLeistung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.types.VatInfo;
import java.time.LocalDate;
import java.util.Optional;

public class NutritionLeistung
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.NutritionLeistung>
implements Identifiable,
INutritionLeistung {
    public static final String STS_CLASS = "ch.elexis.data.NutritionLeistung";
    private static IBillableOptifier<NutritionLeistung> optifier;
    private IBillableVerifier verifier = new DefaultVerifier();

    public NutritionLeistung(ch.elexis.core.jpa.entities.NutritionLeistung entity) {
        super((EntityWithId)entity);
    }

    public synchronized IBillableOptifier<NutritionLeistung> getOptifier() {
        if (optifier == null) {
            optifier = new AbstractOptifier<NutritionLeistung>(CoreModelServiceHolder.get(), ContextServiceHolder.get()){

                protected void setPrice(NutritionLeistung billable, IBilled billed) {
                    Optional<IBillingSystemFactor> factor = this.getFactor(billed.getEncounter());
                    if (factor.isPresent()) {
                        billed.setFactor(factor.get().getFactor());
                    } else {
                        billed.setFactor(1.0);
                    }
                    int points = 0;
                    if (billable.getTP() != null) {
                        try {
                            points = Integer.valueOf(billable.getTP());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    billed.setPoints(points);
                }

                public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
                    return BillingServiceHolder.get().getBillingSystemFactor("NUT", encounter.getDate());
                }
            };
        }
        return optifier;
    }

    public IBillableVerifier getVerifier() {
        return this.verifier;
    }

    public VatInfo getVatInfo() {
        return VatInfo.VAT_CH_ISTREATMENT;
    }

    public String getCodeSystemCode() {
        return "510";
    }

    public String getCodeSystemName() {
        return "Ern\u00e4hrungsberatung";
    }

    public String getCode() {
        return ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntity()).getCode();
    }

    public void setCode(String value) {
    }

    public String getText() {
        return ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntity()).getText();
    }

    public void setText(String value) {
        ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntityMarkDirty()).setCodeText(value);
    }

    @Override
    public LocalDate getValidFrom() {
        return ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntity()).getValidFrom();
    }

    @Override
    public void setValidFrom(LocalDate value) {
        ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntityMarkDirty()).setValidFrom(value);
    }

    @Override
    public LocalDate getValidTo() {
        return ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntity()).getValidUntil();
    }

    @Override
    public void setValidTo(LocalDate value) {
        ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntityMarkDirty()).setValidUntil(value);
    }

    @Override
    public String getTP() {
        return ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntity()).getTp();
    }

    @Override
    public void setTP(String value) {
        ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntityMarkDirty()).setTp(value);
    }

    @Override
    public String getDescription() {
        return ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntity()).getDescription();
    }

    @Override
    public void setDescription(String value) {
        ((ch.elexis.core.jpa.entities.NutritionLeistung)this.getEntityMarkDirty()).setDescription(value);
    }

    public String getLabel() {
        return this.getCode() + " " + this.getText();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }
}

