/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model;

import ch.elexis.base.ch.arzttarife.tarmed.ITarmedGroup;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedGroup;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLimitation;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.TarmedLeistungAge;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TarmedVerifier
implements IBillableVerifier {
    public Result<IBillable> verifyAdd(IBillable billable, IEncounter encounter, double amount) {
        return Result.OK();
    }

    public Result<IBilled> verify(IEncounter encounter) {
        Result ret = new Result();
        for (IBilled vv : encounter.getBilled()) {
            Result<IBilled> ageResult;
            IBillable iv = vv.getBillable();
            if (!(iv instanceof TarmedLeistung)) continue;
            TarmedLeistung tarmedLeistung = (TarmedLeistung)iv;
            Result<IBilled> limitResult = this.checkLimitations(encounter, tarmedLeistung, vv);
            if (!limitResult.isOK()) {
                ret.add(limitResult);
            }
            if ((ageResult = this.checkAge(encounter, tarmedLeistung, vv)).isOK()) continue;
            ret.add(ageResult);
        }
        return ret;
    }

    public Result<IBilled> checkLimitations(IEncounter kons, TarmedLeistung tarmedLeistung, IBilled newVerrechnet) {
        List<TarmedLimitation> limitations = tarmedLeistung.getLimitations();
        for (TarmedLimitation tarmedLimitation : limitations) {
            Result<IBilled> result;
            if (!tarmedLimitation.isTestable() || (result = tarmedLimitation.test(kons, newVerrechnet)).isOK()) continue;
            return result;
        }
        List<String> groups = tarmedLeistung.getServiceGroups(kons.getDate());
        for (String groupName : groups) {
            Optional<ITarmedGroup> group = TarmedGroup.find(groupName, tarmedLeistung.getLaw(), kons.getDate());
            if (!group.isPresent()) continue;
            limitations = group.get().getLimitations();
            for (TarmedLimitation tarmedLimitation : limitations) {
                Result<IBilled> result;
                if (!tarmedLimitation.isTestable() || (result = tarmedLimitation.test(kons, newVerrechnet)).isOK()) continue;
                return result;
            }
        }
        return new Result((Object)newVerrechnet);
    }

    public Result<IBilled> checkAge(IEncounter kons, TarmedLeistung tarmedLeistung, IBilled newVerrechnet) {
        Map<String, String> ext = tarmedLeistung.getExtension().getLimits();
        String limitsString = ext.get("ServiceAge");
        if (StringUtils.isNotBlank((CharSequence)limitsString)) {
            LocalDateTime consDate = new TimeTool(kons.getDate()).toLocalDateTime();
            IPatient patient = kons.getCoverage().getPatient();
            LocalDateTime geburtsdatum = patient.getDateOfBirth();
            if (geburtsdatum == null) {
                return new Result(Result.SEVERITY.WARNING, 9, "Patienten Alter nicht ok, kein Geburtsdatum angegeben", null, false);
            }
            long patientAgeDays = patient.getAgeAtIn(consDate, ChronoUnit.DAYS);
            List<TarmedLeistungAge> ageLimits = TarmedLeistungAge.of(limitsString, consDate);
            for (TarmedLeistungAge tarmedLeistungAge : ageLimits) {
                if (!tarmedLeistungAge.isValidOn(consDate.toLocalDate())) continue;
                if (tarmedLeistungAge.getFromDays() >= 0L && tarmedLeistungAge.getToDays() < 0L) {
                    if (patientAgeDays >= tarmedLeistungAge.getFromDays()) continue;
                    return new Result(Result.SEVERITY.WARNING, 9, "Patient ist zu jung, verrechenbar ab " + tarmedLeistungAge.getFromText(), (Object)newVerrechnet, false);
                }
                if (tarmedLeistungAge.getToDays() >= 0L && tarmedLeistungAge.getFromDays() < 0L) {
                    if (patientAgeDays <= tarmedLeistungAge.getToDays()) continue;
                    return new Result(Result.SEVERITY.WARNING, 9, "Patient ist zu alt, verrechenbar bis " + tarmedLeistungAge.getToText(), (Object)newVerrechnet, false);
                }
                if (tarmedLeistungAge.getToDays() < 0L || tarmedLeistungAge.getFromDays() < 0L || !(tarmedLeistungAge.getToDays() < tarmedLeistungAge.getFromDays() ? patientAgeDays > tarmedLeistungAge.getToDays() && patientAgeDays < tarmedLeistungAge.getFromDays() : patientAgeDays > tarmedLeistungAge.getToDays() || patientAgeDays < tarmedLeistungAge.getFromDays())) continue;
                return new Result(Result.SEVERITY.WARNING, 9, "Patienten Alter nicht ok, verrechenbar " + tarmedLeistungAge.getText(), (Object)newVerrechnet, false);
            }
        }
        return new Result((Object)newVerrechnet);
    }
}

