/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model;

import ch.elexis.base.ch.arzttarife.tarmed.ITarmedKumulation;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.TarmedKumulationArt;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedGroup;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class TarmedExclusive {
    private String slaveCode;
    private TarmedKumulationArt slaveType;

    public TarmedExclusive(ITarmedKumulation kumulation) {
        this.slaveCode = kumulation.getSlaveCode();
        this.slaveType = kumulation.getSlaveArt();
    }

    public boolean isMatching(ITarmedLeistung tarmedLeistung, TimeTool date) {
        if (this.slaveType == TarmedKumulationArt.CHAPTER) {
            return this.isMatchingChapter(tarmedLeistung);
        }
        if (this.slaveType == TarmedKumulationArt.SERVICE) {
            return this.slaveCode.equals(tarmedLeistung.getCode());
        }
        if (this.slaveType == TarmedKumulationArt.GROUP) {
            List<String> groups = tarmedLeistung.getServiceGroups(date.toLocalDate());
            return groups.contains(this.slaveCode);
        }
        if (this.slaveType == TarmedKumulationArt.BLOCK) {
            List<String> blocks = tarmedLeistung.getServiceBlocks(date.toLocalDate());
            return blocks.contains(this.slaveCode);
        }
        return false;
    }

    private boolean isMatchingChapter(ITarmedLeistung tarmedLeistung) {
        if (this.slaveCode.equals(tarmedLeistung.getCode())) {
            return true;
        }
        ITarmedLeistung parent = tarmedLeistung.getParent();
        if (parent != null) {
            return this.isMatchingChapter(parent);
        }
        return false;
    }

    public boolean isMatching(TarmedGroup tarmedGroup) {
        if (this.slaveType != TarmedKumulationArt.GROUP) {
            return false;
        }
        return this.slaveCode.equals(tarmedGroup.getCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TarmedKumulationArt.toString(this.slaveType)).append(" ").append(this.slaveCode);
        return sb.toString();
    }

    public TarmedKumulationArt getSlaveType() {
        return this.slaveType;
    }
}

