/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model;

import ch.elexis.base.ch.arzttarife.tarmed.ITarmedKumulation;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.TarmedKumulationArt;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedGroup;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLeistung;
import java.time.LocalDate;
import java.util.List;

public class TarmedExclusion {
    private String slaveCode;
    private TarmedKumulationArt slaveType;
    private boolean validSide;

    public TarmedExclusion(ITarmedKumulation kumulation) {
        this.slaveCode = kumulation.getSlaveCode();
        this.slaveType = kumulation.getSlaveArt();
        this.validSide = "1".equals(kumulation.getValidSide());
    }

    public boolean isMatching(TarmedLeistung tarmedLeistung, LocalDate date) {
        if (this.slaveType == TarmedKumulationArt.CHAPTER) {
            return this.isMatchingChapter(tarmedLeistung);
        }
        if (this.slaveType == TarmedKumulationArt.SERVICE) {
            return this.isMatchingService(tarmedLeistung);
        }
        if (this.slaveType == TarmedKumulationArt.GROUP) {
            List<String> groups = tarmedLeistung.getServiceGroups(date);
            return groups.contains(this.slaveCode);
        }
        return false;
    }

    private boolean isMatchingService(ITarmedLeistung tarmedLeistung) {
        return this.slaveCode.equals(tarmedLeistung.getCode());
    }

    private boolean isMatchingChapter(ITarmedLeistung tarmedLeistung) {
        if (this.slaveCode.equals(tarmedLeistung.getCode())) {
            return true;
        }
        ITarmedLeistung parent = tarmedLeistung.getParent();
        if (parent != null) {
            return this.isMatchingChapter(parent);
        }
        return false;
    }

    public boolean isMatching(TarmedGroup tarmedGroup) {
        if (this.slaveType != TarmedKumulationArt.GROUP) {
            return false;
        }
        return this.slaveCode.equals(tarmedGroup.getCode());
    }

    public boolean isValidSide() {
        return this.validSide;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TarmedKumulationArt.toString(this.slaveType)).append(" ").append(this.slaveCode);
        return sb.toString();
    }
}

