/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model.importer;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.base.ch.arzttarife.model.service.ConfigServiceHolder;
import ch.elexis.base.ch.arzttarife.tardoc.model.VersionUtil;
import ch.elexis.base.ch.arzttarife.tardoc.model.importer.BlockImporter;
import ch.elexis.base.ch.arzttarife.tardoc.model.importer.ChapterImporter;
import ch.elexis.base.ch.arzttarife.tardoc.model.importer.DefinitionImport;
import ch.elexis.base.ch.arzttarife.tardoc.model.importer.DeleteOldData;
import ch.elexis.base.ch.arzttarife.tardoc.model.importer.GroupImporter;
import ch.elexis.base.ch.arzttarife.tardoc.model.importer.ServiceImporter;
import ch.elexis.core.importer.div.importers.AccessWrapper;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jdt.Nullable;
import ch.rgw.tools.IJdbcLink;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=tardoc"})
public class TardocReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private static final Logger logger = LoggerFactory.getLogger(TardocReferenceDataImporter.class);
    public static final String ImportPrefix = "TARDOC_IMPORT_";
    protected JdbcLink cacheDb = null;
    protected String lang;
    private AccessWrapper aw;
    private String mdbFilename;
    private Set<String> cachedDbTables = null;
    protected int chapterCount;
    protected int servicesCount;

    public int getCurrentVersion() {
        return VersionUtil.getCurrentVersion(this.getLaw());
    }

    public IStatus performImport(@Nullable IProgressMonitor ipm, InputStream input, @Nullable Integer version) {
        if (ipm == null) {
            ipm = new NullProgressMonitor();
        }
        this.cacheDb = new JdbcLink("org.h2.Driver", "jdbc:h2:mem:tardoc_import", "h2");
        this.cacheDb.connect("", "");
        if (this.openAccessDatabase(input) != Status.OK_STATUS || this.deleteCachedAccessTables() != Status.OK_STATUS || this.importAllAccessTables() != Status.OK_STATUS) {
            this.cachedDbTables = null;
            return Status.CANCEL_STATUS;
        }
        ipm.beginTask(Messages.TarmedImporter_importLstg, this.chapterCount + this.servicesCount);
        this.lang = ConfigServiceHolder.get().get().getLocal("ablauf/sprache", "d").toUpperCase();
        ipm.subTask(Messages.TarmedImporter_connecting);
        IStatus ret = Status.OK_STATUS;
        try {
            try {
                DefinitionImport definitionImport;
                DeleteOldData deleteOldData = this.getDeleteOldData();
                ret = deleteOldData.delete(ipm);
                if (ret.isOK() && (ret = (definitionImport = this.getDefinitionImport()).doImport(ipm)).isOK()) {
                    GroupImporter groupImporter;
                    ChapterImporter chapterImporter = this.getChapterImporter();
                    chapterImporter.setChapterCount(this.chapterCount);
                    ret = chapterImporter.doImport(ipm);
                    if (ret.isOK() && (ret = (groupImporter = this.getGroupImporter()).doImport(ipm)).isOK()) {
                        BlockImporter blockImporter = this.getBlockImporter();
                        blockImporter.doImport(ipm);
                        if (ret.isOK()) {
                            ServiceImporter serviceImporter = this.getServiceImporter(chapterImporter);
                            serviceImporter.setServiceCount(this.servicesCount);
                            ret = serviceImporter.doImport(ipm);
                            if (ret.isOK()) {
                                if (version == null) {
                                    VersionUtil.setCurrentVersion(new TimeTool().toString(9), this.getLaw());
                                } else {
                                    VersionUtil.setCurrentVersion(version.toString(), this.getLaw());
                                }
                                ConfigServiceHolder.get().get().set("ch.elexis.data.importer.TarmedReferenceDataImporter/referenceinfoavailable", true);
                                ipm.done();
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Error importing TARDOC", (Throwable)ex);
                Status status = new Status(4, "ch.elexis.base.ch.arzttarife.model", ex.getMessage(), (Throwable)ex);
                if (this.deleteCachedAccessTables() != Status.OK_STATUS) {
                    return Status.CANCEL_STATUS;
                }
                this.cacheDb.disconnect();
                return status;
            }
        }
        finally {
            if (this.deleteCachedAccessTables() != Status.OK_STATUS) {
                return Status.CANCEL_STATUS;
            }
            this.cacheDb.disconnect();
        }
        return ret;
    }

    protected BlockImporter getBlockImporter() {
        return new BlockImporter(this.cacheDb, this.lang, this.getLaw());
    }

    protected GroupImporter getGroupImporter() {
        return new GroupImporter(this.cacheDb, this.lang, this.getLaw());
    }

    protected ServiceImporter getServiceImporter(ChapterImporter chapterImporter) {
        return new ServiceImporter(this.cacheDb, chapterImporter, this.lang, this.getLaw());
    }

    protected ChapterImporter getChapterImporter() {
        return new ChapterImporter(this.cacheDb, this.lang, this.getLaw());
    }

    protected DefinitionImport getDefinitionImport() {
        return new DefinitionImport(this.cacheDb, this.lang, this.getLaw());
    }

    protected DeleteOldData getDeleteOldData() {
        return new DeleteOldData(this.getLaw());
    }

    protected String getLaw() {
        return "";
    }

    private IStatus importAllAccessTables() {
        String tablename2 = "";
        try {
            this.chapterCount = this.aw.getDatabase().getTable("KAPITEL_TEXT").getRowCount();
            this.servicesCount = this.aw.getDatabase().getTable("LEISTUNG").getRowCount();
            for (String tablename2 : this.cachedDbTables) {
                try {
                    this.aw.convertTable(tablename2, (IJdbcLink)this.cacheDb);
                    this.createIndexForTable(tablename2, this.cacheDb);
                }
                catch (SQLException e) {
                    logger.error("Failed to import table " + tablename2, (Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            logger.error("Failed to process access file " + this.mdbFilename, (Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    private void createIndexForTable(String tablename, JdbcLink cacheDb) {
        String cacheTableName = ImportPrefix + tablename;
        if ("LEISTUNG_TEXT".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
            this.createIndexOn(cacheTableName, "_IDX2", "SPRACHE");
        } else if ("LEISTUNG_DIGNIQUALI".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
        } else if ("LEISTUNG_HIERARCHIE".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR_MASTER");
        } else if ("LEISTUNG_GRUPPEN".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
        } else if ("LEISTUNG_BLOECKE".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
        } else if ("LEISTUNG_KOMBINATION".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR_MASTER");
        } else if ("LEISTUNG_MENGEN_ZEIT".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR");
        } else if ("LEISTUNG_KUMULATION".equals(tablename)) {
            this.createIndexOn(cacheTableName, "_IDX1", "LNR_MASTER");
        }
    }

    private void createIndexOn(String tablename, String indexPrefix, String columnName) {
        JdbcLink.Stm stm = this.cacheDb.getStatement();
        try {
            stm.exec("CREATE INDEX " + tablename + indexPrefix + " on " + tablename + " (" + columnName + ");");
        }
        finally {
            this.cacheDb.releaseStatement(stm);
        }
        logger.debug("Created cache db index [" + tablename + indexPrefix + "] on [" + columnName + "]");
    }

    private IStatus openAccessDatabase(InputStream inputStream) {
        File file = this.convertInputStreamToFile(inputStream);
        if (this.mdbFilename == null) {
            this.mdbFilename = file.getName();
        }
        try {
            this.aw = new AccessWrapper(file);
            this.aw.setPrefixForImportedTableNames(ImportPrefix);
            this.cachedDbTables = this.aw.getDatabase().getTableNames();
        }
        catch (IOException e) {
            logger.error("Failed to open access file " + String.valueOf(file), (Throwable)e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private IStatus deleteCachedAccessTables() {
        String tablename2 = "";
        for (String tablename2 : this.cachedDbTables) {
            this.cacheDb.exec("DROP TABLE IF EXISTS " + tablename2);
        }
        return Status.OK_STATUS;
    }

    private File convertInputStreamToFile(InputStream input) {
        String prefix = "tardoc_db";
        String suffix = "tmp";
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile(prefix, suffix);
            tmpFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tmpFile);
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        catch (IOException e) {
            logger.error("Error reading input stream ...", (Throwable)e);
        }
        return tmpFile;
    }
}

