/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model.importer;

import ch.elexis.base.ch.arzttarife.tarmed.model.CustomExclusions;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.model.IBlob;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=tarmedcustomexclusions"}, service={IReferenceDataImporter.class})
public class TarmedCustomExlusionsReferenceDataImporter
extends AbstractReferenceDataImporter {
    private static final String REFERENCEDATA_CUSTOM_TARMEDEXCLUSIONS_VERSION = "referencedata/tarmed/customexclusions/version";
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    public int getCurrentVersion() {
        return ConfigServiceHolder.get().get(REFERENCEDATA_CUSTOM_TARMEDEXCLUSIONS_VERSION, 0);
    }

    public IStatus performImport(IProgressMonitor ipm, InputStream input, Integer newVersion) {
        IStatus ret = Status.OK_STATUS;
        try {
            Optional<IBlob> blob = CoreModelServiceHolder.get().load("Tarmed_Custom_Exclusions", IBlob.class);
            if (blob.isEmpty()) {
                blob = Optional.of((IBlob)CoreModelServiceHolder.get().create(IBlob.class));
                blob.get().setId("Tarmed_Custom_Exclusions");
            }
            ((IBlob)blob.get()).setStringContent(IOUtils.toString((InputStream)input, (String)"UTF-8"));
            CoreModelServiceHolder.get().save((Identifiable)blob.get());
        }
        catch (IOException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Exception importing custom exclusions", (Throwable)e);
            ret = Status.CANCEL_STATUS;
        }
        if (ret.isOK()) {
            CustomExclusions.update();
            if (newVersion != null) {
                ConfigServiceHolder.get().set(REFERENCEDATA_CUSTOM_TARMEDEXCLUSIONS_VERSION, newVersion.intValue());
            }
        }
        return ret;
    }
}

