/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.pandemie.model.importer;

import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.jpa.entities.PandemieLeistung;
import ch.rgw.tools.TimeTool;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=pandemie"})
public class PandemieReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public IStatus performImport(@Nullable IProgressMonitor monitor, InputStream input, @Nullable Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus ret = Status.OK_STATUS;
        ExcelWrapper exw = new ExcelWrapper();
        exw.setFieldTypes(new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, String.class, String.class, Double.class, TimeTool.class, TimeTool.class});
        if (exw.load(input, 0)) {
            int first = exw.getFirstRow();
            int last = exw.getLastRow();
            int count = last - first;
            if (monitor != null) {
                monitor.beginTask("Pandemie Tarif Import", count);
            }
            ArrayList<Object> imported = new ArrayList<Object>();
            ArrayList<Object> closed = new ArrayList<Object>();
            LocalDate now = LocalDate.now();
            int i = 0;
            while (i < last) {
                List line = exw.getRow(i);
                if (line == null) break;
                if (!line.isEmpty() && ((String)line.get(0)).equals("351")) {
                    List<PandemieLeistung> existing = this.getExisting((String)line.get(1), (String)line.get(4), this.getValidFrom(line));
                    if (!existing.isEmpty()) {
                        for (PandemieLeistung pandemieLeistung : existing) {
                            pandemieLeistung.setValidTo(this.getValidTo(line));
                            closed.add(pandemieLeistung);
                        }
                    } else {
                        PandemieLeistung pl = new PandemieLeistung();
                        pl.setPandemic((String)line.get(1));
                        pl.setChapter(this.getChapter(line));
                        pl.setCode((String)line.get(4));
                        pl.setTitle(StringUtils.abbreviate((String)((String)line.get(5)).replace("\n", "").replace("\r", ""), (int)255));
                        pl.setValidFrom(this.getValidFrom(line));
                        pl.setDescription((String)line.get(6));
                        pl.setOrg(StringUtils.abbreviate((String)((String)line.get(7)).replace("\n", ";").replace("\r", ""), (int)255));
                        if (this.isCents(line)) {
                            pl.setCents(this.getAsCents((String)line.get(13)));
                        } else {
                            pl.setTaxpoints(this.getAsTaxpoints((String)line.get(13)));
                        }
                        if (this.getValidTo(line).isBefore(now)) {
                            pl.setValidTo(this.getValidTo(line));
                        }
                        imported.add(pl);
                    }
                }
                ++i;
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Closing " + closed.size() + " and creating " + imported.size() + " tarifs");
            EntityUtil.save(closed);
            EntityUtil.save(imported);
            monitor.done();
            if (newVersion != null) {
                PandemieReferenceDataImporter.setCurrentVersion(newVersion);
            }
        }
        return ret;
    }

    private List<PandemieLeistung> getExisting(String pandemic, String code, LocalDate validFrom) {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        propertyMap.put("pandemic", pandemic);
        propertyMap.put("code", code);
        propertyMap.put("validFrom", validFrom);
        return EntityUtil.loadByNamedQuery(propertyMap, PandemieLeistung.class);
    }

    private boolean isCents(List<String> line) {
        String centortaxpoint = line.get(12);
        return centortaxpoint.equalsIgnoreCase("chf");
    }

    private int getAsCents(String string) {
        string = string.replaceAll(",", ".");
        try {
            double doubleValue = Double.parseDouble(string);
            return (int)(doubleValue * 100.0);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private int getAsTaxpoints(String string) {
        string = string.replaceAll(",", ".");
        try {
            double doubleValue = Double.parseDouble(string);
            return (int)doubleValue;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private LocalDate getLocalDate(String value) {
        try {
            if (value.isEmpty()) {
                return LocalDate.parse("02.11.2020", this.dateFormatter);
            }
            if (value.length() < 11) {
                return LocalDate.parse(value, this.dateFormatter);
            }
            return LocalDate.parse(value, this.dateTimeFormatter);
        }
        catch (DateTimeParseException pe) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not parse as local date [" + value + "]");
            throw pe;
        }
    }

    private LocalDate getValidFrom(List<String> line) {
        return this.getLocalDate(line.get(14).trim());
    }

    private LocalDate getValidTo(List<String> line) {
        if (StringUtils.isNotBlank((CharSequence)line.get(15).trim())) {
            return this.getLocalDate(line.get(15).trim());
        }
        return LocalDate.MAX;
    }

    private String getChapter(List<String> line) {
        return StringUtils.abbreviate((String)(line.get(2) + " | " + line.get(3)), (int)255);
    }

    public static void setCurrentVersion(int newVersion) {
        PandemieLeistung versionEntry = EntityUtil.load("VERSION", PandemieLeistung.class);
        if (versionEntry != null) {
            versionEntry.setChapter(Integer.toString(newVersion));
            EntityUtil.save(Collections.singletonList(versionEntry));
            return;
        }
        throw new IllegalArgumentException("No Version entry");
    }

    public int getCurrentVersion() {
        String chapter;
        PandemieLeistung versionEntry = EntityUtil.load("VERSION", PandemieLeistung.class);
        if (versionEntry != null && (chapter = versionEntry.getChapter()) != null) {
            try {
                return Integer.parseInt(chapter.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

