/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.psycho.model;

import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.base.ch.arzttarife.psycho.IPsychoLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.model.TarmedLeistung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.TarmedLeistung;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.types.VatInfo;
import ch.rgw.tools.Result;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PsychoLeistung
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.PsychoLeistung>
implements Identifiable,
IPsychoLeistung {
    public static final String STS_CLASS = "ch.elexis.data.PsychoLeistung";
    private static IBillableOptifier<PsychoLeistung> optifier;
    private IBillableVerifier verifier = new DefaultVerifier();

    public PsychoLeistung(ch.elexis.core.jpa.entities.PsychoLeistung entity) {
        super((EntityWithId)entity);
    }

    public synchronized IBillableOptifier<PsychoLeistung> getOptifier() {
        if (optifier == null) {
            optifier = new AbstractOptifier<PsychoLeistung>(CoreModelServiceHolder.get(), ContextServiceHolder.get()){

                public Result<IBilled> remove(IBilled billed, IEncounter encounter) {
                    Result ret = super.remove(billed, encounter);
                    if (!this.isPercent((PsychoLeistung)billed.getBillable())) {
                        this.updatePercent(billed);
                    }
                    return ret;
                }

                protected void setAmount(IBilled billed, double amount) {
                    super.setAmount(billed, amount);
                    this.updatePercent(billed);
                }

                protected void setPrice(PsychoLeistung billable, IBilled billed) {
                    Optional<IBillingSystemFactor> billingFactor = this.getFactor(billed.getEncounter());
                    if (billingFactor.isPresent()) {
                        billed.setFactor(billingFactor.get().getFactor());
                    } else {
                        billed.setFactor(1.0);
                    }
                    int points = 0;
                    if (billable.getTP() != null && !this.isPercent(billable)) {
                        try {
                            points = this.getPoints(billable, billed.getEncounter().getMandator());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    billed.setPoints(points);
                }

                private int getPoints(PsychoLeistung billable, IMandator mandator) {
                    TarmedLeistung.MandantType type = TarmedLeistung.getMandantType(mandator);
                    if (type == TarmedLeistung.MandantType.TARPSYAPPRENTICE) {
                        return Integer.valueOf(billable.getTP()) * 90;
                    }
                    return Integer.valueOf(billable.getTP()) * 100;
                }

                private void updatePercent(IBilled billed) {
                    List<IBilled> allPsycho = this.getAllPsycho(billed);
                    for (IBilled psychoBilled : allPsycho) {
                        if (!this.isPercent((PsychoLeistung)psychoBilled.getBillable())) continue;
                        this.setPercent(psychoBilled, allPsycho);
                    }
                }

                private List<IBilled> getAllPsycho(IBilled billed) {
                    ArrayList<IBilled> ret = new ArrayList<IBilled>();
                    ArrayList<IBilled> encounterPsycho = new ArrayList<IBilled>(this.getPsycho(billed.getEncounter().getBilled()));
                    for (IBilled encounterBilled : encounterPsycho) {
                        if (encounterBilled.getId().equals(billed.getId())) continue;
                        ret.add(encounterBilled);
                    }
                    if (!billed.isDeleted()) {
                        ret.add(billed);
                    }
                    return ret;
                }

                private boolean isPercent(PsychoLeistung billable) {
                    return billable.getTP().startsWith("%");
                }

                private void setPercent(IBilled billed, List<IBilled> allPsycho) {
                    int sumTP = 0;
                    for (IBilled psychoBilled : allPsycho) {
                        if (this.isPercent((PsychoLeistung)psychoBilled.getBillable())) continue;
                        sumTP = (int)((double)sumTP + (double)this.getPoints((PsychoLeistung)psychoBilled.getBillable(), psychoBilled.getEncounter().getMandator()) * psychoBilled.getAmount());
                    }
                    int percent = this.getPercent((PsychoLeistung)billed.getBillable());
                    billed.setPoints(sumTP);
                    billed.setPrimaryScale(percent);
                    System.out.println("Set percent [" + ((PsychoLeistung)billed.getBillable()).getCode() + "] tp [" + sumTP + "] scale [" + percent + "]");
                    CoreModelServiceHolder.get().save((Identifiable)billed);
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)billed);
                }

                private List<IBilled> getPsycho(List<IBilled> billed) {
                    return billed.stream().filter(b -> b.getBillable() instanceof PsychoLeistung).collect(Collectors.toList());
                }

                private int getPercent(PsychoLeistung billedPsycho) {
                    return Integer.parseInt(billedPsycho.getTP().substring(1));
                }

                public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
                    return BillingServiceHolder.get().getBillingSystemFactor(encounter.getCoverage().getBillingSystem().getName(), encounter.getDate());
                }
            };
        }
        return optifier;
    }

    public IBillableVerifier getVerifier() {
        return this.verifier;
    }

    public VatInfo getVatInfo() {
        return VatInfo.VAT_CH_ISTREATMENT;
    }

    public String getCodeSystemCode() {
        return "581";
    }

    public String getCodeSystemName() {
        return "Psychotherapie";
    }

    public String getCode() {
        return ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntity()).getCode();
    }

    public void setCode(String value) {
    }

    public String getText() {
        return ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntity()).getText();
    }

    public void setText(String value) {
        ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntityMarkDirty()).setCodeText(value);
    }

    @Override
    public LocalDate getValidFrom() {
        return ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntity()).getValidFrom();
    }

    @Override
    public void setValidFrom(LocalDate value) {
        ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntityMarkDirty()).setValidFrom(value);
    }

    @Override
    public LocalDate getValidTo() {
        return ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntity()).getValidUntil();
    }

    @Override
    public void setValidTo(LocalDate value) {
        ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntityMarkDirty()).setValidUntil(value);
    }

    @Override
    public String getTP() {
        return ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntity()).getTp();
    }

    @Override
    public void setTP(String value) {
        ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntityMarkDirty()).setTp(value);
    }

    @Override
    public String getDescription() {
        return ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntity()).getDescription();
    }

    @Override
    public void setDescription(String value) {
        ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntityMarkDirty()).setDescription(value);
    }

    public String getLabel() {
        return this.getCode() + " " + this.getText();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }

    @Override
    public String getLimitations() {
        return ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntity()).getLimitations();
    }

    @Override
    public void setLimitations(String value) {
        ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntityMarkDirty()).setLimitations(value);
    }

    @Override
    public String getExclusions() {
        return ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntity()).getExclusions();
    }

    @Override
    public void setExclusions(String value) {
        ((ch.elexis.core.jpa.entities.PsychoLeistung)this.getEntityMarkDirty()).setExclusions(value);
    }
}

