/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.occupational.model;

import ch.elexis.base.ch.arzttarife.model.service.CoreModelServiceHolder;
import ch.elexis.base.ch.arzttarife.occupational.IOccupationalLeistung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.types.VatInfo;
import ch.rgw.tools.Result;
import java.time.LocalDate;
import java.util.Optional;

public class OccupationalLeistung
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.OccupationalLeistung>
implements Identifiable,
IOccupationalLeistung {
    public static final String STS_CLASS = "ch.elexis.data.OccupationalLeistung";
    private static IBillableOptifier<OccupationalLeistung> optifier;
    private IBillableVerifier verifier = new DefaultVerifier();

    public OccupationalLeistung(ch.elexis.core.jpa.entities.OccupationalLeistung entity) {
        super((EntityWithId)entity);
    }

    public synchronized IBillableOptifier<OccupationalLeistung> getOptifier() {
        if (optifier == null) {
            optifier = new AbstractOptifier<OccupationalLeistung>(CoreModelServiceHolder.get(), ContextServiceHolder.get()){

                protected void setPrice(OccupationalLeistung billable, IBilled billed) {
                    billed.setFactor(1.0);
                    int points = 0;
                    if (billable.getTP() != null) {
                        try {
                            points = Integer.valueOf(billable.getTP());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    billed.setPoints(points);
                }

                public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
                    return Optional.empty();
                }

                public Result<IBilled> add(OccupationalLeistung billable, IEncounter encounter, double amount, boolean save) {
                    String law = encounter.getCoverage().getBillingSystem().getLaw().name();
                    if (!"UVG".equalsIgnoreCase(law)) {
                        return new Result(Result.SEVERITY.WARNING, 0, "Arbeitsmedizinische Vorsorgeuntersuchungen k\u00f6nnen nur bei Fall UVG verrechnet werden. Bitte einen separaten Fall mit Gesetz UVG anlegen.", null, false);
                    }
                    return super.add((IBillable)billable, encounter, amount, save);
                }
            };
        }
        return optifier;
    }

    public IBillableVerifier getVerifier() {
        return this.verifier;
    }

    public VatInfo getVatInfo() {
        return VatInfo.VAT_CH_NOTTREATMENT;
    }

    public String getCodeSystemCode() {
        return ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntity()).getCodeSystemCode();
    }

    public String getCodeSystemName() {
        return "Arbeitsmedizinische Vorsorgeuntersuchungen";
    }

    public String getCode() {
        return ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntity()).getCode();
    }

    public void setCode(String value) {
    }

    public String getText() {
        return ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntity()).getText();
    }

    public void setText(String value) {
        ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntityMarkDirty()).setCodeText(value);
    }

    @Override
    public LocalDate getValidFrom() {
        return ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntity()).getValidFrom();
    }

    @Override
    public void setValidFrom(LocalDate value) {
        ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntityMarkDirty()).setValidFrom(value);
    }

    @Override
    public LocalDate getValidTo() {
        return ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntity()).getValidUntil();
    }

    @Override
    public void setValidTo(LocalDate value) {
        ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntityMarkDirty()).setValidUntil(value);
    }

    @Override
    public String getTP() {
        return ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntity()).getTp();
    }

    @Override
    public void setTP(String value) {
        ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntityMarkDirty()).setTp(value);
    }

    @Override
    public String getDescription() {
        return ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntity()).getDescription();
    }

    @Override
    public void setDescription(String value) {
        ((ch.elexis.core.jpa.entities.OccupationalLeistung)this.getEntityMarkDirty()).setDescription(value);
    }

    public String getLabel() {
        return this.getCode() + " " + this.getText();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }
}

