/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.model.service;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelAdapterFactory;
import ch.elexis.base.ch.arzttarife.tarmedallowance.ITarmedAllowance;
import ch.elexis.base.ch.arzttarife.tarmedallowance.model.TarmedAllowance;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.TarmedPauschalen;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IStoreToStringContribution;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class TarmedPauschalenCodeElementService
implements ICodeElementServiceContribution,
IStoreToStringContribution {
    @Reference(target="(id=default)")
    private IElexisEntityManager entityManager;

    public String getSystem() {
        return "Tarmedpauschalen";
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.SERVICE;
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        Optional element;
        EntityManager em = (EntityManager)this.entityManager.getEntityManager();
        TypedQuery gtinQuery = em.createNamedQuery("TarmedPauschalen.code", TarmedPauschalen.class);
        gtinQuery.setParameter("code", (Object)code);
        List resultList = gtinQuery.getResultList();
        resultList = resultList.stream().filter(pl -> this.isValid((TarmedPauschalen)pl, context)).collect(Collectors.toList());
        if (resultList.size() > 0 && (element = ArzttarifeModelAdapterFactory.getInstance().getModelAdapter((EntityWithId)resultList.get(0), ITarmedAllowance.class, false)).isPresent()) {
            return Optional.of((ICodeElement)element.get());
        }
        return Optional.empty();
    }

    private boolean isValid(TarmedPauschalen pl, Map<Object, Object> context) {
        if (context != null && !context.isEmpty()) {
            LocalDate validDate = this.getDate(context);
            if (pl.getValidFrom() != null && validDate.isBefore(pl.getValidFrom())) {
                return false;
            }
            if (pl.getValidTo() != null && validDate.isAfter(pl.getValidTo())) {
                return false;
            }
        }
        return true;
    }

    private LocalDate getDate(Map<Object, Object> context) {
        Object date = context.get(ICodeElementService.ContextKeys.DATE);
        if (date instanceof LocalDate) {
            return (LocalDate)date;
        }
        IEncounter encounter = (IEncounter)context.get(ICodeElementService.ContextKeys.CONSULTATION);
        if (encounter != null) {
            return encounter.getDate();
        }
        return LocalDate.now();
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        return null;
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        if (identifiable instanceof TarmedAllowance) {
            return Optional.of("ch.elexis.data.TarmedPauschalen::" + identifiable.getId());
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        if (storeToString.startsWith("ch.elexis.data.TarmedPauschalen::")) {
            String[] split = this.splitIntoTypeAndId(storeToString);
            String id = split[1];
            EntityManager em = (EntityManager)this.entityManager.getEntityManager();
            EntityWithId dbObject = (EntityWithId)em.find(TarmedPauschalen.class, (Object)id);
            return Optional.ofNullable(ArzttarifeModelAdapterFactory.getInstance().getModelAdapter(dbObject, null, false).orElse(null));
        }
        return Optional.empty();
    }

    public List<Identifiable> loadFromStringWithIdPart(String partialStoreToString) {
        if (!partialStoreToString.startsWith("ch.elexis.data.TarmedPauschalen::")) {
            return Collections.emptyList();
        }
        String[] split = this.splitIntoTypeAndId(partialStoreToString);
        if (split != null && split.length == 2) {
            String id = split[1];
            Class<TarmedPauschalen> clazz = TarmedPauschalen.class;
            EntityManager em = (EntityManager)this.entityManager.getEntityManager();
            TypedQuery query = em.createQuery("SELECT entity FROM " + clazz.getSimpleName() + " entity WHERE entity.id LIKE :idpart", clazz);
            query.setParameter("idpart", (Object)(id + "%"));
            List found = query.getResultList();
            if (!found.isEmpty()) {
                ArzttarifeModelAdapterFactory adapterFactory = ArzttarifeModelAdapterFactory.getInstance();
                return found.parallelStream().map(e -> adapterFactory.getModelAdapter((EntityWithId)e, null, false).orElse(null)).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public Class<?> getEntityForType(String type) {
        if ("ch.elexis.data.TarmedPauschalen".equals(type)) {
            return TarmedPauschalen.class;
        }
        return null;
    }

    public String getTypeForEntity(Object entityInstance) {
        if (entityInstance instanceof TarmedPauschalen) {
            return "ch.elexis.data.TarmedPauschalen";
        }
        return null;
    }

    public String getTypeForModel(Class<?> interfaze) {
        Class entityClass = ArzttarifeModelAdapterFactory.getInstance().getEntityClass(interfaze);
        if (entityClass != null) {
            try {
                return this.getTypeForEntity(entityClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting type for model [" + String.valueOf(interfaze) + "]", (Throwable)e);
            }
        }
        return null;
    }
}

