/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher;

import ch.elexis.base.ch.arzttarife.ambulatory.AmbulantePauschalenTyp;
import ch.elexis.base.ch.arzttarife.ambulatory.IAmbulatoryAllowance;
import ch.elexis.base.ch.arzttarife.ambulatory.model.AmbulatoryAllowance;
import ch.elexis.base.ch.arzttarife.ambulatory.model.AmbulatoryAllowanceOptifier;
import ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher.CasemasterService;
import ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher.MapperService;
import ch.elexis.base.ch.arzttarife.tardoc.tarifmatcher.PatientClassificationSystemService;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.oaat_otma.PatientCase;
import ch.oaat_otma.Service;
import ch.oaat_otma.casemaster.CasemasterError;
import ch.oaat_otma.casemaster.CasemasterResult;
import ch.oaat_otma.mapper.MapperLogEntry;
import ch.oaat_otma.mapper.MapperResult;
import ch.rgw.tools.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.LoggerFactory;

public class TarifMatcher<T extends IBillable> {
    public static final int OK = 0;
    public static final int PREISAENDERUNG = 1;
    public static final int KUMULATION = 2;
    public static final int KOMBINATION = 3;
    public static final int EXKLUSION = 4;
    public static final int INKLUSION = 5;
    public static final int LEISTUNGSTYP = 6;
    public static final int NOTYETVALID = 7;
    public static final int NOMOREVALID = 8;
    public static final int PATIENTAGE = 9;
    public static final int EXKLUSIVE = 10;
    public static final int EXKLUSIONSIDE = 11;
    private CasemasterService casemasterService;
    private PatientClassificationSystemService patientClassificationSystemService;
    private MapperService mapperService;
    private IBillableOptifier<T> optifier;

    public TarifMatcher(IBillableOptifier<T> optifier) {
        this.optifier = optifier;
    }

    public Result<IBilled> evaluate(IBilled billed, IEncounter encounter) {
        if (this.casemasterService == null) {
            this.casemasterService = (CasemasterService)OsgiServiceUtil.getService(CasemasterService.class).orElseThrow();
        }
        if (this.patientClassificationSystemService == null) {
            this.patientClassificationSystemService = (PatientClassificationSystemService)OsgiServiceUtil.getService(PatientClassificationSystemService.class).orElseThrow();
        }
        if (this.mapperService == null) {
            this.mapperService = (MapperService)OsgiServiceUtil.getService(MapperService.class).orElseThrow();
        }
        Result ret = new Result((Object)billed);
        CasemasterResult result = this.casemasterService.getResult(billed, encounter);
        if (!result.errors.isEmpty() && ((CasemasterError)result.errors.get((int)0)).type == CasemasterError.CasemasterErrorType.MISSING_OR_INVALID_DIAGNOSIS) {
            return new Result(Result.SEVERITY.WARNING, 3, "Abrechnung einer Trigger Position " + billed.getCode() + " ohne ICD Diagnose nicht erlaubt.", null, false);
        }
        if (!result.patientCases.isEmpty() && !this.isPauschale(billed)) {
            for (PatientCase patientCase : result.patientCases) {
                this.patientClassificationSystemService.getResult(patientCase);
                if (patientCase.getGrouperResult() == null) continue;
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{patientCase.getGrouperResult().group}) && !"NO.ambP".equals(patientCase.getGrouperResult().group) && this.optifier instanceof AmbulatoryAllowanceOptifier) {
                    AmbulatoryAllowance pauschale = AmbulatoryAllowance.getFromCode(patientCase.getGrouperResult().group, AmbulantePauschalenTyp.PAUSCHALE, patientCase.getEntryDate());
                    if (pauschale == null || !(ret = this.optifier.add((IBillable)pauschale, encounter, 1.0, false)).isOK()) continue;
                    for (IBilled encounterBilled : encounter.getBilled()) {
                        if (encounterBilled.getBillable() instanceof IAmbulatoryAllowance) continue;
                        this.optifier.remove(encounterBilled, encounter);
                    }
                    continue;
                }
                MapperResult mapperResult = this.mapperService.getResult(patientCase);
                ArrayList<MapperLogEntry> noneInfoLog = new ArrayList<MapperLogEntry>(mapperResult.log.stream().filter(l -> l.level != MapperLogEntry.MapperLogEntryLevel.INFO).toList());
                if (noneInfoLog.isEmpty()) continue;
                noneInfoLog.sort((l, r) -> this.logEntrySortMap().get(l.level).compareTo(this.logEntrySortMap().get(r.level)));
                noneInfoLog.forEach(li -> LoggerFactory.getLogger(this.getClass()).info("Non info mapper log entry " + String.valueOf(li.level) + " - " + this.getMessage((MapperLogEntry)li)));
                List<MapperLogEntry> errorLog = noneInfoLog.stream().filter(l -> l.level != MapperLogEntry.MapperLogEntryLevel.WARNING).toList();
                if (errorLog.isEmpty()) continue;
                return new Result(Result.SEVERITY.WARNING, this.getWarningCode((MapperLogEntry)noneInfoLog.get(0)), this.getWarningMessage((MapperLogEntry)noneInfoLog.get(0), patientCase), null, false);
            }
        }
        return ret;
    }

    private Map<MapperLogEntry.MapperLogEntryLevel, Integer> logEntrySortMap() {
        return Map.of(MapperLogEntry.MapperLogEntryLevel.INFO, Integer.MAX_VALUE, MapperLogEntry.MapperLogEntryLevel.WARNING, Integer.MAX_VALUE, MapperLogEntry.MapperLogEntryLevel.MISSING_MASTER, 1, MapperLogEntry.MapperLogEntryLevel.TARDOC_VALIDATION_DELETE, 2, MapperLogEntry.MapperLogEntryLevel.TARDOC_VALIDATION_UPDATE, 2, MapperLogEntry.MapperLogEntryLevel.LKAAT_VALIDATION_TRIGGER, 3, MapperLogEntry.MapperLogEntryLevel.LKAAT_VALIDATION_NOT_FOUND, 3, MapperLogEntry.MapperLogEntryLevel.LKAAT_VALIDATION_DUPLICATE, 3);
    }

    private boolean isPauschale(IBilled billed) {
        return billed.getBillable() instanceof IAmbulatoryAllowance && ((IAmbulatoryAllowance)billed.getBillable()).getTyp() == AmbulantePauschalenTyp.PAUSCHALE;
    }

    private String getWarningMessage(MapperLogEntry mapperLogEntry, PatientCase patientCase) {
        switch (mapperLogEntry.level) {
            case MISSING_MASTER: {
                return "F\u00fcr die Zuschlagsleistung " + mapperLogEntry.tardocCode + " konnte keine passende Hauptleistung gefunden werden.";
            }
            case TARDOC_VALIDATION_DELETE: {
                if (mapperLogEntry.message != null && mapperLogEntry.message.contains("side")) {
                    return "Bei der Leistung  " + mapperLogEntry.tardocCode + "  muss die Seite angegeben werden.";
                }
                if (mapperLogEntry.message != null && mapperLogEntry.message.toLowerCase().contains("not combinable with")) {
                    return "Die Leistung  " + mapperLogEntry.tardocCode + " ist nicht kombinierbar mit " + this.getLogEntryMessageCodes(mapperLogEntry) + ".";
                }
                if (mapperLogEntry.message != null && mapperLogEntry.message.toLowerCase().contains("only combinable with")) {
                    return "Die Leistung  " + mapperLogEntry.tardocCode + " ist nicht kombinierbar mit " + this.getDiffServiceCodes(patientCase.groupServicesByCode(), this.getLogEntryMessageCodes(mapperLogEntry)) + ".";
                }
                return "Die Leistung " + mapperLogEntry.tardocCode + " ist nicht erlaubt.\n" + this.getMessage(mapperLogEntry);
            }
            case TARDOC_VALIDATION_UPDATE: {
                if (StringUtils.isNotBlank((CharSequence)mapperLogEntry.message)) {
                    return "Die Leistung " + mapperLogEntry.tardocCode + " muss angepasst werden.\n" + this.getMessage(mapperLogEntry);
                }
                return "Die Leistung muss angepasst werden.";
            }
            case LKAAT_VALIDATION_TRIGGER: {
                return "F\u00fcr die Trigger Position " + mapperLogEntry.serviceCode + " konnte keine passende Pauschale abgerechnet werden.";
            }
            case LKAAT_VALIDATION_NOT_FOUND: {
                return "Die Position konnte nich im Katalog gefunden werden.";
            }
            case LKAAT_VALIDATION_DUPLICATE: {
                return "Doppelte Position (inkl. Seite) ist nicht erlaubt.";
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(mapperLogEntry.level));
    }

    private String getDiffServiceCodes(List<Service> services, String onlyWithCodes) {
        ArrayList ret = new ArrayList();
        HashSet onlyWithCodesSet = new HashSet();
        Arrays.asList(onlyWithCodes.split(", ")).forEach(s -> {
            boolean bl = onlyWithCodesSet.add(s);
        });
        services.forEach(s -> {
            if (!onlyWithCodesSet.contains(s.code)) {
                ret.add(s.code);
            }
        });
        return ret.stream().collect(Collectors.joining(", "));
    }

    private String getLogEntryMessageCodes(MapperLogEntry mapperLogEntry) {
        if (mapperLogEntry.message.indexOf("[") > -1 && mapperLogEntry.message.indexOf("]") > -1) {
            return mapperLogEntry.message.substring(mapperLogEntry.message.indexOf("[") + 1, mapperLogEntry.message.indexOf("]"));
        }
        return "";
    }

    private String getMessage(MapperLogEntry mapperLogEntry) {
        if (mapperLogEntry.message != null) {
            return StringEscapeUtils.unescapeHtml4((String)mapperLogEntry.message);
        }
        return "";
    }

    private int getWarningCode(MapperLogEntry mapperLogEntry) {
        switch (mapperLogEntry.level) {
            case MISSING_MASTER: {
                return 3;
            }
            case TARDOC_VALIDATION_DELETE: {
                return 3;
            }
            case TARDOC_VALIDATION_UPDATE: {
                return 6;
            }
            case LKAAT_VALIDATION_TRIGGER: {
                return 6;
            }
            case LKAAT_VALIDATION_NOT_FOUND: {
                return 6;
            }
            case LKAAT_VALIDATION_DUPLICATE: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(mapperLogEntry.level));
    }
}

