/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model.importer;

import ch.elexis.base.ch.arzttarife.tardoc.model.importer.ChapterImporter;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.ImporterUtil;
import ch.elexis.core.jpa.entities.TardocExtension;
import ch.elexis.core.jpa.entities.TardocKumulation;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceImporter {
    private static final Logger logger = LoggerFactory.getLogger(ServiceImporter.class);
    private JdbcLink cacheDb;
    private String lang;
    private String law;
    private ChapterImporter chapterImporter;
    private String code;
    private TardocExtension extension;
    private Map<Object, Object> extensionMap;
    private TimeTool validFrom;
    private TimeTool validTo;
    private int serviceCount;
    private DateTimeFormatter tarmedFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd hh:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private HashMap<String, Integer> columnMap = new HashMap();

    public ServiceImporter(JdbcLink cacheDb, ChapterImporter chapterImporter, String lang, String law) {
        this.cacheDb = cacheDb;
        this.lang = lang;
        this.law = law;
        this.chapterImporter = chapterImporter;
        this.validFrom = new TimeTool();
        this.validTo = new TimeTool();
    }

    public void setServiceCount(int count) {
        this.serviceCount = count;
    }

    /*
     * Exception decompiling
     */
    public IStatus doImport(IProgressMonitor ipm) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean hasColumn(ResultSet res, String columnLabel) {
        Integer index = this.columnMap.get(columnLabel);
        if (index != null && index > 0) {
            return true;
        }
        if (index == null) {
            try {
                int found = res.findColumn(columnLabel);
                this.columnMap.put(columnLabel, found);
                return true;
            }
            catch (SQLException ex) {
                this.columnMap.put(columnLabel, -1);
                return false;
            }
        }
        return false;
    }

    private String getParentId(String chapterCode) {
        if (this.code.equals("09.0010") && StringUtils.isBlank((CharSequence)this.law)) {
            return this.chapterImporter.getIdForCode(chapterCode, LocalDate.of(2008, 1, 1), this.law);
        }
        return this.chapterImporter.getIdForCode(chapterCode, this.validFrom.toLocalDate(), this.law);
    }

    private void importKumulations() throws SQLException {
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ResultSet res = subStm.query(String.format("SELECT * FROM %sLEISTUNG_KUMULATION WHERE LNR_MASTER='%s' AND ART_MASTER='L'", "TARDOC_IMPORT_", this.code));){
                TimeTool fromTime = new TimeTool();
                TimeTool toTime = new TimeTool();
                ArrayList<Object> kumulations = new ArrayList<Object>();
                boolean skip = false;
                while (res != null && res.next()) {
                    skip = false;
                    fromTime.set(res.getString("GUELTIG_VON"));
                    toTime.set(res.getString("GUELTIG_BIS"));
                    TardocKumulation kumulation = new TardocKumulation();
                    kumulation.setMasterCode(this.code);
                    kumulation.setMasterArt(res.getString("ART_MASTER"));
                    kumulation.setSlaveCode(res.getString("LNR_SLAVE"));
                    kumulation.setSlaveArt(res.getString("ART_SLAVE"));
                    kumulation.setTyp(res.getString("TYP"));
                    kumulation.setView(res.getString("ANZEIGE"));
                    kumulation.setValidSide(res.getString("GUELTIG_SEITE"));
                    kumulation.setValidFrom(fromTime.toLocalDate());
                    kumulation.setValidTo(toTime.toLocalDate());
                    kumulation.setLaw(this.law);
                    HashMap<String, Object> propertyMap = new HashMap<String, Object>();
                    propertyMap.put("masterCode", kumulation.getMasterCode());
                    propertyMap.put("masterArt", kumulation.getMasterArt());
                    propertyMap.put("typ", kumulation.getTyp());
                    List<TardocKumulation> existing = EntityUtil.loadByNamedQuery(propertyMap, TardocKumulation.class);
                    if (existing != null && !existing.isEmpty()) {
                        for (TardocKumulation existingKumulation : existing) {
                            if (!existingKumulation.getSlaveCode().equals(kumulation.getSlaveCode()) || !existingKumulation.getSlaveArt().equals(kumulation.getSlaveArt()) || !existingKumulation.getValidFrom().isEqual(kumulation.getValidFrom()) || !existingKumulation.getValidTo().isEqual(kumulation.getValidTo())) continue;
                            skip = true;
                            break;
                        }
                    }
                    if (skip) continue;
                    kumulations.add(kumulation);
                }
                EntityUtil.save(kumulations);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
    }

    private String[] getCombinations() throws SQLException, IOException {
        String[] ret = new String[2];
        StringBuilder sbAnd = new StringBuilder();
        StringBuilder sbOr = new StringBuilder();
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            ResultSet rsub = subStm.query(String.format("SELECT * FROM %sLEISTUNG_KOMBINATION WHERE LNR_MASTER='%s'", "TARDOC_IMPORT_", this.code));
            List<Map<String, String>> validResults = ImporterUtil.getValidValueMaps(rsub, this.validFrom);
            if (!validResults.isEmpty()) {
                for (Map<String, String> map : validResults) {
                    String typ = map.get("TYP");
                    String slave = map.get("LNR_SLAVE");
                    if (typ == null) continue;
                    if (typ.equals("and")) {
                        if (sbAnd.length() > 0) {
                            sbAnd.append(",");
                        }
                        sbAnd.append(slave);
                        continue;
                    }
                    if (!typ.equals("or")) continue;
                    if (sbOr.length() > 0) {
                        sbOr.append(",");
                    }
                    sbOr.append(slave);
                }
            }
            rsub.close();
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
        ret[0] = sbAnd.toString();
        ret[1] = sbOr.toString();
        return ret;
    }

    private String getLimits() throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            ResultSet rsub = subStm.query(String.format("SELECT * FROM %sLEISTUNG_MENGEN_ZEIT WHERE LNR='%s' AND ART='L'", "TARDOC_IMPORT_", this.code));
            List<Map<String, String>> validResults = ImporterUtil.getValidValueMaps(rsub, this.validFrom);
            if (!validResults.isEmpty()) {
                for (Map<String, String> map : validResults) {
                    sb.append(map.get("OPERATOR")).append(",");
                    sb.append(map.get("MENGE")).append(",");
                    sb.append(map.get("ZR_ANZAHL")).append(",");
                    sb.append(map.get("PRO_NACH")).append(",");
                    sb.append(map.get("ZR_EINHEIT")).append(",");
                    sb.append(map.get("REGEL_EL_ABR")).append("#");
                }
            }
            rsub.close();
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
        return sb.toString();
    }

    private String getGroups() throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            ResultSet rsub = subStm.query(String.format("SELECT * FROM %sLEISTUNG_GRUPPEN WHERE LNR='%s'", "TARDOC_IMPORT_", this.code));
            List<Map<String, String>> validResults = ImporterUtil.getAllValueMaps(rsub);
            if (!validResults.isEmpty()) {
                for (Map<String, String> map : validResults) {
                    if (sb.length() == 0) {
                        sb.append(map.get("GRUPPE"));
                    } else {
                        sb.append(", " + map.get("GRUPPE"));
                    }
                    LocalDate from = ImporterUtil.getLocalDate(map, "GUELTIG_VON");
                    LocalDate to = LocalDate.parse(map.get("GUELTIG_BIS"), this.tarmedFormatter);
                    sb.append("[").append(from.toString()).append("|").append(to.toString()).append("]");
                }
            }
            rsub.close();
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
        return sb.toString();
    }

    private String getAge() throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            ResultSet rsub = subStm.query(String.format("SELECT * FROM %sLEISTUNG_ALTER WHERE LNR='%s'", "TARDOC_IMPORT_", this.code));
            List<Map<String, String>> validResults = ImporterUtil.getAllValueMaps(rsub);
            if (!validResults.isEmpty()) {
                for (Map<String, String> map : validResults) {
                    try {
                        StringBuilder def = new StringBuilder();
                        if (sb.length() == 0) {
                            def.append(this.getAgeDefinition(map));
                        } else {
                            def.append(", " + this.getAgeDefinition(map));
                        }
                        LocalDate from = ImporterUtil.getLocalDate(map, "GUELTIG_VON");
                        LocalDate to = LocalDate.parse(map.get("GUELTIG_BIS"), this.tarmedFormatter);
                        def.append("[").append(from.toString()).append("|").append(to.toString()).append("]");
                        sb.append(def.toString());
                    }
                    catch (IllegalStateException e) {
                        logger.warn("Exception on age import, continuing", (Throwable)e);
                    }
                }
            }
            rsub.close();
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
        return sb.toString();
    }

    private String getAgeDefinition(Map<String, String> map) {
        int toAge;
        StringBuilder sb = new StringBuilder();
        int fromAge = this.getAgeInt(map.get("VON_ALTER"), -1);
        if (!this.checkValidRange(fromAge, toAge = this.getAgeInt(map.get("BIS_ALTER"), -1).intValue())) {
            throw new IllegalStateException("Not valid age range from " + fromAge + " to " + toAge);
        }
        sb.append(fromAge);
        sb.append("|");
        sb.append(this.getToleranceInt(map.get("VON_TOLERANZ"), 0));
        sb.append("|");
        sb.append(toAge);
        sb.append("|");
        sb.append(this.getToleranceInt(map.get("BIS_TOLERANZ"), 0));
        sb.append("|");
        sb.append(map.get("ZR_EINHEIT"));
        return sb.toString();
    }

    private boolean checkValidRange(int fromAge, int toAge) {
        return fromAge != -1 || toAge != -1;
    }

    private Integer getToleranceInt(String string, int defaultValue) {
        if (string == null || string.isEmpty()) {
            return defaultValue;
        }
        try {
            return Float.valueOf(string).intValue();
        }
        catch (NumberFormatException fe) {
            throw new IllegalStateException(fe);
        }
    }

    private Integer getAgeInt(String string, int defaultValue) {
        if (string == null || string.isEmpty()) {
            return defaultValue;
        }
        try {
            return Float.valueOf(string).intValue();
        }
        catch (NumberFormatException fe) {
            throw new IllegalStateException(fe);
        }
    }

    private String getSlavesString() throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            ResultSet rsub = subStm.query(String.format("SELECT * FROM %sLEISTUNG_HIERARCHIE WHERE LNR_MASTER='%s'", "TARDOC_IMPORT_", this.code));
            List<Map<String, String>> validResults = ImporterUtil.getAllValueMaps(rsub);
            if (!validResults.isEmpty()) {
                for (Map<String, String> map : validResults) {
                    if (sb.length() == 0) {
                        sb.append(map.get("LNR_SLAVE"));
                    } else {
                        sb.append(", " + map.get("LNR_SLAVE"));
                    }
                    LocalDate from = ImporterUtil.getLocalDate(map, "GUELTIG_VON");
                    LocalDate to = LocalDate.parse(map.get("GUELTIG_BIS"), this.tarmedFormatter);
                    sb.append("[").append(from.toString()).append("|").append(to.toString()).append("]");
                }
            }
            rsub.close();
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
        return sb.toString();
    }

    private String[] getTexts() throws SQLException, IOException {
        String[] ret = new String[3];
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            ResultSet rsub = subStm.query(String.format("SELECT * FROM %sLEISTUNG_TEXT WHERE SPRACHE='%s' AND LNR='%s'", "TARDOC_IMPORT_", this.lang, this.code));
            List<Map<String, String>> validResults = ImporterUtil.getValidValueMaps(rsub, this.validFrom);
            if (!validResults.isEmpty()) {
                Map<String, String> row = ImporterUtil.getLatestMap(validResults);
                ret[0] = StringUtils.abbreviate((String)row.get("BEZ_255"), (int)255);
                ret[1] = row.get("MED_INTERPRET");
                ret[2] = row.get("TECH_INTERPRET");
            }
            rsub.close();
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
        return ret;
    }

    private String getQLDignitaet() throws SQLException, IOException {
        String ret = "";
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            ResultSet rsub = subStm.query(String.format("SELECT * FROM %sLEISTUNG_DIGNIQUALI WHERE LNR='%s'", "TARDOC_IMPORT_", this.code));
            List<Map<String, String>> validResults = ImporterUtil.getValidValueMaps(rsub, this.validFrom);
            if (!validResults.isEmpty()) {
                ret = ImporterUtil.getLatestMap(validResults).get("QL_DIGNITAET");
            }
            rsub.close();
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
        return ret;
    }

    private void initValidTime(ResultSet res) throws SQLException {
        this.validFrom.set(res.getString("GUELTIG_VON"));
        this.validTo.set(res.getString("GUELTIG_BIS"));
    }

    private String getId(ResultSet res) throws SQLException {
        return res.getString("LNR") + "-" + this.validFrom.toString(9) + this.getLawIdExtension();
    }

    private String getLawIdExtension() {
        if (this.law != null && !this.law.isEmpty()) {
            return "-" + this.law;
        }
        return "";
    }
}

