/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tardoc.model;

import ch.elexis.base.ch.arzttarife.model.service.ArzttarifeModelServiceHolder;
import ch.elexis.base.ch.arzttarife.tardoc.ITardocKumulation;
import ch.elexis.base.ch.arzttarife.tardoc.TardocKumulationArt;
import ch.elexis.base.ch.arzttarife.tardoc.TardocKumulationTyp;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocExclusion;
import ch.elexis.base.ch.arzttarife.tardoc.model.TardocExclusive;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.holder.XidServiceHolder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TardocKumulation
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.TardocKumulation>
implements Identifiable,
ITardocKumulation {
    public TardocKumulation(ch.elexis.core.jpa.entities.TardocKumulation entity) {
        super((EntityWithId)entity);
    }

    @Override
    public String getSlaveCode() {
        return ((ch.elexis.core.jpa.entities.TardocKumulation)this.getEntity()).getSlaveCode();
    }

    @Override
    public TardocKumulationArt getSlaveArt() {
        return TardocKumulationArt.ofArt(((ch.elexis.core.jpa.entities.TardocKumulation)this.getEntity()).getSlaveArt());
    }

    @Override
    public String getValidSide() {
        return ((ch.elexis.core.jpa.entities.TardocKumulation)this.getEntity()).getValidSide();
    }

    @Override
    public LocalDate getValidFrom() {
        return ((ch.elexis.core.jpa.entities.TardocKumulation)this.getEntity()).getValidFrom();
    }

    @Override
    public LocalDate getValidTo() {
        return ((ch.elexis.core.jpa.entities.TardocKumulation)this.getEntity()).getValidTo();
    }

    @Override
    public String getLaw() {
        return ((ch.elexis.core.jpa.entities.TardocKumulation)this.getEntity()).getLaw();
    }

    @Override
    public boolean isValidKumulation(LocalDate date) {
        return !(!date.isAfter(this.getValidFrom()) && !date.isEqual(this.getValidFrom()) || !date.isBefore(this.getValidTo()) && !date.isEqual(this.getValidTo()));
    }

    public static String getExclusions(String code, LocalDate date) {
        INamedQuery query = ArzttarifeModelServiceHolder.get().getNamedQuery(ITardocKumulation.class, new String[]{"masterCode", "typ"});
        List exclusions = query.executeWithParameters(query.getParameterMap(new Object[]{"masterCode", code, "typ", "E"}));
        if (exclusions == null || exclusions.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ITardocKumulation excl : exclusions) {
            if (excl.getSlaveArt() == TardocKumulationArt.GROUP || !excl.isValidKumulation(date)) continue;
            if (!sb.toString().isEmpty()) {
                sb.append(",");
            }
            sb.append(excl.getSlaveCode());
        }
        return sb.toString();
    }

    public static List<TardocExclusion> getExclusions(String mastercode, TardocKumulationArt masterType, LocalDate date, String law) {
        INamedQuery query = ArzttarifeModelServiceHolder.get().getNamedQuery(ITardocKumulation.class, new String[]{"masterCode", "masterArt", "typ"});
        List exclusions = query.executeWithParameters(query.getParameterMap(new Object[]{"masterCode", mastercode, "masterArt", masterType.getArt(), "typ", "E"}));
        if (law != null && !law.isEmpty()) {
            exclusions = new ArrayList(exclusions.stream().filter(e -> law.equals(e.getLaw())).collect(Collectors.toList()));
        }
        if (exclusions == null || exclusions.isEmpty()) {
            return Collections.emptyList();
        }
        exclusions = exclusions.stream().filter(k -> k.isValidKumulation(date)).collect(Collectors.toList());
        return exclusions.stream().map(k -> new TardocExclusion((ITardocKumulation)k)).collect(Collectors.toList());
    }

    public static List<TardocExclusive> getExclusives(String mastercode, TardocKumulationArt masterType, LocalDate date, String law) {
        INamedQuery query = ArzttarifeModelServiceHolder.get().getNamedQuery(ITardocKumulation.class, new String[]{"masterCode", "masterArt", "typ"});
        List exclusives = query.executeWithParameters(query.getParameterMap(new Object[]{"masterCode", mastercode, "masterArt", masterType.getArt(), "typ", "X"}));
        if (law != null && !law.isEmpty()) {
            exclusives = exclusives.stream().filter(e -> law.equals(e.getLaw())).collect(Collectors.toList());
        }
        if (exclusives == null || exclusives.isEmpty()) {
            return Collections.emptyList();
        }
        exclusives = exclusives.stream().filter(k -> k.isValidKumulation(date)).collect(Collectors.toList());
        return exclusives.stream().map(k -> new TardocExclusive((ITardocKumulation)k)).collect(Collectors.toList());
    }

    @Override
    public String getMasterCode() {
        return ((ch.elexis.core.jpa.entities.TardocKumulation)this.getEntity()).getMasterCode();
    }

    @Override
    public TardocKumulationArt getMasterArt() {
        return TardocKumulationArt.ofArt(((ch.elexis.core.jpa.entities.TardocKumulation)this.getEntity()).getMasterArt());
    }

    @Override
    public TardocKumulationTyp getTyp() {
        return TardocKumulationTyp.ofTyp(((ch.elexis.core.jpa.entities.TardocKumulation)this.getEntity()).getTyp());
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }
}

