/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.complementary.model.importer;

import ch.elexis.base.ch.arzttarife.model.service.ConfigServiceHolder;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.jpa.entities.ComplementaryLeistung;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=complementary"})
public class ComplementaryReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private static final String REFERENCEDATA_COMPLEMENTARY_VERSION = "referencedata/complementary/version";
    private static final Logger logger = LoggerFactory.getLogger(ComplementaryReferenceDataImporter.class);
    private int chapternr_index = 4;
    private int chaptertext_index = 5;
    private int code_index = 8;
    private int codetext_index = 9;
    private int description_index = 12;
    private int validfrom_index = 15;
    private int validto_index = 16;
    private DateTimeFormatter csvDateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private DateTimeFormatter elexisDateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    private void updateIndexes(List<String> line) {
        if (line != null && !line.isEmpty()) {
            if (line.contains("Kapitelbezeichung_D") && line.contains("ABRECHNUNGSZIFFERTEXT_D") && line.contains("DATUMVON")) {
                this.chapternr_index = line.indexOf("Kapitelziffer");
                this.chaptertext_index = line.indexOf("Kapitelbezeichung_D");
                this.code_index = line.indexOf("Abrechnungsziffer");
                this.codetext_index = line.indexOf("ABRECHNUNGSZIFFERTEXT_D");
                this.description_index = line.indexOf("Beschreibung");
                this.validfrom_index = line.indexOf("DATUMVON");
                this.validto_index = line.indexOf("DATUMBIS");
            } else {
                throw new IllegalStateException("Unknown CSV file format");
            }
        }
    }

    public IStatus performImport(@Nullable IProgressMonitor monitor, InputStream input, @Nullable Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(input, "ISO-8859-1")).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(';').build()).build();
            monitor.beginTask("Import Complementary", -1);
            ArrayList<Object> imported = new ArrayList<Object>();
            ArrayList<Object> closed = new ArrayList<Object>();
            String[] line = reader.readNext();
            this.updateIndexes(Arrays.asList(line));
            this.updateIndexForLang();
            while ((line = reader.readNext()) != null) {
                if (line.length < this.validto_index + 1 || !StringUtils.isNotBlank((CharSequence)line[0]) || !"590".equals(line[0]) || !StringUtils.isNotBlank((CharSequence)line[this.code_index])) continue;
                monitor.subTask(line[this.codetext_index]);
                LocalDate validFrom = LocalDate.parse(line[this.validfrom_index], this.csvDateTimeFormatter);
                LocalDate validTo = LocalDate.parse(line[this.validto_index], this.csvDateTimeFormatter);
                ComplementaryLeistung existing = this.getExisting(line[this.code_index], validFrom);
                if (existing != null) {
                    if (existing.getValidTo() != null && existing.getValidTo().equals(validTo)) continue;
                    existing.setValidTo(validTo);
                    closed.add(existing);
                    continue;
                }
                imported.add(this.createComplementary(line, validFrom, validTo));
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Closing " + closed.size() + " and creating " + imported.size() + " tarifs");
            EntityUtil.save(imported);
            EntityUtil.save(closed);
            monitor.done();
            if (newVersion != null) {
                ConfigServiceHolder.get().get().set(REFERENCEDATA_COMPLEMENTARY_VERSION, newVersion.intValue());
            }
            return Status.OK_STATUS;
        }
        catch (CsvValidationException | IOException uee) {
            logger.error("Could not import complementary tarif", uee);
            return Status.CANCEL_STATUS;
        }
    }

    private ComplementaryLeistung createComplementary(String[] line, LocalDate validFrom, LocalDate validTo) {
        String chapterString = line[this.chapternr_index] + " " + line[this.chaptertext_index];
        String id = this.getId(line[this.code_index], validFrom);
        ComplementaryLeistung complementary = new ComplementaryLeistung();
        complementary.setId(id);
        complementary.setChapter(chapterString);
        complementary.setCode(line[this.code_index]);
        complementary.setCodeText(line[this.codetext_index]);
        complementary.setDescription(line[this.description_index]);
        complementary.setValidFrom(validFrom);
        complementary.setValidTo(validTo);
        return complementary;
    }

    private String getId(String code, LocalDate validFrom) {
        return code + "-" + validFrom.format(this.elexisDateTimeFormatter);
    }

    private void updateIndexForLang() {
        String lang = ConfigServiceHolder.get().get().get("ablauf/sprache", "d").toUpperCase();
        int offset = 0;
        if ("I".equals(lang)) {
            offset = 2;
        } else if ("F".equals(lang)) {
            offset = 1;
        }
        this.codetext_index += offset;
        this.chaptertext_index += offset;
        this.description_index += offset;
    }

    private ComplementaryLeistung getExisting(String code, LocalDate validFrom) {
        return EntityUtil.load(this.getId(code, validFrom), ComplementaryLeistung.class);
    }

    public int getCurrentVersion() {
        return ConfigServiceHolder.get().get().get(REFERENCEDATA_COMPLEMENTARY_VERSION, 0);
    }
}

