/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.ambulatory.model.importer;

import ch.elexis.base.ch.arzttarife.ambulatory.AmbulantePauschalenTyp;
import ch.elexis.base.ch.arzttarife.model.service.ConfigServiceHolder;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jpa.entities.AmbulantePauschalen;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=ambulatorytarif"})
public class AmbulatoryTarifsReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private CSVReader reader;
    private String[] headers;
    private String lang;
    private String version;
    private long readLines;
    private InputStream input;
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public IStatus performImport(IProgressMonitor monitor, InputStream input, Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("Ambulantetarife Import", 100);
            this.input = input;
            this.lang = this.getLang();
            ArrayList<Object> imported = new ArrayList<Object>();
            ArrayList<Object> closed = new ArrayList<Object>();
            Optional<Object> line = Optional.empty();
            while ((line = this.getNextLine()).isPresent()) {
                AmbulantePauschalen ambulantePauschale2;
                if (this.version == null) {
                    this.version = (String)((Map)line.get()).get("version");
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Start importing version " + this.version);
                } else if (!this.version.equals(((Map)line.get()).get("version"))) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Stop importing version " + this.version + " encountered version " + (String)((Map)line.get()).get("version"));
                    break;
                }
                monitor.subTask((String)((Map)line.get()).get("code"));
                String linetype = (String)((Map)line.get()).get("type");
                if (linetype == null || !linetype.equals("P") && !linetype.equals("PZ")) continue;
                List<AmbulantePauschalen> existing = this.getExisting((String)((Map)line.get()).get("lkn"), this.getValidFrom((Map)line.get()));
                if (!existing.isEmpty()) {
                    for (AmbulantePauschalen ambulantePauschale2 : existing) {
                        if (ambulantePauschale2.getValidTo().equals(this.getValidTo((Map)line.get()))) {
                            ambulantePauschale2.setCode((String)((Map)line.get()).get("lkn"));
                            ambulantePauschale2.setText(this.getText((Map)line.get()));
                            ambulantePauschale2.setValidFrom(this.getValidFrom((Map)line.get()));
                            ambulantePauschale2.setValidTo(this.getValidTo((Map)line.get()));
                            imported.add(ambulantePauschale2);
                            continue;
                        }
                        ambulantePauschale2.setValidTo(this.getValidTo((Map)line.get()));
                        closed.add(ambulantePauschale2);
                    }
                    continue;
                }
                ambulantePauschale2 = new AmbulantePauschalen();
                ambulantePauschale2.setTyp(AmbulantePauschalenTyp.TRIGGER.getCode());
                ambulantePauschale2.setCode((String)((Map)line.get()).get("lkn"));
                ambulantePauschale2.setText(this.getText((Map)line.get()));
                ambulantePauschale2.setValidFrom(this.getValidFrom((Map)line.get()));
                ambulantePauschale2.setValidTo(this.getValidTo((Map)line.get()));
                imported.add(ambulantePauschale2);
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Closing " + closed.size() + " and creating " + imported.size() + " tarifs");
            EntityUtil.save(closed);
            EntityUtil.save(imported);
            monitor.done();
            if (newVersion != null) {
                AmbulatoryTarifsReferenceDataImporter.setCurrentVersion(newVersion);
            }
            return Status.OK_STATUS;
        }
        catch (IOException uee) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not import ambulatory allowance tarif", (Throwable)uee);
            return Status.CANCEL_STATUS;
        }
    }

    private String getLang() {
        String ret = ConfigServiceHolder.get().get().getLocal("ablauf/sprache", "de");
        if (ret.toLowerCase().equals("d")) {
            ret = "de";
        } else if (ret.toLowerCase().equals("f")) {
            ret = "fr";
        } else if (ret.toLowerCase().equals("i")) {
            ret = "it";
        }
        return ret;
    }

    private Optional<Map<String, String>> getNextLine() throws IOException {
        try {
            if (this.reader == null) {
                this.reader = new CSVReaderBuilder((Reader)new InputStreamReader(this.input, "UTF-8")).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(',').withQuoteChar('\"').build()).withKeepCarriageReturn(false).build();
                this.headers = this.reader.readNext();
                if (this.headers == null || this.headers.length == 0) {
                    return Optional.empty();
                }
                this.readLines = 0L;
            }
            ++this.readLines;
            return Optional.ofNullable(this.toMap(this.reader.readNext()));
        }
        catch (CsvValidationException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error reading next line");
            return Optional.empty();
        }
    }

    private Map<String, String> toMap(String[] values) {
        if (this.headers != null && values != null) {
            HashMap<String, String> ret = new HashMap<String, String>();
            int i = 0;
            while (i < this.headers.length) {
                ret.put(new String(this.headers[i]), values[i]);
                ++i;
            }
            return ret;
        }
        return null;
    }

    private String getText(Map<String, String> line) {
        return StringUtils.abbreviate((String)line.get("title_" + this.lang).replace("\n", ";").replace("\r", ""), (int)255);
    }

    private List<AmbulantePauschalen> getExisting(String code, LocalDate validFrom) {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        propertyMap.put("typ", AmbulantePauschalenTyp.TRIGGER.getCode());
        propertyMap.put("code", code);
        propertyMap.put("validFrom", validFrom);
        return EntityUtil.loadByNamedQuery(propertyMap, AmbulantePauschalen.class);
    }

    private LocalDate getValidFrom(Map<String, String> line) {
        return this.getLocalDate(line.get("valid_start").trim());
    }

    private LocalDate getValidTo(Map<String, String> line) {
        if (StringUtils.isNotBlank((CharSequence)line.get("valid_end").trim())) {
            return this.getLocalDate(line.get("valid_end").trim());
        }
        return LocalDate.MAX;
    }

    private LocalDate getLocalDate(String value) {
        try {
            if (value.isEmpty()) {
                return LocalDate.parse("01.01.2026", this.dateFormatter);
            }
            if (value.length() < 11) {
                return LocalDate.parse(value, this.dateFormatter);
            }
            return LocalDate.parse(value, this.dateTimeFormatter);
        }
        catch (DateTimeParseException pe) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not parse as local date [" + value + "]");
            throw pe;
        }
    }

    public static void setCurrentVersion(int newVersion) {
        AmbulantePauschalen versionEntry = EntityUtil.load("VERSION", AmbulantePauschalen.class);
        if (versionEntry != null) {
            versionEntry.setChapter(Integer.toString(newVersion));
            EntityUtil.save(Collections.singletonList(versionEntry));
            return;
        }
        throw new IllegalArgumentException("No Version entry");
    }

    public int getCurrentVersion() {
        String chapter;
        AmbulantePauschalen versionEntry = EntityUtil.load("VERSION", AmbulantePauschalen.class);
        if (versionEntry != null && (chapter = versionEntry.getChapter()) != null) {
            try {
                return Integer.parseInt(chapter.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

