/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde.findings.migrator.preferences;

import ch.elexis.base.befunde.findings.migrator.preferences.FindingsServiceComponent;
import ch.elexis.base.befunde.findings.migrator.preferences.MesswertFieldMapping;
import ch.elexis.base.befunde.findings.migrator.preferences.MesswertUtil;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.codes.TransientCoding;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.model.InputDataGroupComponent;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class MesswertMigrationSettings
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List<MesswertFieldMapping> localMappings;
    private TableViewer viewerBefundeMapping;
    private HashMap<String, Integer> availableCode;
    private Label statistics;

    public void init(IWorkbench workbench) {
        if (this.isMesswertAvailable()) {
            this.localMappings = MesswertUtil.getLocalMappings();
            this.availableCode = this.getAvailableCodes();
        }
    }

    protected Control createContents(Composite parent) {
        Composite parentComposite = new Composite(parent, 0);
        parentComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(parentComposite, 0);
        if (this.isMesswertAvailable()) {
            label.setText("Befunde Zuordnung:");
            label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.viewerBefundeMapping = new TableViewer(parentComposite, 67586);
            this.viewerBefundeMapping.getTable().setHeaderVisible(true);
            this.viewerBefundeMapping.getTable().setLinesVisible(true);
            GridData gd = new GridData(4, 4, true, false, 2, 1);
            gd.heightHint = 400;
            this.viewerBefundeMapping.getControl().setLayoutData((Object)gd);
            this.viewerBefundeMapping.setContentProvider((IContentProvider)new ArrayContentProvider());
            TableViewerColumn column = new TableViewerColumn(this.viewerBefundeMapping, 0);
            column.getColumn().setWidth(150);
            column.getColumn().setText("Messwert");
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof MesswertFieldMapping) {
                        return ((MesswertFieldMapping)element).getLocalFieldLabel();
                    }
                    return "?";
                }
            });
            column = new TableViewerColumn(this.viewerBefundeMapping, 0);
            column.getColumn().setWidth(150);
            column.getColumn().setText("Code");
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof MesswertFieldMapping) {
                        return ((MesswertFieldMapping)element).getFindingsCodeLabel();
                    }
                    return "";
                }
            });
            column.setEditingSupport(new EditingSupport((ColumnViewer)this.viewerBefundeMapping){

                protected void setValue(Object element, Object value) {
                    Set<String> keys = MesswertMigrationSettings.this.availableCode.keySet();
                    for (String key : keys) {
                        Integer fieldValue = MesswertMigrationSettings.this.availableCode.get(key);
                        if (!fieldValue.equals(value)) continue;
                        ((MesswertFieldMapping)element).setFindigsCode(key);
                    }
                    this.getViewer().update(element, null);
                }

                protected Object getValue(Object element) {
                    String fieldLabel;
                    Integer ret;
                    if (element instanceof MesswertFieldMapping && ((MesswertFieldMapping)element).isValidMapping() && (ret = MesswertMigrationSettings.this.availableCode.get(fieldLabel = ((MesswertFieldMapping)element).getFindingsCodeLabel())) != null) {
                        return ret;
                    }
                    return 0;
                }

                protected CellEditor getCellEditor(Object element) {
                    Set<String> keys = MesswertMigrationSettings.this.availableCode.keySet();
                    String[] displayValues = new String[keys.size()];
                    Iterator<String> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        String key;
                        displayValues[MesswertMigrationSettings.this.availableCode.get((Object)key).intValue()] = key = iterator.next();
                    }
                    return new ComboBoxCellEditor((Composite)MesswertMigrationSettings.this.viewerBefundeMapping.getTable(), displayValues);
                }

                protected boolean canEdit(Object element) {
                    return true;
                }
            });
            this.viewerBefundeMapping.setInput(this.localMappings);
            this.statistics = new Label(parentComposite, 0);
            this.reloadStatistics();
            Button btn = new Button(parentComposite, 8);
            btn.setText("Messwerte migrieren");
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Query query = new Query(Patient.class);
                    final List patients = query.execute();
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(MesswertMigrationSettings.this.getShell());
                    try {
                        dialog.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Messwerte Migration", patients.size());
                                int count = 0;
                                while (count < patients.size()) {
                                    Patient patient = (Patient)patients.get(count);
                                    monitor.subTask("Patient (" + count + "/" + patients.size() + ")");
                                    FindingsServiceComponent.getMigratorService().migratePatientsFindings(patient.getId(), IObservation.class, null);
                                    monitor.worked(1);
                                    if (monitor.isCanceled()) break;
                                    ++count;
                                }
                                monitor.done();
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        MessageDialog.openError((Shell)MesswertMigrationSettings.this.getShell(), (String)"Migration fehlgeschlagen", (String)("W\u00e4rend der Migration ist ein Fehler aufgetreten.\n" + ex.getMessage()));
                    }
                    MesswertMigrationSettings.this.reloadStatistics();
                }
            });
        } else {
            label.setText("Befunde nicht installiert.");
            label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        }
        return parentComposite;
    }

    private void reloadStatistics() {
        this.statistics.setText("Statistik l\u00e4dt ... ");
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final List<Messwert> messwerte = MesswertMigrationSettings.this.getAllMesswerte();
                final long notMigrated = MesswertMigrationSettings.this.countNotMigratedMesswerte(messwerte);
                if (MesswertMigrationSettings.this.statistics != null && !MesswertMigrationSettings.this.statistics.isDisposed()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).MesswertMigrationSettings.this.statistics.setText(messwerte.size() + " Messwerte vorhanden, davon sind " + notMigrated + " noch zu migrieren.");
                            (this).MesswertMigrationSettings.this.statistics.getParent().layout();
                        }
                    });
                }
            }
        });
    }

    private boolean isMesswertAvailable() {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("ch.elexis.befunde.Messwert");
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private List<Messwert> getAllMesswerte() {
        Query query = new Query(Messwert.class);
        return query.execute();
    }

    private long countNotMigratedMesswerte(List<Messwert> messwerte) {
        long ret = 0L;
        for (Messwert messwert : messwerte) {
            if ("__SETUP__".equals(messwert.getId()) || this.hasMigratedObservations(messwert.storeToString())) continue;
            ++ret;
        }
        return ret;
    }

    private boolean hasMigratedObservations(String originuri) {
        JdbcLink.Stm stm = PersistentObject.getDefaultConnection().getStatement();
        if (stm != null) {
            try {
                ResultSet result = stm.query("SELECT ID FROM CH_ELEXIS_CORE_FINDINGS_OBSERVATION WHERE originuri = '" + originuri + "';");
                boolean bl = result.next();
                return bl;
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error on migrated lookup", (Throwable)e);
            }
            finally {
                PersistentObject.getDefaultConnection().releaseStatement(stm);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected HashMap<String, Integer> getAvailableCodes() {
        void var6_11;
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ArrayList<String> codesStrings = new ArrayList<String>();
        FindingsTemplates templatesResource = FindingsServiceComponent.getTemplateService().getFindingsTemplates("Standard Vorlagen");
        EList templates = templatesResource.getFindingsTemplates();
        ArrayList<TransientCoding> codes = new ArrayList<TransientCoding>();
        for (FindingsTemplate findingsTemplate : templates) {
            if (findingsTemplate.getInputData() instanceof InputDataGroupComponent) {
                EList subTemplates = ((InputDataGroupComponent)findingsTemplate.getInputData()).getFindingsTemplates();
                for (FindingsTemplate subFindingsTemplate : subTemplates) {
                    codes.add(new TransientCoding(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), findingsTemplate.getTitle() + "." + subFindingsTemplate.getTitle(), subFindingsTemplate.getTitle()));
                }
                codes.add(new TransientCoding(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), findingsTemplate.getTitle(), findingsTemplate.getTitle()));
                continue;
            }
            codes.add(new TransientCoding(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), findingsTemplate.getTitle(), findingsTemplate.getTitle()));
        }
        for (ICoding iCoding : codes) {
            codesStrings.add(iCoding.getCode());
        }
        codesStrings.sort(new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareTo(arg1);
            }
        });
        ret.put("", 0);
        boolean bl = false;
        while (var6_11 < codesStrings.size()) {
            ret.put((String)codesStrings.get((int)var6_11), new Integer((int)(var6_11 + true)));
            ++var6_11;
        }
        return ret;
    }

    public boolean performOk() {
        MesswertUtil.saveMappings(this.localMappings);
        return super.performOk();
    }
}

