/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde.findings.migrator.messwert;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import java.util.ArrayList;
import java.util.List;

public class MesswertFieldMapping {
    private static final String MAPPING_CONFIG = "ch.elexis.core.findins/messwert/mapping";
    private String localMesswert;
    private String localMesswertField;
    private String findingsCode;
    private static final String MAPPING_FIELD_SEPARATOR_ESCAPED = "\\|\\|";
    private static final String MAPPING_SEPARATOR = "<->";
    private static final String MAPPING_TYPE = "_MESSWERTFIELDMAPPING_";

    public static MesswertFieldMapping createFromString(String string) {
        String[] mappings;
        MesswertFieldMapping mapping = new MesswertFieldMapping();
        if (string.startsWith(MAPPING_TYPE) && (mappings = (string = string.substring(MAPPING_TYPE.length(), string.length())).split(MAPPING_SEPARATOR)).length == 2) {
            String[] localMapping = mappings[0].split(MAPPING_FIELD_SEPARATOR_ESCAPED);
            if (localMapping.length == 2) {
                mapping.localMesswert = localMapping[0];
                mapping.localMesswertField = localMapping[1];
            }
            mapping.findingsCode = mappings[1];
        }
        return mapping.isValidMapping() ? mapping : null;
    }

    private MesswertFieldMapping() {
    }

    public boolean isLocalMatching(String befund, String field) {
        if (this.localMesswert != null && this.localMesswertField != null) {
            return this.localMesswert.equals(befund) && this.localMesswertField.equals(field);
        }
        return false;
    }

    public boolean isFindingsCodeMatching(String findingsCode) {
        if (this.findingsCode != null && findingsCode != null) {
            return this.findingsCode.equals(findingsCode);
        }
        return false;
    }

    public boolean isValidMapping() {
        return this.localMesswert != null && this.localMesswertField != null && this.findingsCode != null;
    }

    public String getLocalBefund() {
        return this.localMesswert;
    }

    public String getLocalBefundField() {
        return this.localMesswertField;
    }

    public String getFindingsCode() {
        return this.findingsCode;
    }

    public static List<MesswertFieldMapping> getMappings() {
        ArrayList<MesswertFieldMapping> ret = new ArrayList<MesswertFieldMapping>();
        if (ContextServiceHolder.get().getActiveMandator().isPresent()) {
            String[] mappings;
            String mapping = ConfigServiceHolder.getMandator((String)MAPPING_CONFIG, (String)"");
            String[] stringArray = mappings = mapping.split(";;");
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                MesswertFieldMapping createdMapping = MesswertFieldMapping.createFromString(string);
                if (createdMapping != null) {
                    ret.add(createdMapping);
                }
                ++n2;
            }
        } else {
            throw new IllegalStateException("No mandant config available");
        }
        return ret;
    }
}

