/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.befunde.findings.migrator.strategy;

import ch.elexis.base.befunde.findings.migrator.messwert.MesswertFieldMapping;
import ch.elexis.base.befunde.findings.migrator.strategy.AbstractMigrationStrategy;
import ch.elexis.base.befunde.findings.migrator.strategy.ComponentMigration;
import ch.elexis.base.befunde.findings.migrator.strategy.IMigrationStrategy;
import ch.elexis.base.befunde.findings.migrator.strategy.NumericMigration;
import ch.elexis.base.befunde.findings.migrator.strategy.TextMigration;
import ch.elexis.befunde.Messwert;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.model.InputDataGroupComponent;
import ch.elexis.core.findings.templates.model.InputDataNumeric;
import ch.elexis.core.findings.templates.model.InputDataText;
import ch.elexis.core.findings.templates.service.IFindingsTemplateService;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MesswertMigrationStrategyFactory {
    private static Logger logger = LoggerFactory.getLogger(MesswertMigrationStrategyFactory.class);
    private static IFindingsTemplateService tempalteService;
    private static HashMap<String, FindingsTemplate> codeToTemplateMap;

    static {
        codeToTemplateMap = new HashMap();
    }

    public static IMigrationStrategy get(final MesswertFieldMapping mapping, Messwert messwert, List<IObservation> createdObservations) {
        FindingsTemplate template = MesswertMigrationStrategyFactory.getTemplate(mapping);
        if (template != null) {
            if (template.getInputData() instanceof InputDataGroupComponent) {
                ComponentMigration migration = new ComponentMigration(mapping, messwert, createdObservations);
                migration.setTemplateService(tempalteService);
                migration.setTemplate(template);
                return migration;
            }
            if (template.getInputData() instanceof InputDataNumeric) {
                NumericMigration migration = new NumericMigration(mapping, messwert);
                migration.setTemplateService(tempalteService);
                migration.setTemplate(template);
                return migration;
            }
            if (template.getInputData() instanceof InputDataText) {
                TextMigration migration = new TextMigration(mapping, messwert);
                migration.setTemplateService(tempalteService);
                migration.setTemplate(template);
                return migration;
            }
        }
        return new AbstractMigrationStrategy(){

            @Override
            public Optional<IObservation> migrate() {
                logger.warn("No migration available for mapping " + mapping.getLocalBefund() + "." + mapping.getLocalBefundField() + " to " + mapping.getFindingsCode() + " using template " + (this.template != null ? this.template.getTitle() : "none"));
                return Optional.empty();
            }
        };
    }

    private static FindingsTemplate getTemplate(MesswertFieldMapping mapping) {
        FindingsTemplate template = codeToTemplateMap.get(mapping.getFindingsCode());
        if (template == null) {
            FindingsTemplates availableTemplates = tempalteService.getFindingsTemplates("Standard Vorlagen");
            String[] parts = mapping.getFindingsCode().split("\\.");
            if (parts.length > 0) {
                for (FindingsTemplate fTemplate : availableTemplates.getFindingsTemplates()) {
                    if (!fTemplate.getTitle().equals(parts[0])) continue;
                    codeToTemplateMap.put(mapping.getFindingsCode(), fTemplate);
                    template = fTemplate;
                    break;
                }
            }
        }
        return template;
    }

    public static void setFindingsTemplateService(IFindingsTemplateService service) {
        tempalteService = service;
    }

    public static void clearCodeToTemplateCache() {
        codeToTemplateMap.clear();
    }
}

