/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.wzw;

import ch.elexis.core.jpa.model.adapter.proxy.ModelAdapterProxyHandler;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.TimeTool;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractTimeSeries;
import ch.unibe.iam.scg.archie.ui.widgets.WidgetTypes;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class BaseStats
extends AbstractTimeSeries {
    protected String desc;
    protected String[] headings;
    private String dateMethod = "Rechnungsdatum";
    private boolean bOnlyActiveMandator;
    protected int clicksPerRound;
    protected int HUGE_NUMBER = 1000000;
    private List<IFilter> filters;

    public BaseStats(String name, String desc, String[] headings) {
        super(name);
        this.headings = headings;
        this.desc = desc;
    }

    @GetProperty(name="Nur aktueller Mandant", widgetType=WidgetTypes.BUTTON_CHECKBOX, index=1)
    public boolean getOnlyActiveMandator() {
        return this.bOnlyActiveMandator;
    }

    @SetProperty(name="Nur aktueller Mandant", index=1)
    public void setOnlyActiveMandator(boolean val) {
        this.bOnlyActiveMandator = val;
    }

    @GetProperty(widgetType=WidgetTypes.COMBO, description="Interpretation des Datums", index=1, items={"Rechnungsdatum", "Zahlungsdatum", "Konsultationsdatum"}, name="Datum-Typ")
    public String getDateType() {
        return this.dateMethod;
    }

    @SetProperty(index=1, name="Datum-Typ")
    public void setDateType(String dT) {
        this.dateMethod = dT;
    }

    public String getDescription() {
        return this.desc;
    }

    protected List<String> createHeadings() {
        return Arrays.asList(this.headings);
    }

    protected List<IEncounter> getConses(final IProgressMonitor monitor) {
        this.filters = new ArrayList<IFilter>();
        this.HUGE_NUMBER = 1000000;
        monitor.beginTask("Sammle Konsultationsdaten ", this.HUGE_NUMBER);
        monitor.subTask("Datenbankabfrage und PostQueryFilters");
        IQuery query = CoreModelServiceHolder.get().getQuery(IEncounter.class);
        String dateFrom = new TimeTool(this.getStartDate().getTime().getTime()).toString(9);
        String dateUntil = new TimeTool(this.getEndDate().getTimeInMillis()).toString(9);
        final TimeTool from = new TimeTool(dateFrom);
        final TimeTool to = new TimeTool(dateUntil);
        if (this.getDateType().equals("Konsultationsdatum")) {
            query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)from.toLocalDate());
            query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)to.toLocalDate());
        } else if (this.getDateType().equals("Rechnungsdatum")) {
            query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__INVOICE, IQuery.COMPARATOR.NOT_EQUALS, null);
            this.filters.add(new IFilter(){

                public boolean select(Object element) {
                    IEncounter k = (IEncounter)element;
                    monitor.subTask(k.getDate().toString());
                    monitor.worked(1);
                    --BaseStats.this.HUGE_NUMBER;
                    IInvoice rn = k.getInvoice();
                    if (rn != null) {
                        TimeTool rndate = new TimeTool(rn.getDate() != null ? new TimeTool(rn.getDate()) : new TimeTool(LocalDate.of(1900, 1, 1)));
                        return rndate.isAfterOrEqual(from) && rndate.isBeforeOrEqual(to);
                    }
                    return false;
                }
            });
        } else if (this.getDateType().equals("Zahlungsdatum")) {
            query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__INVOICE, IQuery.COMPARATOR.NOT_EQUALS, null);
            this.filters.add(new IFilter(){

                public boolean select(Object element) {
                    IEncounter k = (IEncounter)element;
                    monitor.subTask(k.getLabel());
                    monitor.worked(1);
                    --BaseStats.this.HUGE_NUMBER;
                    IInvoice rn = k.getInvoice();
                    if (rn != null && (rn.getState() == InvoiceState.PAID || rn.getState() == InvoiceState.EXCESSIVE_PAYMENT)) {
                        TimeTool rndate = new TimeTool(rn.getDate());
                        return rndate.isAfterOrEqual(from) && rndate.isBeforeOrEqual(to);
                    }
                    return false;
                }
            });
        }
        if (this.bOnlyActiveMandator) {
            query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__MANDATOR, IQuery.COMPARATOR.EQUALS, ContextServiceHolder.get().getActiveMandator().get());
        }
        ArrayList<IEncounter> ret = new ArrayList<IEncounter>();
        Throwable throwable = null;
        Object var9_10 = null;
        try (IQueryCursor cursor = query.executeAsCursor();){
            while (cursor.hasNext()) {
                IEncounter encounter = (IEncounter)cursor.next();
                boolean add = true;
                if (!this.filters.isEmpty()) {
                    for (IFilter filter : this.filters) {
                        if (filter.select((Object)encounter)) continue;
                        add = false;
                        break;
                    }
                }
                if (add) {
                    Object proxy = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{IEncounter.class}, (InvocationHandler)new ModelAdapterProxyHandler((Identifiable)encounter));
                    ret.add((IEncounter)proxy);
                }
                cursor.clear();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ret;
    }
}

