/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.views;

import ch.elexis.actions.Activator;
import ch.elexis.actions.AgendaActions;
import ch.elexis.actions.IBereichSelectionEvent;
import ch.elexis.agenda.BereichSelectionHandler;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.ICalTransfer;
import ch.elexis.agenda.ui.BereichMenuCreator;
import ch.elexis.agenda.util.AppointmentUtil;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IAppointmentSeries;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.agenda.CollisionErrorLevel;
import ch.elexis.core.model.builder.IAppointmentBuilder;
import ch.elexis.core.rcp.utils.OsgiServiceUtil;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.AppointmentHistoryServiceHolder;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.AppointmentState;
import ch.elexis.core.types.AppointmentType;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.dialogs.AppointmentDialog;
import ch.elexis.dialogs.RecurringAppointmentDialog;
import ch.elexis.dialogs.TagesgrenzenDialog;
import ch.elexis.dialogs.TerminListeDruckenDialog;
import ch.elexis.dialogs.TermineDruckenDialog;
import ch.rgw.tools.Log;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class BaseAgendaView
extends ViewPart
implements IRefreshable,
IBereichSelectionEvent {
    protected SelectionListener sListen = new SelectionListener();
    TableViewer tv;
    BaseAgendaView self;
    protected LockRequestingRestrictedAction<IAppointment> terminAendernAction;
    protected LockRequestingRestrictedAction<IAppointment> terminKuerzenAction;
    protected LockRequestingRestrictedAction<IAppointment> terminVerlaengernAction;
    protected RestrictedAction newTerminAction;
    protected IAction blockAction;
    protected IAction dayLimitsAction;
    protected IAction newViewAction;
    protected IAction printAction;
    protected IAction exportAction;
    protected IAction importAction;
    protected IAction printPatientAction;
    private BereichMenuCreator bmc = new BereichMenuCreator();
    MenuManager menu = new MenuManager();
    protected Log log = Log.get((String)"Agenda");
    Activator agenda = Activator.getDefault();
    private Timer timer;
    public static final String DATE_CHANGED = "ch/elexis/agenda/DATE_CHANGED";
    private IAppointmentService appointmentService;
    private IMenuManager mgr;
    private IAction bereichMenu;
    private long highestLastUpdate;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void reloadAppointment(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IAppointment.class.equals(clazz)) {
            CoreUiUtil.runAsyncIfActive(() -> this.tv.refresh(true), (Object)this.tv);
        }
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void createAppointment(@UIEventTopic(value="info/elexis/model/create") IAppointment appointment) {
        CoreUiUtil.runAsyncIfActive(() -> this.tv.refresh(true), (Object)this.tv);
    }

    @Inject
    void activeUser(@org.eclipse.e4.core.di.annotations.Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (user != null) {
                this.userChanged();
            }
        });
    }

    protected void userChanged() {
        this.updateActions();
        CoreUiUtil.runAsyncIfActive(() -> this.tv.getControl().setFont(UiDesk.getFont((String)"anwender/agendafont")), (Object)this.tv);
        this.setBereich(ConfigServiceHolder.getUser((String)"agenda/bereich", (String)this.agenda.getActResource()));
    }

    protected BaseAgendaView() {
        this.self = this;
        BereichSelectionHandler.addBereichSelectionListener(this);
        this.appointmentService = (IAppointmentService)OsgiServiceUtil.getService(IAppointmentService.class).get();
    }

    public abstract void create(Composite var1);

    public void createPartControl(Composite parent) {
        this.setBereich(ConfigServiceHolder.getUser((String)"agenda/bereich", (String)this.agenda.getActResource()));
        this.create(parent);
        this.makeActions();
        this.tv.setContentProvider((IContentProvider)new AgendaContentProvider());
        this.tv.setUseHashlookup(true);
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IAppointment pl = BaseAgendaView.this.getSelection();
                if (pl == null) {
                    BaseAgendaView.this.newTerminAction.run();
                } else if (pl.isRecurring()) {
                    AppointmentServiceHolder.get().getAppointmentSeries(pl).ifPresent(s -> {
                        RecurringAppointmentDialog dlg = new RecurringAppointmentDialog((IAppointmentSeries)s);
                        dlg.open();
                        BaseAgendaView.this.tv.refresh(true);
                    });
                } else {
                    if (BaseAgendaView.this.appointmentService.getType(AppointmentType.FREE).equals(pl.getType())) {
                        BaseAgendaView.this.openAppointmentDialog(pl, true, true);
                    } else {
                        BaseAgendaView.this.terminAendernAction.run();
                    }
                    BaseAgendaView.this.tv.refresh(true);
                }
            }
        });
        this.menu.setRemoveAllWhenShown(true);
        this.menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Optional selectedAppointment = ContextServiceHolder.get().getTyped(IAppointment.class);
                if (selectedAppointment.isEmpty()) {
                    manager.add((IAction)BaseAgendaView.this.newTerminAction);
                    manager.add(BaseAgendaView.this.blockAction);
                } else {
                    manager.add(AgendaActions.getTerminStatusAction());
                    manager.add(BaseAgendaView.this.terminKuerzenAction);
                    manager.add(BaseAgendaView.this.terminVerlaengernAction);
                    manager.add(BaseAgendaView.this.terminAendernAction);
                    manager.add(AgendaActions.getDelTerminAction());
                }
                BaseAgendaView.this.updateActions();
            }
        });
        Menu cMenu = this.menu.createContextMenu(this.tv.getControl());
        this.tv.getControl().setMenu(cMenu);
        this.tv.getControl().addListener(35, e -> {
            IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
            if (sel != null && !sel.isEmpty()) {
                Object o = sel.getFirstElement();
                if (o instanceof IAppointment) {
                    IAppointment appointment = (IAppointment)o;
                    if (!this.appointmentService.getType(AppointmentType.FREE).equals(appointment.getType())) {
                        ContextServiceHolder.get().setTyped((Object)appointment);
                        ((ESelectionService)this.getSite().getService(ESelectionService.class)).setSelection((Object)new StructuredSelection((Object)appointment));
                    }
                }
            } else {
                ContextServiceHolder.get().removeTyped(IAppointment.class);
                ((ESelectionService)this.getSite().getService(ESelectionService.class)).setSelection((Object)StructuredSelection.EMPTY);
            }
        });
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long lastUpdate = CoreModelServiceHolder.get().getHighestLastUpdate(IAppointment.class);
                BaseAgendaView.this.log.log("Agenda [" + lastUpdate + "]", 5);
                if (lastUpdate > BaseAgendaView.this.highestLastUpdate) {
                    BaseAgendaView.this.highestLastUpdate = lastUpdate;
                    BaseAgendaView.this.refresh();
                }
            }
        }, 10000L, 10000L);
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        this.tv.setInput((Object)this.getViewSite());
        this.updateActions();
        this.tv.addSelectionChangedListener((ISelectionChangedListener)this.sListen);
    }

    private Integer getPreferredDuration(String areaName, String type) {
        Map preferredDurations = this.appointmentService.getPreferredDurations(areaName);
        if (preferredDurations.containsKey(type)) {
            return (Integer)preferredDurations.get(type);
        }
        return 30;
    }

    public IAppointment getSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (sel == null || sel.isEmpty()) {
            return null;
        }
        IAppointment pl = (IAppointment)sel.getFirstElement();
        return pl;
    }

    public void dispose() {
        this.timer.cancel();
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    public void setFocus() {
        this.tv.getControl().setFocus();
    }

    public void refresh() {
        this.updateActions();
        this.reloadAppointment(IAppointment.class);
    }

    public void setBereich(String b) {
        this.agenda.setActResource(b);
    }

    public abstract void setAppointment(IAppointment var1);

    protected void updateActions() {
        this.dayLimitsAction.setEnabled(AccessControlServiceHolder.get().evaluate(EvACE.of(IAppointment.class, (Right)Right.UPDATE).and(Right.EXECUTE)));
        this.newTerminAction.reflectRight();
        this.terminKuerzenAction.reflectRight();
        this.terminVerlaengernAction.reflectRight();
        this.terminAendernAction.reflectRight();
        AgendaActions.updateActions();
    }

    protected void makeActions() {
        this.dayLimitsAction = new Action(Messages.BaseAgendaView_dayLimits){

            public void run() {
                new TagesgrenzenDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), BaseAgendaView.this.agenda.getActDate().toString(9), BaseAgendaView.this.agenda.getActResource()).open();
                BaseAgendaView.this.tv.refresh(true);
            }
        };
        this.dayLimitsAction.setId("ch.elexis.agenda.actions.dayLimitsAction");
        this.blockAction = new Action(Messages.TagesView_lockPeriod){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)BaseAgendaView.this.tv.getSelection();
                if (sel != null && !sel.isEmpty()) {
                    IAppointment appointment = (IAppointment)sel.getFirstElement();
                    if (BaseAgendaView.this.appointmentService.getType(AppointmentType.FREE).equals(appointment.getType())) {
                        appointment.setSchedule(BaseAgendaView.this.agenda.getActResource());
                        appointment.setSubjectOrPatient("");
                        appointment.setType(BaseAgendaView.this.appointmentService.getType(AppointmentType.BOOKED));
                        appointment.setState(BaseAgendaView.this.appointmentService.getState(AppointmentState.EMPTY));
                        appointment.setCreated(Integer.toString(TimeTool.getTimeInSeconds() / 60));
                        ContextServiceHolder.get().getActiveUser().ifPresent(au -> appointment.setCreatedBy(au.getLabel()));
                        CoreModelServiceHolder.get().save((Identifiable)appointment);
                        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
                    }
                }
            }
        };
        this.terminAendernAction = new LockRequestingRestrictedAction<IAppointment>((EvaluatableACE)EvACE.of(IAppointment.class, (Right)Right.UPDATE), Messages.TagesView_changeTermin){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.TagesView_changeThisTermin);
            }

            public IAppointment getTargetedObject() {
                return ContextServiceHolder.get().getTyped(IAppointment.class).orElse(null);
            }

            public void doRun(final IAppointment element) {
                AcquireLockBlockingUi.aquireAndRun((Identifiable)element, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        AppointmentDialog dlg = new AppointmentDialog(element);
                        dlg.setCollisionErrorLevel(CollisionErrorLevel.ERROR);
                        dlg.setScheduleChangeMode(true);
                        dlg.setExpanded(true);
                        if (dlg.open() == 0) {
                            AppointmentHistoryServiceHolder.get().logAppointmentEdit(element);
                        }
                    }
                });
                if (BaseAgendaView.this.tv != null) {
                    BaseAgendaView.this.tv.refresh(true);
                }
            }
        };
        this.terminKuerzenAction = new LockRequestingRestrictedAction<IAppointment>((EvaluatableACE)EvACE.of(IAppointment.class, (Right)Right.UPDATE), Messages.TagesView_shortenTermin){

            public IAppointment getTargetedObject() {
                return ContextServiceHolder.get().getTyped(IAppointment.class).orElse(null);
            }

            public void doRun(IAppointment element) {
                if (AppointmentUtil.isLocked(element)) {
                    return;
                }
                element.setEndTime(element.getStartTime().plusMinutes(element.getDurationMinutes() >> 1));
                CoreModelServiceHolder.get().save((Identifiable)element);
                ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
            }
        };
        this.terminVerlaengernAction = new LockRequestingRestrictedAction<IAppointment>((EvaluatableACE)EvACE.of(IAppointment.class, (Right)Right.UPDATE), Messages.TagesView_enlargeTermin){

            public IAppointment getTargetedObject() {
                return ContextServiceHolder.get().getTyped(IAppointment.class).orElse(null);
            }

            public void doRun(IAppointment t) {
                if (AppointmentUtil.isLocked(t)) {
                    return;
                }
                LocalDateTime oldEndTime = t.getEndTime();
                BaseAgendaView.this.agenda.setActDate(new TimeTool(t.getStartTime().toLocalDate()));
                List<IAppointment> appointments = BaseAgendaView.this.appointmentService.getAppointments(BaseAgendaView.this.agenda.getActResource(), BaseAgendaView.this.agenda.getActDate().toLocalDate(), false).stream().filter(a -> Plannables.isNotAllDay(a)).toList();
                appointments.stream().filter(a -> a.getStartTime().isAfter(t.getEndTime())).findFirst().ifPresent(a -> {
                    t.setEndTime(a.getStartTime());
                    if (AppointmentHistoryServiceHolder.get() != null) {
                        AppointmentHistoryServiceHolder.get().logAppointmentDurationChange(t, oldEndTime, t.getEndTime());
                    }
                    ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
                });
            }
        };
        this.newTerminAction = new RestrictedAction((EvaluatableACE)EvACE.of(IAppointment.class, (Right)Right.CREATE), Messages.TagesView_newTermin){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.TagesView_createNewTermin);
            }

            public void doRun() {
                IAppointment appointment = BaseAgendaView.this.getSelection();
                if (appointment != null && BaseAgendaView.this.appointmentService.getType(AppointmentType.FREE).equals(appointment.getType())) {
                    BaseAgendaView.this.openAppointmentDialog(appointment, true, true);
                } else {
                    LocalDateTime start = BaseAgendaView.this.agenda.getActDate().toLocalDateTime();
                    LocalDateTime end = start.plusMinutes(30L);
                    appointment = (IAppointment)new IAppointmentBuilder(CoreModelServiceHolder.get(), BaseAgendaView.this.agenda.getActResource(), start, end, AppointmentServiceHolder.get().getType(AppointmentType.DEFAULT), AppointmentServiceHolder.get().getState(AppointmentState.DEFAULT)).build();
                    BaseAgendaView.this.openAppointmentDialog(appointment, true, true);
                }
            }
        };
        this.printAction = new Action(Messages.BaseAgendaView_printDayList){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.BaseAgendaView_printListOfDay);
            }

            public void run() {
                List<IAppointment> appointments = BaseAgendaView.this.appointmentService.getAppointments(BaseAgendaView.this.agenda.getActResource(), BaseAgendaView.this.agenda.getActDate().toLocalDate(), true).stream().filter(a -> Plannables.isNotAllDay(a)).toList();
                TerminListeDruckenDialog dlg = new TerminListeDruckenDialog(BaseAgendaView.this.getViewSite().getShell(), appointments);
                dlg.open();
                if (BaseAgendaView.this.tv != null) {
                    BaseAgendaView.this.tv.refresh(true);
                }
            }
        };
        this.printPatientAction = new Action(Messages.BaseAgendaView_printPatAppointments){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.BaseAgendaView_printFutureAppsOfSelectedPatient);
            }

            public void run() {
                IPatient patient = ContextServiceHolder.get().getActivePatient().orElse(null);
                if (patient != null) {
                    IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class);
                    query.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SUBJECT_OR_PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient.getId());
                    query.and("tag", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.now());
                    query.orderBy("Tag", IQuery.ORDER.ASC);
                    query.orderByLeftPadded("Beginn", IQuery.ORDER.ASC);
                    List list = query.execute();
                    if (list != null) {
                        boolean directPrint = LocalConfigService.get((String)"agenda/print/appointmentcard_directprint", (boolean)false);
                        TermineDruckenDialog dlg = new TermineDruckenDialog(BaseAgendaView.this.getViewSite().getShell(), list);
                        if (directPrint) {
                            dlg.setBlockOnOpen(false);
                            dlg.open();
                            if (dlg.doPrint()) {
                                dlg.close();
                            } else {
                                SWTHelper.alert((String)Messages.BaseAgendaView_errorWhileprinting, (String)Messages.BaseAgendaView_errorHappendPrinting);
                            }
                        } else {
                            dlg.setBlockOnOpen(true);
                            dlg.open();
                        }
                    }
                }
            }
        };
        this.exportAction = new Action(Messages.BaseAgendaView_exportAgenda){
            {
                this.setToolTipText(Messages.BaseAgendaView_exportAppointsments);
                this.setImageDescriptor(Images.IMG_GOFURTHER.getImageDescriptor());
            }

            public void run() {
                ICalTransfer ict = new ICalTransfer();
                ict.doExport(BaseAgendaView.this.agenda.getActDate(), BaseAgendaView.this.agenda.getActDate(), BaseAgendaView.this.agenda.getActResource());
            }
        };
        this.importAction = new Action(Messages.BaseAgendaView_importAgenda){
            {
                this.setToolTipText(Messages.BaseAgendaView_importFromIcal);
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            }

            public void run() {
                ICalTransfer ict = new ICalTransfer();
                ict.doImport(BaseAgendaView.this.agenda.getActResource());
            }
        };
        this.bereichMenu = new Action(Messages.TagesView_bereich, 4){
            Menu mine;
            {
                this.setToolTipText(Messages.TagesView_selectBereich);
                this.setMenuCreator(BaseAgendaView.this.bmc);
            }
        };
        this.mgr = this.getViewSite().getActionBars().getMenuManager();
        this.mgr.add(this.bereichMenu);
        this.mgr.add(this.dayLimitsAction);
        this.mgr.add(this.newViewAction);
        this.mgr.add(this.exportAction);
        this.mgr.add(this.importAction);
        this.mgr.add(this.printAction);
        this.mgr.add(this.printPatientAction);
    }

    @Override
    public void bereichSelectionEvent(String bereich) {
        this.setPartName("Agenda " + bereich);
        this.reloadAppointment(IAppointment.class);
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    protected Color getTypColor(IAppointment p) {
        String coldesc = ConfigServiceHolder.getUserCached((String)("agenda/farben/typ/" + p.getType()), (String)"FFFFFF");
        return UiDesk.getColorFromRGB((String)coldesc);
    }

    protected Color getStateColor(IAppointment p) {
        if (this.appointmentService.getType(AppointmentType.BOOKED).equals(p.getType())) {
            String coldesc = ConfigServiceHolder.getUserCached((String)("agenda/farben/typ/" + p.getType()), (String)"000000");
            return UiDesk.getColorFromRGB((String)coldesc);
        }
        String coldesc = ConfigServiceHolder.getUserCached((String)("agenda/farben/status/" + p.getState()), (String)"000000");
        return UiDesk.getColorFromRGB((String)coldesc);
    }

    private void openAppointmentDialog(IAppointment appointment, boolean expanded, boolean scheduleChangeMode) {
        appointment.setType(AppointmentServiceHolder.get().getType(AppointmentType.DEFAULT));
        appointment.setState(AppointmentServiceHolder.get().getState(AppointmentState.DEFAULT));
        int minutes = this.getPreferredDuration(appointment.getSchedule(), appointment.getType());
        appointment.setEndTime(appointment.getStartTime().plusMinutes(minutes));
        appointment.setSubjectOrPatient(ContextServiceHolder.get().getActivePatient().map(p -> p.getId()).orElse(""));
        AppointmentDialog dlg = new AppointmentDialog(appointment);
        dlg.setCollisionErrorLevel(CollisionErrorLevel.ERROR);
        dlg.setExpanded(expanded);
        dlg.setScheduleChangeMode(scheduleChangeMode);
        dlg.open();
        if (this.tv != null) {
            this.tv.refresh(true);
        }
    }

    class AgendaContentProvider
    implements IStructuredContentProvider {
        AgendaContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IAppointment.class, (Right)Right.VIEW))) {
                String resource = BaseAgendaView.this.agenda.getActResource();
                TimeTool date = BaseAgendaView.this.agenda.getActDate();
                BaseAgendaView.this.appointmentService.assertBlockTimes(date.toLocalDate(), resource);
                return BaseAgendaView.this.appointmentService.getAppointments(resource, date.toLocalDate(), true).stream().filter(a -> Plannables.isNotAllDay(a)).toList().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class SelectionListener
    implements ISelectionChangedListener {
        StructuredViewer sv;

        SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            if (sel == null || sel.isEmpty()) {
                ContextServiceHolder.get().removeTyped(IAppointment.class);
                ((ESelectionService)BaseAgendaView.this.getSite().getService(ESelectionService.class)).setSelection((Object)StructuredSelection.EMPTY);
            } else {
                Object o = sel.getFirstElement();
                if (o instanceof IAppointment) {
                    IAppointment appointment = (IAppointment)o;
                    if (BaseAgendaView.this.appointmentService.getType(AppointmentType.FREE).equals(appointment.getType())) {
                        ContextServiceHolder.get().removeTyped(IAppointment.class);
                    } else {
                        BaseAgendaView.this.setAppointment(appointment);
                        ((ESelectionService)BaseAgendaView.this.getSite().getService(ESelectionService.class)).setSelection((Object)new StructuredSelection((Object)appointment));
                    }
                }
            }
        }
    }
}

