/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.preferences;

import ch.elexis.agenda.preferences.Messages;
import ch.elexis.agenda.preferences.PreferenceConstants;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Brief;
import ch.elexis.data.Query;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AgendaDruck
extends PreferencePage
implements IWorkbenchPreferencePage {
    Combo cTerminTemplate;
    Text tTerminPrinter;
    Button bTerminPrinterButton;
    Text tTerminTray;
    Composite cPrinterArea;
    Button bDirectPrint;
    PrinterSelector psel;

    public AgendaDruck() {
        this.setDescription(Messages.AgendaDruck_settingsForPrint);
    }

    protected Control createContents(Composite parent) {
        this.psel = new PrinterSelector();
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(3, false));
        new Label(ret, 0).setText(Messages.AgendaDruck_templateForCards);
        this.cTerminTemplate = new Combo(ret, 8);
        this.cTerminTemplate.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.bDirectPrint = new Button(ret, 32);
        this.bDirectPrint.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.bDirectPrint.setText(Messages.AgendaDruck_printDirectly);
        this.bDirectPrint.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AgendaDruck.this.refreshDirectPrint();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.cPrinterArea = new Composite(ret, 0);
        this.cPrinterArea.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.cPrinterArea.setLayout((Layout)new GridLayout(3, false));
        new Label(this.cPrinterArea, 0).setText(Messages.AgendaDruck_printerForCards);
        this.tTerminPrinter = new Text(this.cPrinterArea, 2056);
        this.tTerminPrinter.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tTerminPrinter.setData((Object)"TerminPrinter");
        this.bTerminPrinterButton = new Button(this.cPrinterArea, 8);
        this.bTerminPrinterButton.setText(" ->");
        this.bTerminPrinterButton.setData((Object)this.tTerminPrinter);
        this.bTerminPrinterButton.addSelectionListener((SelectionListener)this.psel);
        new Label(this.cPrinterArea, 0).setText(Messages.AgendaDruck_TrayForCards);
        this.tTerminTray = new Text(this.cPrinterArea, 2048);
        this.tTerminTray.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.setInitialValues();
        return ret;
    }

    private void refreshDirectPrint() {
        boolean directPrint = this.bDirectPrint.getSelection();
        if (directPrint) {
            this.cPrinterArea.setVisible(true);
        } else {
            this.cPrinterArea.setVisible(false);
        }
    }

    private void setTemplates() {
        this.cTerminTemplate.removeAll();
        this.cTerminTemplate.add("");
        String currentTemplate = CoreHub.localCfg.get("agenda/print/appointmentcard_template", PreferenceConstants.AG_PRINT_APPOINTMENTCARD_TEMPLATE_DEFAULT);
        Brief[] templates = this.getSystemTemplates();
        int i = 0;
        while (i < templates.length) {
            Brief brief = templates[i];
            String name = brief.getBetreff();
            this.cTerminTemplate.add(name);
            ++i;
        }
        this.cTerminTemplate.setText(currentTemplate);
    }

    private void setInitialValues() {
        this.setTemplates();
        this.tTerminPrinter.setText(CoreHub.localCfg.get("agenda/print/appointmentcard_printer_name", ""));
        this.tTerminTray.setText(CoreHub.localCfg.get("agenda/print/appointmentcard_printer_tray", ""));
        boolean directPrint = CoreHub.localCfg.get("agenda/print/appointmentcard_directprint", false);
        this.bDirectPrint.setSelection(directPrint);
        this.refreshDirectPrint();
    }

    public boolean performOk() {
        CoreHub.localCfg.set("agenda/print/appointmentcard_template", this.cTerminTemplate.getText());
        CoreHub.localCfg.set("agenda/print/appointmentcard_printer_name", this.tTerminPrinter.getText());
        CoreHub.localCfg.set("agenda/print/appointmentcard_printer_tray", this.tTerminTray.getText());
        CoreHub.localCfg.set("agenda/print/appointmentcard_directprint", this.bDirectPrint.getSelection());
        CoreHub.localCfg.flush();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private Brief[] getSystemTemplates() {
        Query qbe = new Query(Brief.class);
        qbe.add("Typ", "=", "Vorlagen");
        qbe.add("BehandlungsID", "=", "SYS");
        qbe.startGroup();
        qbe.add("DestID", "=", ContextServiceHolder.getActiveMandatorOrThrow().getId());
        qbe.or();
        qbe.add("DestID", "=", "");
        qbe.endGroup();
        qbe.and();
        qbe.add("geloescht", "<>", "1");
        qbe.orderBy(false, new String[]{"Datum"});
        List l = qbe.execute();
        if (l != null) {
            return l.toArray(new Brief[0]);
        }
        return new Brief[0];
    }

    class PrinterSelector
    extends SelectionAdapter {
        PrinterSelector() {
        }

        public void widgetSelected(SelectionEvent e) {
            PrintDialog pd = new PrintDialog(AgendaDruck.this.getShell());
            PrinterData pdata = pd.open();
            if (pdata != null) {
                Text tx = (Text)((Button)e.getSource()).getData();
                tx.setText(pdata.name);
                tx.setData((Object)pdata);
            }
        }
    }
}

