/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.data;

import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.CSVExporter;
import ch.elexis.agenda.data.Termin;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.MapTimeZoneCache;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICalTransfer {
    String[] bereiche;
    final String NOFILESELECTED = Messages.ICalTransfer_noFileSelected;
    String typ = Termin.typStandard();
    String status = Termin.statusStandard();
    Button bFile;
    Combo cbTypes;
    Combo cbStates;
    Button bAll;
    Label lFilename;
    private static Logger log = LoggerFactory.getLogger(ICalTransfer.class);

    public ICalTransfer() {
        this.bereiche = ConfigServiceHolder.getGlobal((String)"agenda/bereiche", (String)Messages.TagesView_14).split(",");
    }

    public void doExport(TimeTool von, TimeTool bis, String bereich) {
        if (von == null) {
            von = new TimeTool();
        }
        if (bis == null) {
            bis = new TimeTool();
        }
        if (bereich == null) {
            bereich = this.bereiche[0];
        }
        new ICalExportDlg(von, bis, bereich).open();
    }

    public void doImport(String bereich) {
        if (bereich == null) {
            bereich = this.bereiche[0];
        }
        new ICalImportDlg(bereich).open();
    }

    class ICalExportDlg
    extends TitleAreaDialog {
        TimeTool von;
        TimeTool bis;
        String m;
        DatePickerCombo dpVon;
        DatePickerCombo dpBis;
        Combo cbBereiche;
        FileDialog fileDialog;
        Label lFile;

        public ICalExportDlg(TimeTool from, TimeTool until, String bereich) {
            super(UiDesk.getTopShell());
            this.von = new TimeTool(from);
            this.bis = new TimeTool(until);
            this.m = bereich;
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            ret.setLayout((Layout)new GridLayout(3, false));
            new Label(ret, 0).setText(Messages.ICalTransfer_from);
            new Label(ret, 0).setText(Messages.ICalTransfer_until);
            new Label(ret, 0).setText(Messages.ICalTransfer_mandator);
            this.dpVon = new DatePickerCombo(ret, 0);
            this.dpBis = new DatePickerCombo(ret, 0);
            this.cbBereiche = new Combo(ret, 0);
            this.cbBereiche.setItems(ICalTransfer.this.bereiche);
            this.cbBereiche.setText(this.m);
            Button bChose = new Button(ret, 8);
            bChose.setText(Messages.ICalTransfer_file);
            bChose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ICalExportDlg.this.fileDialog = new FileDialog(ICalExportDlg.this.getShell(), 8192);
                    ICalExportDlg.this.fileDialog.setFilterExtensions(new String[]{"*.ics", "*.csv"});
                    ICalExportDlg.this.fileDialog.setFilterNames(new String[]{Messages.ICalTransfer_iCalFiles2, Messages.ICalTransfer_csvFIles});
                    String fileName = ICalExportDlg.this.fileDialog.open();
                    if (fileName == null) {
                        ICalExportDlg.this.lFile.setText(((ICalExportDlg)ICalExportDlg.this).ICalTransfer.this.NOFILESELECTED);
                        ICalExportDlg.this.getButton(0).setEnabled(false);
                    } else {
                        ICalExportDlg.this.lFile.setText(fileName);
                        ICalExportDlg.this.getButton(0).setEnabled(true);
                    }
                }
            });
            this.lFile = new Label(ret, 0);
            this.lFile.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
            this.lFile.setText(ICalTransfer.this.NOFILESELECTED);
            this.dpVon.setDate(this.von.getTime());
            this.dpBis.setDate(this.bis.getTime());
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.ICalTransfer_exportAgenda);
            this.setTitle(Messages.ICalTransfer_exportAgendaMandator);
            this.setMessage(Messages.ICalTransfer_pleaseSelectDateAndMandator);
            this.getButton(0).setEnabled(false);
        }

        protected void okPressed() {
            System.setProperty("net.fortuna.ical4j.timezone.cache.impl", MapTimeZoneCache.class.getName());
            this.von.setTimeInMillis(this.dpVon.getDate().getTime());
            this.bis.setTimeInMillis(this.dpBis.getDate().getTime());
            Query qbe = new Query(Termin.class);
            qbe.add("Tag", ">=", this.von.toString(9));
            qbe.add("Tag", "<=", this.bis.toString(9));
            qbe.add("BeiWem", "=", this.m);
            List termine = qbe.execute();
            String fname = this.lFile.getText();
            if (fname.toLowerCase().endsWith(".csv")) {
                new CSVExporter().doExport(fname, termine);
            } else {
                TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
                TimeZone timezone = registry.getTimeZone("Europe/Zurich");
                VTimeZone tz = timezone.getVTimeZone();
                Calendar calendar = new Calendar();
                calendar.getProperties().add((Property)new ProdId("-//ch.elexis//Elexis v" + CoreHub.Version));
                calendar.getProperties().add((Property)Version.VERSION_2_0);
                calendar.getProperties().add((Property)CalScale.GREGORIAN);
                for (Termin t : termine) {
                    if (t.getStartMinute() == 0 && t.getType().equals(Termin.typReserviert()) || t.getStartMinute() + t.getDurationInMinutes() == 1439 && t.getType().equals(Termin.typReserviert())) continue;
                    TimeTool tt = new TimeTool(t.getStartTime());
                    DateTime start = new DateTime(tt.getTime());
                    tt.addMinutes(t.getDurationInMinutes());
                    DateTime end = new DateTime(tt.getTime());
                    VEvent vTermin = new VEvent((Date)start, (Date)end, t.getPersonalia());
                    vTermin.getProperties().add((Property)tz.getTimeZoneId());
                    Uid uid = new Uid(t.getId());
                    vTermin.getProperties().add((Property)uid);
                    Description desc = new Description(t.getGrund());
                    vTermin.getProperties().add((Property)desc);
                    calendar.getComponents().add((Object)vTermin);
                }
                try {
                    FileOutputStream fout = new FileOutputStream(this.lFile.getText());
                    CalendarOutputter outputter = new CalendarOutputter();
                    outputter.output(calendar, (OutputStream)fout);
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    SWTHelper.alert((String)Messages.ICalTransfer_iOError, (String)MessageFormat.format(Messages.ICalTransfer_couldNotWriteFile, this.lFile.getText()));
                }
            }
            super.okPressed();
        }

        protected boolean isResizable() {
            return true;
        }
    }

    class ICalImportDlg
    extends TitleAreaDialog {
        String m;
        FileDialog fileDialog;

        public ICalImportDlg(String bereich) {
            super(UiDesk.getTopShell());
            this.m = bereich;
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            ret.setLayout((Layout)new GridLayout(2, false));
            ICalTransfer.this.bFile = new Button(ret, 8);
            ICalTransfer.this.lFilename = new Label(ret, 0);
            ICalTransfer.this.lFilename.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            ICalTransfer.this.lFilename.setText(ICalTransfer.this.NOFILESELECTED);
            ICalTransfer.this.bFile.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            ICalTransfer.this.bFile.setText(Messages.ICalTransfer_fileToImport);
            ICalTransfer.this.bFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ICalImportDlg.this.fileDialog = new FileDialog(ICalImportDlg.this.getShell(), 4096);
                    ICalImportDlg.this.fileDialog.setFilterExtensions(new String[]{"*.ics"});
                    ICalImportDlg.this.fileDialog.setFilterNames(new String[]{Messages.ICalTransfer_iCalFiles});
                    String file = ICalImportDlg.this.fileDialog.open();
                    if (file == null) {
                        ((ICalImportDlg)ICalImportDlg.this).ICalTransfer.this.lFilename.setText(((ICalImportDlg)ICalImportDlg.this).ICalTransfer.this.NOFILESELECTED);
                        ICalImportDlg.this.getButton(0).setEnabled(false);
                    } else {
                        ((ICalImportDlg)ICalImportDlg.this).ICalTransfer.this.lFilename.setText(file);
                        ICalImportDlg.this.getButton(0).setEnabled(true);
                    }
                }
            });
            new Label(ret, 0).setText(Messages.ICalTransfer_preselectType);
            ICalTransfer.this.cbTypes = new Combo(ret, 12);
            new Label(ret, 0).setText(Messages.ICalTransfer_preselectState);
            ICalTransfer.this.cbStates = new Combo(ret, 12);
            ICalTransfer.this.bAll = new Button(ret, 32);
            ICalTransfer.this.bAll.setText(Messages.ICalTransfer_newAppForAllMandators);
            ICalTransfer.this.bAll.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
            ICalTransfer.this.cbTypes.setItems(Termin.TerminTypes);
            ICalTransfer.this.cbStates.setItems(Termin.TerminStatus);
            ICalTransfer.this.cbTypes.setText(Termin.typStandard());
            ICalTransfer.this.cbStates.setText(Termin.statusStandard());
            ICalTransfer.this.cbTypes.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            ICalTransfer.this.cbStates.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.ICalTransfer_importAppointments);
            this.setTitle(Messages.ICalTransfer_ICalToAgenda);
            this.setMessage(Messages.ICalTransfer_pleaseSelectIcalFile);
            this.getButton(0).setEnabled(false);
        }

        protected void okPressed() {
            if (!ICalTransfer.this.lFilename.getText().equals(ICalTransfer.this.NOFILESELECTED)) {
                CalendarBuilder cb = new CalendarBuilder();
                String[] b = new String[]{this.m};
                if (ICalTransfer.this.bAll.getSelection()) {
                    b = ICalTransfer.this.bereiche;
                }
                try {
                    Calendar cal = cb.build((InputStream)new FileInputStream(ICalTransfer.this.lFilename.getText()));
                    TimeTool ttFrom = new TimeTool();
                    TimeTool ttUntil = new TimeTool();
                    Date dt = null;
                    ComponentList comps = cal.getComponents();
                    for (CalendarComponent comp : comps) {
                        Description desc;
                        if (!(comp instanceof VEvent)) continue;
                        VEvent event = (VEvent)comp;
                        DtStart start = event.getStartDate();
                        DtEnd end = event.getEndDate();
                        if (start != null) {
                            dt = start.getDate();
                            ttFrom.setTimeInMillis(dt.getTime());
                        } else {
                            ttFrom.set(new TimeTool());
                        }
                        if (end != null) {
                            dt = end.getDate();
                            ttUntil.setTimeInMillis(dt.getTime());
                        } else {
                            ttUntil.set(ttFrom);
                        }
                        Termin termin = null;
                        Uid uid = event.getUid();
                        String uuid = ElexisIdGenerator.generateId();
                        if (uid != null) {
                            uuid = uid.getValue();
                            termin = Termin.load(uuid);
                        }
                        if (termin == null || !termin.exists()) {
                            String[] stringArray = b;
                            int n = b.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String ber = stringArray[n2];
                                termin = new Termin(uuid, ber, ttFrom.toString(9), Termin.TimeInMinutes(ttFrom), Termin.TimeInMinutes(ttUntil), ICalTransfer.this.typ, ICalTransfer.this.status);
                                uuid = ElexisIdGenerator.generateId();
                                ++n2;
                            }
                        } else {
                            termin.set(new String[]{"BeiWem", "Tag", "Beginn", "Dauer", "Typ", "Status"}, new String[]{this.m, ttFrom.toString(9), Integer.toString(Termin.TimeInMinutes(ttFrom)), Integer.toString(ttFrom.secondsTo(ttUntil) / 60), ICalTransfer.this.typ, ICalTransfer.this.status});
                        }
                        if (termin == null) {
                            throw new IllegalStateException("termin is null");
                        }
                        Summary summary = event.getSummary();
                        if (summary != null) {
                            termin.setText(summary.getValue());
                        }
                        if ((desc = event.getDescription()) == null) continue;
                        termin.setGrund(desc.getValue());
                    }
                }
                catch (ParserException e) {
                    ExHandler.handle((Throwable)e);
                    SWTHelper.showError((String)Messages.ICalTransfer_badFileFormat, (String)Messages.ICalTransfer_noValidICal);
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    SWTHelper.showError((String)Messages.ICalTransfer_readError, (String)MessageFormat.format(Messages.ICalTransfer_couldNotReadFile, ICalTransfer.this.bFile.getText()));
                }
            }
            super.okPressed();
        }

        protected boolean isResizable() {
            return true;
        }
    }
}

