/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui;

import ch.elexis.actions.Activator;
import ch.elexis.actions.AgendaActions;
import ch.elexis.agenda.Messages;
import ch.elexis.agenda.data.ICalTransfer;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.agenda.CollisionErrorLevel;
import ch.elexis.core.model.builder.IAppointmentBuilder;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.AppointmentState;
import ch.elexis.core.types.AppointmentType;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.dialogs.AppointmentDialog;
import ch.elexis.dialogs.TerminListeDruckenDialog;
import ch.elexis.dialogs.TermineDruckenDialog;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.LoggerFactory;

public abstract class BaseView
extends ViewPart
implements Heartbeat.HeartListener,
IActivationListener {
    private static final String DEFAULT_PIXEL_PER_MINUTE = "1.0";
    public IAction newTerminAction;
    public IAction blockAction;
    public IAction dayLimitsAction;
    public IAction newViewAction;
    public IAction printAction;
    public IAction exportAction;
    public IAction importAction;
    public IAction printPatientAction;
    public IAction todayAction;
    public IAction refreshAction;
    MenuManager menu = new MenuManager();
    protected Activator agenda = Activator.getDefault();
    private IAppointmentService appointmentService = (IAppointmentService)OsgiServiceUtil.getService(IAppointmentService.class).get();
    private Timer timer;
    private long highestLastUpdate;

    @Optional
    @Inject
    void reloadAppointment(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IAppointment.class.equals(clazz)) {
            Display.getDefault().asyncExec(() -> this.internalRefresh());
        }
    }

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (user != null) {
                this.userChanged();
            }
        });
    }

    private void userChanged() {
        this.updateActions();
        this.agenda.setActResource(ConfigServiceHolder.getUser((String)"agenda/bereich", (String)this.agenda.getActResource()));
    }

    public void createPartControl(Composite parent) {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long lastUpdate = CoreModelServiceHolder.get().getHighestLastUpdate(IAppointment.class);
                LoggerFactory.getLogger(this.getClass()).debug("Agenda [" + lastUpdate + "]");
                if (lastUpdate > BaseView.this.highestLastUpdate) {
                    BaseView.this.highestLastUpdate = lastUpdate;
                    BaseView.this.refresh();
                }
            }
        }, 10000L, 10000L);
        this.makeActions();
        this.create(parent);
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.internalRefresh();
    }

    public void dispose() {
        this.timer.cancel();
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    protected abstract void create(Composite var1);

    protected abstract void refresh();

    protected abstract IAppointment getSelection();

    private void internalRefresh() {
        if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IAppointment.class, (Right)Right.VIEW))) {
            UiDesk.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BaseView.this.refresh();
                }
            });
        }
    }

    protected void checkDay(String resource, TimeTool date) {
        if (date == null) {
            date = this.agenda.getActDate();
        }
        if (resource == null) {
            resource = this.agenda.getActResource();
        }
        ((IAppointmentService)OsgiServiceUtil.getService(IAppointmentService.class).get()).assertBlockTimes(date.toLocalDate(), resource);
    }

    protected void updateActions() {
        this.dayLimitsAction.setEnabled(AccessControlServiceHolder.get().evaluate(EvACE.of(IAppointment.class, (Right)Right.UPDATE).and(Right.EXECUTE)));
        boolean canChangeAppointments = AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IAppointment.class, (Right)Right.UPDATE));
        this.newTerminAction.setEnabled(canChangeAppointments);
        AgendaActions.updateActions();
        this.internalRefresh();
    }

    public void heartbeat() {
        this.internalRefresh();
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
        } else {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        }
    }

    public static double getPixelPerMinute() {
        String ppm = CoreHub.localCfg.get("agenda/proportional/pixelperminute", DEFAULT_PIXEL_PER_MINUTE);
        try {
            double ret = Double.parseDouble(ppm);
            return ret;
        }
        catch (NumberFormatException ne) {
            CoreHub.localCfg.set("agenda/proportional/pixelperminute", DEFAULT_PIXEL_PER_MINUTE);
            return Double.parseDouble(DEFAULT_PIXEL_PER_MINUTE);
        }
    }

    protected void makeActions() {
        this.dayLimitsAction = new Action(Messages.BaseView_dayLimits){

            public void run() {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command cmd = commandService.getCommand("org.eclipse.ui.window.preferences");
                try {
                    HashMap<String, String> hm = new HashMap<String, String>();
                    hm.put("preferencePageId", "ch.elexis.agenda.tageseinteilung");
                    ExecutionEvent ev = new ExecutionEvent(cmd, hm, null, null);
                    cmd.executeWithChecks(ev);
                }
                catch (Exception exception) {
                    Status status = new Status(2, "ch.elexis.agenda", "Error opening preference page ch.elexis.agenda.tageseinteilung", (Throwable)exception);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
                BaseView.this.refresh();
            }
        };
        this.blockAction = new Action(Messages.TagesView_lockPeriod){

            public void run() {
                IAppointment appointment = BaseView.this.getSelection();
                if (appointment != null && BaseView.this.appointmentService.getType(AppointmentType.FREE).equals(appointment.getType())) {
                    appointment.setSchedule(BaseView.this.agenda.getActResource());
                    appointment.setSubjectOrPatient("");
                    appointment.setType(BaseView.this.appointmentService.getType(AppointmentType.BOOKED));
                    appointment.setState(BaseView.this.appointmentService.getState(AppointmentState.EMPTY));
                    appointment.setCreated(Integer.toString(TimeTool.getTimeInSeconds() / 60));
                    ContextServiceHolder.get().getActiveUser().ifPresent(au -> appointment.setCreatedBy(au.getLabel()));
                    CoreModelServiceHolder.get().save((Identifiable)appointment);
                    ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
                }
            }
        };
        this.newTerminAction = new Action(Messages.TagesView_newTermin){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.TagesView_createNewTermin);
            }

            public void run() {
                LocalDateTime start = BaseView.this.agenda.getActDate().toLocalDateTime();
                LocalDateTime end = start.plusMinutes(30L);
                IAppointment appointment = (IAppointment)new IAppointmentBuilder(CoreModelServiceHolder.get(), BaseView.this.agenda.getActResource(), start, end, AppointmentServiceHolder.get().getType(AppointmentType.DEFAULT), AppointmentServiceHolder.get().getState(AppointmentState.DEFAULT)).build();
                AppointmentDialog dlg = new AppointmentDialog(appointment);
                dlg.setCollisionErrorLevel(CollisionErrorLevel.ERROR);
                dlg.open();
                BaseView.this.internalRefresh();
            }
        };
        this.printAction = new Action(Messages.BaseView_printDayPaapintments){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.BaseView_printAPpointmentsOfSelectedDay);
            }

            public void run() {
                new TerminListeDruckenDialog(BaseView.this.getViewSite().getShell(), BaseView.this.appointmentService.getAppointments(BaseView.this.agenda.getActResource(), BaseView.this.agenda.getActDate().toLocalDate(), true).stream().filter(a -> Plannables.isNotAllDay(a)).toList()).open();
                BaseView.this.internalRefresh();
            }
        };
        this.printPatientAction = new Action(Messages.BaseView_printAppointments){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.BaseView_printFutureAppointmentsOfSelectedPatient);
            }

            public void run() {
                IPatient patient = ContextServiceHolder.get().getActivePatient().orElse(null);
                if (patient != null) {
                    IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class);
                    query.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SUBJECT_OR_PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient.getId());
                    query.and("tag", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.now());
                    query.orderBy("Tag", IQuery.ORDER.ASC);
                    query.orderByLeftPadded("Beginn", IQuery.ORDER.ASC);
                    List list = query.execute();
                    if (list != null) {
                        boolean directPrint = LocalConfigService.get((String)"agenda/print/appointmentcard_directprint", (boolean)false);
                        TermineDruckenDialog dlg = new TermineDruckenDialog(BaseView.this.getViewSite().getShell(), list);
                        if (directPrint) {
                            dlg.setBlockOnOpen(false);
                            dlg.open();
                            if (dlg.doPrint()) {
                                dlg.close();
                            } else {
                                SWTHelper.alert((String)Messages.BaseView_errorWhilePrinting, (String)Messages.BaseView_errorHappendPrinting);
                            }
                        } else {
                            dlg.setBlockOnOpen(true);
                            dlg.open();
                        }
                    }
                }
            }
        };
        this.exportAction = new Action(Messages.BaseView_exportAgenda){
            {
                this.setToolTipText(Messages.BaseView_exportAppojntmentsOfMandator);
                this.setImageDescriptor(Images.IMG_GOFURTHER.getImageDescriptor());
            }

            public void run() {
                ICalTransfer ict = new ICalTransfer();
                ict.doExport(BaseView.this.agenda.getActDate(), BaseView.this.agenda.getActDate(), BaseView.this.agenda.getActResource());
            }
        };
        this.importAction = new Action(Messages.BaseView_importAgenda){
            {
                this.setToolTipText(Messages.BaseView_importFromICal);
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            }

            public void run() {
                ICalTransfer ict = new ICalTransfer();
                ict.doImport(BaseView.this.agenda.getActResource());
            }
        };
        this.todayAction = new Action(Messages.BaseView_today){
            {
                this.setToolTipText(Messages.BaseView_showToday);
                this.setImageDescriptor(Activator.getImageDescriptor("icons/calendar_view_day.png"));
            }

            public void run() {
                BaseView.this.agenda.setActDate(new TimeTool());
                BaseView.this.internalRefresh();
            }
        };
        this.refreshAction = new Action(Messages.BaseView_refresh){
            {
                this.setToolTipText(Messages.BaseView_refresh);
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                BaseView.this.internalRefresh();
            }
        };
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add(this.dayLimitsAction);
        mgr.add(this.exportAction);
        mgr.add(this.importAction);
        mgr.add(this.printAction);
        mgr.add(this.printPatientAction);
        IToolBarManager tmr = this.getViewSite().getActionBars().getToolBarManager();
        tmr.add(this.refreshAction);
        tmr.add(this.todayAction);
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

