/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.preferences;

import ch.elexis.agenda.preferences.Messages;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.dialogs.AddKombiTerminDialog;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CombinedAppointments
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ListViewer areaListViewer;
    private TableViewer appointmentTableViewer;
    private ToolBarManager toolbarmgr;
    private String selectedArea;
    private List<TableEditor> editors = new ArrayList<TableEditor>();
    private Button deleteButton;

    public CombinedAppointments() {
        super(Messages.CombinedAppointments_Titel);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        SashForm sashForm = new SashForm(container, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite areaComposite = new Composite((Composite)sashForm, 0);
        areaComposite.setLayout((Layout)new GridLayout(1, false));
        this.areaListViewer = new ListViewer(areaComposite, 2560);
        this.areaListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.areaListViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.populateAreaList();
        Composite tableComposite = new Composite((Composite)sashForm, 0);
        tableComposite.setLayout((Layout)new GridLayout(1, false));
        this.toolbarmgr = new ToolBarManager();
        this.toolbarmgr.add((IAction)new AddKombiTermin());
        ToolBar toolbar = this.toolbarmgr.createControl(tableComposite);
        toolbar.setLayoutData((Object)new GridData(16384, 128, true, false));
        Composite tableContainer = new Composite(tableComposite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableColumnLayout);
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.appointmentTableViewer = new TableViewer(tableContainer, 67584);
        this.appointmentTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final Table appointmentTable = this.appointmentTableViewer.getTable();
        appointmentTable.setHeaderVisible(true);
        appointmentTable.setLinesVisible(true);
        this.createColumns(this.appointmentTableViewer, tableColumnLayout);
        sashForm.setWeights(new int[]{1, 3});
        appointmentTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] selection = appointmentTable.getSelection();
                if (selection.length > 0) {
                    String[] selectedAppointment = (String[])selection[0].getData();
                    CombinedAppointments.this.editAppointment(selectedAppointment);
                }
            }
        });
        return container;
    }

    private void populateAreaList() {
        List areas = ConfigServiceHolder.get().getAsList("agenda/TerminTypen");
        List filteredAppointmentTypes = areas.stream().skip(2L).collect(Collectors.toList());
        this.areaListViewer.setInput(filteredAppointmentTypes);
        this.areaListViewer.addSelectionChangedListener(event -> {
            this.selectedArea = (String)((StructuredSelection)event.getSelection()).getFirstElement();
            this.populateAppointments(this.selectedArea);
        });
    }

    private void populateAppointments(String area) {
        this.clearAllEditors();
        List kombiTermineList = ConfigServiceHolder.get().getAsList("agenda/kombitermine/" + area);
        ArrayList<String[]> appointments = new ArrayList<String[]>();
        for (String kombiTermin : kombiTermineList) {
            kombiTermin = kombiTermin.replaceAll("[{}]", "");
            String[] elements = kombiTermin.split(";");
            appointments.add(elements);
        }
        this.appointmentTableViewer.setInput(appointments);
        this.createColumns(this.appointmentTableViewer, (TableColumnLayout)this.appointmentTableViewer.getTable().getParent().getLayout());
        this.appointmentTableViewer.refresh();
    }

    private void createColumns(TableViewer viewer, TableColumnLayout layout) {
        String[] titles = new String[]{Messages.AddCombiTerminDialogReason, Messages.AppointmentDetailComposite_range, Messages.Core_Type, Messages.CombinedAppointmentsWhen, Messages.CombinedAppointmentsSpacing, Messages.Core_Date_Duration, ""};
        int[] bounds = new int[]{70, 70, 50, 40, 30, 30, 20};
        if (titles.length != bounds.length) {
            throw new IllegalStateException("Titles and bounds arrays must have the same length");
        }
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            TableColumn col = column.getColumn();
            col.setText(titles[i]);
            layout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(bounds[i]));
            if (i < titles.length - 1) {
                column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public void update(ViewerCell cell) {
                        String[] element = (String[])cell.getElement();
                        if (cell.getColumnIndex() < element.length) {
                            cell.setText(element[cell.getColumnIndex()]);
                        }
                    }
                });
            } else {
                column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public void update(ViewerCell cell) {
                        TableItem item = (TableItem)cell.getItem();
                        CombinedAppointments.this.deleteButton = new Button((Composite)cell.getViewerRow().getControl(), 0);
                        CombinedAppointments.this.deleteButton.setImage(Images.IMG_DELETE.getImage());
                        CombinedAppointments.this.deleteButton.addListener(13, e -> {
                            int index = CombinedAppointments.this.appointmentTableViewer.getTable().indexOf(item);
                            CombinedAppointments.this.deleteAppointment(index);
                        });
                        TableEditor editor = new TableEditor(item.getParent());
                        editor.grabHorizontal = true;
                        editor.grabVertical = true;
                        editor.setEditor((Control)CombinedAppointments.this.deleteButton, item, cell.getColumnIndex());
                        CombinedAppointments.this.editors.add(editor);
                    }
                });
            }
            ++i;
        }
    }

    private void editAppointment(String[] appointmentData) {
        AddKombiTerminDialog dialog = new AddKombiTerminDialog(this.getShell(), this.selectedArea, appointmentData);
        if (dialog.open() == 0) {
            this.populateAppointments(this.selectedArea);
        }
    }

    private void deleteAppointment(int index) {
        this.clearAllEditors();
        List currentAppointments = (List)this.appointmentTableViewer.getInput();
        currentAppointments.remove(index);
        ArrayList<CallSite> updatedKombiTermine = new ArrayList<CallSite>();
        for (CharSequence[] appointment : currentAppointments) {
            String combined = "{" + String.join((CharSequence)";", appointment) + "}";
            updatedKombiTermine.add((CallSite)((Object)combined));
        }
        ConfigServiceHolder.setGlobalAsList((String)("agenda/kombitermine/" + this.selectedArea), updatedKombiTermine);
        this.appointmentTableViewer.refresh();
        this.populateAppointments(this.selectedArea);
    }

    public void init(IWorkbench workbench) {
    }

    private void clearAllEditors() {
        for (TableEditor editor : this.editors) {
            editor.getEditor().dispose();
            editor.dispose();
        }
        this.editors.clear();
    }

    private class AddKombiTermin
    extends Action {
        private AddKombiTermin() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_NEW.getImageDescriptor();
        }

        public String getToolTipText() {
            return Messages.CombinedAppointments_ToolTipText;
        }

        public void run() {
            AddKombiTerminDialog dialog;
            if (CombinedAppointments.this.selectedArea != null && (dialog = new AddKombiTerminDialog(CombinedAppointments.this.getShell(), CombinedAppointments.this.selectedArea)).open() == 0) {
                CombinedAppointments.this.populateAppointments(CombinedAppointments.this.selectedArea);
            }
        }
    }
}

