/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.commands;

import ch.elexis.core.mail.AttachmentsUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class EmailEditHandler {
    private static final String MAIL_COMMAND_ID = "ch.elexis.core.mail.ui.sendMail";
    private static final String MAIL_TO_PARAM = "ch.elexis.core.mail.ui.sendMail.to";
    private static final String MAIL_ACCOUNTID_PARAM = "ch.elexis.core.mail.ui.sendMail.accountid";
    private static final String MAIL_TEXT_PARAM = "ch.elexis.core.mail.ui.sendMail.text";
    private static final String MAIL_SUBJECT_PARAM = "ch.elexis.core.mail.ui.sendMail.subject";
    private static final String MAIL_DO_SEND_PARAM = "ch.elexis.core.mail.ui.sendMail.doSend";
    private static final String MAIL_DOCUMENTS_PARAM = "ch.elexis.core.mail.ui.sendMail.documents";
    private static final String MAIL_PATIENT_ID = "ch.elexis.core.mail.ui.sendMail.patId";

    public void openSendMailDialogWithContent(IAppointment appointment, IContact pat, String preparedMessageText, String subject) {
        Optional selectedDocument;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command sendMailCommand = commandService.getCommand(MAIL_COMMAND_ID);
        HashMap<String, String> params = new HashMap<String, String>();
        if (pat instanceof IContact && StringUtils.isNotBlank((CharSequence)pat.getEmail())) {
            params.put(MAIL_TO_PARAM, pat.getEmail());
        } else if (appointment.getContact() != null && StringUtils.isNotBlank((CharSequence)appointment.getContact().getEmail())) {
            params.put(MAIL_TO_PARAM, appointment.getContact().getEmail());
        }
        if (preparedMessageText != null) {
            params.put(MAIL_TEXT_PARAM, preparedMessageText);
        }
        if (subject != null) {
            params.put(MAIL_SUBJECT_PARAM, subject);
        }
        if (pat instanceof IContact && StringUtils.isNotBlank((CharSequence)pat.getId())) {
            params.put(MAIL_PATIENT_ID, pat.getId());
        }
        params.put(MAIL_DO_SEND_PARAM, Boolean.TRUE.toString());
        String savedAccount = ConfigServiceHolder.get().get("agenda/appointment", null);
        if (StringUtils.isEmpty((CharSequence)savedAccount)) {
            savedAccount = ConfigServiceHolder.get().get("account", null);
        }
        if (savedAccount != null) {
            params.put(MAIL_ACCOUNTID_PARAM, savedAccount);
        }
        if ((selectedDocument = ContextServiceHolder.get().getTyped(IDocumentLetter.class)).isPresent()) {
            List<IDocumentLetter> iDocuments = Collections.singletonList((IDocumentLetter)selectedDocument.get());
            String documentsString = AttachmentsUtil.getDocumentsString(iDocuments);
            params.put(MAIL_DOCUMENTS_PARAM, documentsString);
        }
        try {
            ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailCommand, params);
            ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("ch.elexis.core.mail.ui.sendMail not found", ex);
        }
    }
}

