/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.util;

import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TimeInput
extends Composite {
    Text text;
    Label label;
    ArrayList<TimeInputListener> listeners;

    public TimeInput(Composite parent, String lbl) {
        super(parent, 0);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "CustomComposite");
        this.listeners = new ArrayList();
        this.setLayout((Layout)new GridLayout());
        this.label = new Label((Composite)this, 0);
        this.label.setText(lbl);
        this.text = new Text((Composite)this, 2052);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!TimeInput.this.isAcceptable(TimeInput.this.text.getText())) {
                    e.doit = false;
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                for (TimeInputListener s : TimeInput.this.listeners) {
                    s.changed();
                }
            }
        });
        this.text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
    }

    public String getText() {
        return this.text.getText();
    }

    public TimeTool setTimeTool(TimeTool day) {
        day.set(this.text.getText());
        return day;
    }

    public void setColor(Color col) {
        this.label.setForeground(col);
    }

    public int getTimeAsMinutes() {
        return TimeTool.minutesStringToInt((String)this.text.getText());
    }

    public boolean setText(String text) {
        if (this.isAcceptable(text)) {
            this.text.setText(text);
            return true;
        }
        return false;
    }

    public void setTime(TimeTool ti) {
        ti.set(this.text.getText());
    }

    public void setTimeInMinutes(int min) {
        String h = Integer.toString(min / 60);
        String m = Integer.toString(min % 60);
        this.text.setText(h + ":" + StringTool.pad((int)1, (char)'0', (String)m, (int)2));
    }

    private boolean isAcceptable(String input) {
        return true;
    }

    public void addListener(TimeInputListener l) {
        this.listeners.add(l);
    }

    public void removeListener(TimeInputListener l) {
        this.listeners.remove(l);
    }

    public static interface TimeInputListener {
        public void changed();
    }
}

