/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.views;

import ch.elexis.agenda.Messages;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.agenda.views.BaseAgendaView;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IAppointmentSeries;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.DateSelectorDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.slf4j.LoggerFactory;

public class TagesView
extends BaseAgendaView {
    public static final String ID = "ch.elexis.agenda.tagesview";
    Button bDay;
    Button bToday;
    Button bPrint;
    Text tDetail;
    Label lCreator;

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void onDateChanged(@UIEventTopic(value="ch/elexis/agenda/DATE_CHANGED") LocalDate newDate) {
        Display.getDefault().asyncExec(this::updateDate);
    }

    public TagesView() {
        this.self = this;
    }

    @Override
    public void create(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(5, false));
        top.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bToday = new Button(top, 0x1800008);
        this.bToday.setImage(UiDesk.getImage((String)"ch.elexis.agenda.home"));
        this.bToday.setToolTipText(Messages.TagesView_showToday);
        this.bToday.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeTool dat = new TimeTool();
                TagesView.this.agenda.setActDate(dat);
                TagesView.this.updateDate();
            }
        });
        Button bMinus = new Button(top, 8);
        bMinus.setToolTipText(Messages.TagesView_previousDay);
        bMinus.setText("<");
        bMinus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagesView.this.agenda.addDays(-1);
                TagesView.this.updateDate();
            }
        });
        this.bDay = new Button(top, 0x1800008);
        this.bDay.setToolTipText(Messages.TagesView_selectDay);
        this.bDay.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.bDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateSelectorDialog dsl = new DateSelectorDialog(TagesView.this.bDay.getShell(), TagesView.this.agenda.getActDate());
                dsl.create();
                Point m = UiDesk.getDisplay().getCursorLocation();
                dsl.getShell().setLocation(m.x, m.y);
                if (dsl.open() == 0) {
                    TimeTool dat = dsl.getSelectedDate();
                    TagesView.this.agenda.setActDate(dat);
                    TagesView.this.updateDate();
                }
            }
        });
        this.bDay.setText(this.agenda.getActDate().toString(4));
        Button bPlus = new Button(top, 8);
        bPlus.setToolTipText(Messages.TagesView_nextDay);
        bPlus.setText(">");
        bPlus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagesView.this.agenda.addDays(1);
                TagesView.this.updateDate();
            }
        });
        Button bPrint = new Button(top, 0x1800008);
        bPrint.setImage(Images.IMG_PRINTER.getImage());
        bPrint.setToolTipText(Messages.TagesView_printDay);
        bPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagesView.this.printAction.run();
            }
        });
        SashForm sash = new SashForm(parent, 512);
        sash.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tv = new TableViewer((Composite)sash, 0);
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tv.setLabelProvider((IBaseLabelProvider)new AgendaLabelProvider());
        this.tDetail = new Text((Composite)sash, 2114);
        this.lCreator = new Label(parent, 0);
        this.lCreator.setFont(UiDesk.getFont((String)"anwender/smallfont"));
        this.lCreator.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.lCreator.setText(" - ");
        sash.setWeights(new int[]{80, 20});
        this.makePrivateActions();
    }

    public void updateDate() {
        this.bDay.setText(this.agenda.getActDate().toString(12) + ", " + this.agenda.getActDate().toString(4));
        this.tv.refresh();
    }

    @Override
    public void setAppointment(IAppointment appointment) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(DateTimeFormatter.ofPattern("HH:mm").format(appointment.getStartTime())).append("-").append(DateTimeFormatter.ofPattern("HH:mm").format(appointment.getEndTime())).append(" ");
        if (appointment.isRecurring()) {
            Optional series = AppointmentServiceHolder.get().getAppointmentSeries(appointment);
            if (series.isPresent() && ((IAppointmentSeries)series.get()).getContact() != null && ((IAppointmentSeries)series.get()).getContact().isPerson()) {
                sb.append(PersonFormatUtil.getPersonalia((IPerson)((IAppointmentSeries)series.get()).getContact().asIPerson()));
            }
        } else if (appointment.getContact() != null && appointment.getContact().isPerson()) {
            sb.append(PersonFormatUtil.getPersonalia((IPerson)appointment.getContact().asIPerson()));
        }
        sb.append("\n(").append(appointment.getType()).append(",").append(appointment.getState()).append(")\n--------\n").append(appointment.getReason());
        sb.append("\n--------\n").append(appointment.getStateHistoryFormatted("dd.MM.yyyy HH:mm:ss"));
        this.tDetail.setText(sb.toString());
        sb.setLength(0);
        sb.append(StringTool.unNull((String)appointment.getCreatedBy())).append("/").append(this.getCreateTime(appointment).toString(0));
        this.lCreator.setText(sb.toString());
        this.agenda.dispatchTermin(appointment);
    }

    public TimeTool getCreateTime(IAppointment appointment) {
        int min = 0;
        try {
            min = Integer.parseInt(appointment.getCreated());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not parse appointment create time [" + appointment.getCreated() + "]");
        }
        return new TimeTool(min, 60000);
    }

    private void makePrivateActions() {
        this.newViewAction = new Action(Messages.TagesView_newWindow){

            public void run() {
                try {
                    TagesView.this.getViewSite().getPage().showView(TagesView.ID, ElexisIdGenerator.generateId(), 2);
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        };
    }

    class AgendaLabelProvider
    extends LabelProvider
    implements ITableColorProvider,
    ITableLabelProvider {
        AgendaLabelProvider() {
        }

        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof IAppointment) {
                IAppointment p = (IAppointment)element;
                return TagesView.this.getStateColor(p);
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (element instanceof IAppointment) {
                IAppointment p = (IAppointment)element;
                return SWTHelper.getContrast((Color)TagesView.this.getTypColor(p));
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IAppointment) {
                IAppointment p = (IAppointment)element;
                if (p.isRecurring()) {
                    return UiDesk.getImage((String)"ch.elexis.agenda.series");
                }
                return Plannables.getTypImage(p.getType());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IAppointment) {
                String[] tokens;
                String grund;
                IAppointment p = (IAppointment)element;
                StringBuilder sb = new StringBuilder();
                sb.append(DateTimeFormatter.ofPattern("HH:mm").format(p.getStartTime())).append("-").append(DateTimeFormatter.ofPattern("HH:mm").format(p.getEndTime())).append(" ");
                sb.append(p.isRecurring() ? ((IAppointmentSeries)AppointmentServiceHolder.get().getAppointmentSeries(p).get()).getRootAppointment().getSubjectOrPatient() : p.getSubjectOrPatient());
                if (ConfigServiceHolder.getUser((String)"agenda/show_reason", (boolean)false) && !StringTool.isNothing((Object)(grund = p.getReason())) && (tokens = grund.split("[\n\r]+")).length > 0) {
                    sb.append(", " + tokens[0]);
                }
                return sb.toString();
            }
            return "?";
        }
    }
}

