/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.commands;

import ch.elexis.agenda.composite.EmailComposite;
import ch.elexis.core.mail.TaskUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.LoggerFactory;

public class EmailSender {
    private static final String SEND_MAIL_COMMAND_NOUI = "ch.elexis.core.mail.ui.sendMailNoUi";
    private ITextReplacementService textReplacementService;
    private IContextService contextService;

    public EmailSender(ITextReplacementService textReplacementService, IContextService contextService) {
        this.textReplacementService = textReplacementService;
        this.contextService = contextService;
    }

    public void sendEmail(EmailComposite.EmailDetails emailDetails, IAppointment appointment) {
        Optional descriptor = ContextServiceHolder.get().getNamed("sendMailDialog.taskDescriptor");
        if (descriptor != null && descriptor.isPresent()) {
            this.processExistingDescriptor((ITaskDescriptor)descriptor.get());
        } else {
            this.sendEmailUsingCommand(emailDetails, appointment);
        }
    }

    private void processExistingDescriptor(ITaskDescriptor descriptor) {
        block4: {
            try {
                ITask task = TaskUtil.executeTaskSync((ITaskDescriptor)descriptor, (IProgressMonitor)new NullProgressMonitor());
                if (!task.isSucceeded()) break block4;
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command sendMailCommand = commandService.getCommand(SEND_MAIL_COMMAND_NOUI);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("ch.elexis.core.mail.ui.sendMailNoUi.doSend", Boolean.TRUE.toString());
                try {
                    ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailCommand, params);
                    ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("ch.elexis.core.mail.ui.sendMailNoUi nicht gefunden", ex);
                }
            }
            catch (TaskException e) {
                LoggerFactory.getLogger(TaskUtil.class).error("Fehler bei der Ausf\u00fchrung der Mail-Aufgabe", (Throwable)e);
            }
        }
    }

    private void sendEmailUsingCommand(EmailComposite.EmailDetails emailDetails, IAppointment appointment) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command sendMailCommand = commandService.getCommand(SEND_MAIL_COMMAND_NOUI);
        HashMap<String, String> params = new HashMap<String, String>();
        this.populateParams(params, emailDetails, appointment);
        try {
            ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailCommand, params);
            ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("ch.elexis.core.mail.ui.sendMailNoUi not found", ex);
        }
    }

    private void populateParams(HashMap<String, String> params, EmailComposite.EmailDetails emailDetails, IAppointment appointment) {
        String savedAccount;
        String subject;
        String emailTemplate;
        String recipientEmail = appointment.getContact().getEmail();
        if (recipientEmail != null) {
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.to", recipientEmail);
        }
        if ((emailTemplate = emailDetails.getTemplateContent()) != null) {
            IContext context = this.contextService.createNamedContext("appointment_reminder_context");
            context.setTyped((Object)appointment);
            context.setTyped((Object)appointment.getContact().asIPatient());
            String preparedMessageText = this.textReplacementService.performReplacement(context, emailTemplate);
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.text", preparedMessageText);
        }
        if ((subject = emailDetails.getTemplateName()) != null) {
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.subject", subject);
        }
        if (StringUtils.isEmpty((CharSequence)(savedAccount = ConfigServiceHolder.get().get("agenda/appointment", null)))) {
            savedAccount = ConfigServiceHolder.get().get("account", null);
        }
        if (savedAccount != null) {
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.accountid", savedAccount);
        }
    }
}

