/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.commands;

import ch.elexis.agenda.Messages;
import ch.elexis.agenda.util.AppointmentExtensionHandler;
import ch.elexis.agenda.util.AppointmentUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.e4.locks.ILockHandler;
import ch.elexis.dialogs.AppointmentLinkOptionsDialog;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class DeleteHandler {
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IContextService contextService;
    @Inject
    private IAppointmentService appointmentService;

    @Execute
    public Object execute(@Named(value="activeShell") Shell shell) throws ExecutionException {
        Optional<IPeriod> period = this.getSelectedPeriod();
        period.ifPresent(p -> {
            if (p instanceof IAppointment) {
                this.handleAppointmentDeletion((IAppointment)p, shell);
            } else {
                this.handleNonAppointmentDeletion((IPeriod)p, shell);
            }
        });
        return null;
    }

    public void handleAppointmentDeletion(IAppointment appointment, Shell shell) {
        if (AppointmentUtil.isLocked(appointment)) {
            return;
        }
        if (AppointmentExtensionHandler.isMainAppointment(appointment)) {
            this.handleMainAppointmentDeletion(appointment, shell);
        } else {
            this.handleLinkedAppointmentDeletion(appointment, shell);
        }
    }

    private void handleMainAppointmentDeletion(IAppointment appointment, Shell shell) {
        List<IAppointment> linkedAppointments = AppointmentExtensionHandler.getLinkedAppointments(appointment);
        if (!linkedAppointments.isEmpty()) {
            AppointmentLinkOptionsDialog.DeleteActionType action = AppointmentLinkOptionsDialog.showDeleteDialog(shell, linkedAppointments);
            this.processDeleteAction(appointment, linkedAppointments, action);
        } else {
            boolean userConfirmed = this.showConfirmationDialog(shell, (IPeriod)appointment);
            if (userConfirmed) {
                this.deleteMainAppointmentOnly(appointment);
            }
        }
    }

    private void handleLinkedAppointmentDeletion(IAppointment appointment, Shell shell) {
        boolean shouldProceed;
        Optional mainAppointment;
        String mainAppointmentId = AppointmentExtensionHandler.getMainAppointmentId(appointment);
        if (mainAppointmentId != null && (mainAppointment = CoreModelServiceHolder.get().load(mainAppointmentId, IAppointment.class)).isPresent() && !(shouldProceed = this.showMainAppointmentWarning(shell, (IAppointment)mainAppointment.get(), (IPeriod)appointment))) {
            return;
        }
        boolean userConfirmed = this.showConfirmationDialog(shell, (IPeriod)appointment);
        if (userConfirmed) {
            this.performAppointmentDeletion(appointment, shell);
        }
    }

    private void handleNonAppointmentDeletion(final IPeriod period, final Shell shell) {
        boolean userConfirmed = MessageDialog.openConfirm((Shell)shell, (String)Messages.AgendaUI_Delete_delete, (String)NLS.bind((String)Messages.AgendaUI_Delete_ask_really_delete, (Object)period.getLabel()));
        if (userConfirmed) {
            AcquireLockBlockingUi.aquireAndRun((Identifiable)period, (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    IAppointment appointment = (IAppointment)period;
                    DeleteHandler.this.performAppointmentDeletion(appointment, shell);
                }
            });
        }
    }

    private void performAppointmentDeletion(final IAppointment appointment, final Shell shell) {
        AcquireLockBlockingUi.aquireAndRun((Identifiable)appointment, (ILockHandler)new ILockHandler(){

            public void lockFailed() {
            }

            public void lockAcquired() {
                if (appointment.isRecurring()) {
                    boolean deleteSeries = MessageDialog.openQuestion((Shell)shell, (String)Messages.AgendaUI_Delete__delete, (String)Messages.AgendaUI_Delete_ask_delete_whole_series);
                    DeleteHandler.this.appointmentService.delete(appointment, deleteSeries);
                } else {
                    DeleteHandler.this.appointmentService.delete(appointment, false);
                }
                ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
            }
        });
    }

    private boolean showConfirmationDialog(Shell shell, IPeriod period) {
        return MessageDialog.openConfirm((Shell)shell, (String)Messages.AgendaUI_Delete_delete, (String)NLS.bind((String)Messages.AgendaUI_Delete_ask_really_delete, (Object)period.getLabel()));
    }

    private boolean showMainAppointmentWarning(Shell shell, IAppointment mainAppointment, IPeriod period) {
        String message = Messages.DeleteHandlerLinkedAppointmentWarning + mainAppointment.getLabel();
        return MessageDialog.openConfirm((Shell)shell, (String)Messages.AgendaUI_Delete_delete, (String)(NLS.bind((String)Messages.AgendaUI_Delete_ask_really_delete, (Object)period.getLabel()) + message));
    }

    private void processDeleteAction(IAppointment appointment, List<IAppointment> linkedAppointments, AppointmentLinkOptionsDialog.DeleteActionType action) {
        if (action == AppointmentLinkOptionsDialog.DeleteActionType.KEEP_LINKS) {
            this.deleteMainAppointmentOnly(appointment);
        } else if (action == AppointmentLinkOptionsDialog.DeleteActionType.DELETE_ALL) {
            this.deleteLinkedAppointments(appointment, linkedAppointments);
        }
    }

    private void deleteMainAppointmentOnly(final IAppointment appointment) {
        AcquireLockBlockingUi.aquireAndRun((Identifiable)appointment, (ILockHandler)new ILockHandler(){

            public void lockFailed() {
            }

            public void lockAcquired() {
                DeleteHandler.this.appointmentService.delete(appointment, false);
                ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
            }
        });
    }

    private void deleteLinkedAppointments(final IAppointment mainAppointment, final List<IAppointment> linkedAppointments) {
        AcquireLockBlockingUi.aquireAndRun((Identifiable)mainAppointment, (ILockHandler)new ILockHandler(){

            public void lockFailed() {
            }

            public void lockAcquired() {
                DeleteHandler.this.appointmentService.delete(mainAppointment, false);
                linkedAppointments.forEach(appt -> DeleteHandler.this.appointmentService.delete(appt, false));
                ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
            }
        });
    }

    private Optional<IPeriod> getSelectedPeriod() {
        Object element;
        Optional contextAppointment = this.contextService.getTyped(IAppointment.class);
        if (contextAppointment.isPresent()) {
            return contextAppointment.map(a -> a);
        }
        Object activeSelection = this.selectionService.getSelection();
        if (activeSelection instanceof StructuredSelection && !((StructuredSelection)activeSelection).isEmpty() && (element = ((StructuredSelection)activeSelection).getFirstElement()) instanceof IPeriod) {
            return Optional.of((IPeriod)element);
        }
        return Optional.empty();
    }
}

