/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.elexis;

import ch.docbox.cdach.DocboxCDA;
import ch.docbox.elexis.Activator;
import ch.docbox.elexis.Messages;
import ch.docbox.elexis.UserDocboxPreferences;
import ch.docbox.model.DocboxContact;
import ch.docbox.ws.cdachservices.CDACHServices;
import ch.docbox.ws.cdachservices.CDACHServices_Service;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.IFormattedOutput;
import ch.elexis.core.services.IFormattedOutputFactory;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.hl7.v3.ClinicalDocumentType;
import org.hl7.v3.POCDMT000040Author;
import org.hl7.v3.POCDMT000040Custodian;
import org.hl7.v3.POCDMT000040InformationRecipient;
import org.hl7.v3.POCDMT000040RecordTarget;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class DocboxArztArztDialog
extends TitleAreaDialog {
    private Patient patient;
    private Kontakt kontakt;
    private DocboxCDA docboxCDA = new DocboxCDA();
    private Text textTitle;
    private Text textMessage;
    private ArrayList<Kontakt> kontakte;
    private Combo comboDoctor;
    private List listAttachments;

    public DocboxArztArztDialog(Patient patient, Kontakt kontakt) {
        super(UiDesk.getTopShell());
        this.patient = patient;
        this.kontakt = kontakt;
        this.kontakte = new ArrayList();
    }

    protected Control createDialogArea(Composite parent) {
        Composite com = new Composite(parent, 0);
        com.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        com.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(com, 0);
        label.setText(Messages.DocboxArztArztDialog_TextPatient);
        label = new Label(com, 0);
        label.setText(this.patient.getLabel());
        label = new Label(com, 0);
        label.setText(Messages.DocboxArztArztDialog_TextDoctor);
        this.comboDoctor = new Combo(com, 2572);
        Query qbe = new Query(Kontakt.class);
        ArrayList<Kontakt> list = qbe.execute();
        TreeMap<String, Kontakt> tm = new TreeMap<String, Kontakt>();
        ArrayList<Kontakt> sortedList = new ArrayList<Kontakt>();
        for (Kontakt kontakt : list) {
            tm.put(kontakt.getLabel().toLowerCase(), kontakt);
        }
        for (Map.Entry entry : tm.entrySet()) {
            sortedList.add((Kontakt)entry.getValue());
        }
        list = sortedList;
        for (Kontakt kontakt : list) {
            Boolean isDoc2Doc = (Boolean)kontakt.getInfoElement("doctodoc");
            if (isDoc2Doc == null || !isDoc2Doc.booleanValue()) continue;
            this.comboDoctor.add(kontakt.getLabel());
            this.kontakte.add(kontakt);
        }
        if (this.kontakt != null) {
            this.comboDoctor.setText(this.kontakt.getLabel());
        }
        label = new Label(com, 0);
        label.setText(Messages.DocboxArztArztDialog_TextTitle);
        this.textTitle = new Text(com, 2048);
        this.textTitle.setText("");
        this.textTitle.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Label label2 = new Label(com, 0);
        label2.setText(Messages.DocboxArztArztDialog_TextMessage);
        this.textMessage = new Text(com, 2626);
        this.textMessage.setText("\n\n\n\n\n");
        this.textMessage.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        label = new Label(com, 0);
        label.setText(Messages.DocboxArztArztDialog_TextAttachments);
        this.listAttachments = new List(com, 516);
        this.listAttachments.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.listAttachments.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                int index;
                if ((e.keyCode == 127 || e.keyCode == 8) && DocboxArztArztDialog.this.listAttachments.isFocusControl() && (index = DocboxArztArztDialog.this.listAttachments.getSelectionIndex()) != 0) {
                    DocboxArztArztDialog.this.listAttachments.remove(index);
                }
            }
        });
        label = new Label(com, 0);
        Button addAttachments = new Button(com, 8);
        addAttachments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog fd = new FileDialog(UiDesk.getTopShell(), 2);
                fd.setText("\u00d6ffnen");
                String[] filterExt = new String[]{"*.*", "*.doc", "*.docx", "*.doc", "*.gif", "*.jpeg", "*.jpg", "*.mov", "*.mp3", "*.mpeg", "*.pdf", "*.png", "*.ppt", "*.tiff", "*.txt", "*.xls", "*.xlsx", "*.zip", "*.odt", "*.html", "*.htm", "*.rtf", "*.oft", "*.pptx", "*.pps", "*.rpt", "*.vcf", "*.xml", "*.csv"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    String[] files = fd.getFileNames();
                    int i = 0;
                    int n = files.length;
                    while (i < n) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(fd.getFilterPath());
                        if (buf.charAt(buf.length() - 1) != File.separatorChar) {
                            buf.append(File.separatorChar);
                        }
                        buf.append(files[i]);
                        DocboxArztArztDialog.this.listAttachments.add(buf.toString());
                        ++i;
                    }
                }
            }
        });
        addAttachments.setText(Messages.DocboxArztArztDialog_ButtonAddAttachments);
        return com;
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
        this.setMessage(Messages.DocboxArztArztDialog_Title);
        if (UiDesk.getImage((String)"ch.docbox.elexis/doc2doc") == null) {
            UiDesk.getImageRegistry().put("ch.docbox.elexis/doc2doc", Activator.getImageDescriptor("icons/doc2doc16.png"));
        }
        this.setTitleImage(UiDesk.getImageRegistry().get("ch.docbox.elexis/doc2doc"));
    }

    protected void okPressed() {
        final String title = this.textTitle.getText();
        final String message = this.textMessage.getText();
        String filename = "ueberweisung.pdf";
        final String[] attachments = this.listAttachments.getItems();
        final Holder success = new Holder();
        final Holder errorMessage = new Holder();
        final Holder documentId = new Holder();
        if (this.comboDoctor.getSelectionIndex() == -1) {
            MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), 1);
            box.setText(Messages.DocboxArztArztAction_NoDoctorSelectedText);
            box.setMessage(Messages.DocboxArztArztAction_NoDoctorSelectedMessage);
            box.open();
            return;
        }
        this.kontakt = this.kontakte.get(this.comboDoctor.getSelectionIndex());
        Runnable longJob = new Runnable(){
            boolean done = false;

            public void stop(String errMsg) {
                if (errMsg != null) {
                    errorMessage.value = errMsg;
                }
                this.done = true;
                UiDesk.getDisplay().wake();
            }

            @Override
            public void run() {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        success.value = Boolean.FALSE;
                        try {
                            ClinicalDocumentType cda = DocboxArztArztDialog.this.getArztArztCda(null, title, message, "ueberweisung.pdf", attachments);
                            if (cda == null) {
                                this.stop(Messages.DocboxArztArztAction_NoCdaGeneratedMessage);
                                return;
                            }
                            byte[] xml = DocboxArztArztDialog.this.getClincicalDocumentSerialized(cda);
                            if (xml == null) {
                                this.stop(Messages.DocboxArztArztAction_NoXmlGeneratedMessage);
                                return;
                            }
                            ByteArrayOutputStream pdfOut = DocboxArztArztDialog.this.getArztArztPdf(xml);
                            if (pdfOut == null) {
                                this.stop(Messages.DocboxArztArztAction_NoPdfGeneratedMessage);
                                return;
                            }
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            ZipOutputStream out = new ZipOutputStream(byteArrayOutputStream);
                            try {
                                out.putNextEntry(new ZipEntry("ueberweisung.pdf"));
                                pdfOut.writeTo(out);
                                out.closeEntry();
                                if (attachments != null) {
                                    String[] stringArray = attachments;
                                    int n = attachments.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String attachFile = stringArray[n2];
                                        String fileName = attachFile;
                                        if (fileName.indexOf("/") >= 0) {
                                            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                                        }
                                        if (fileName.indexOf("\\") >= 0) {
                                            fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
                                        }
                                        out.putNextEntry(new ZipEntry(fileName));
                                        int len = 0;
                                        FileInputStream in = new FileInputStream(attachFile);
                                        byte[] buf = new byte[1024];
                                        while ((len = ((InputStream)in).read(buf)) > 0) {
                                            out.write(buf, 0, len);
                                        }
                                        out.closeEntry();
                                        ((InputStream)in).close();
                                        ++n2;
                                    }
                                }
                                out.close();
                            }
                            catch (IOException e) {
                                ExHandler.handle((Throwable)e);
                                this.stop(Messages.DocboxArztArztAction_NoZipGeneratedMessage);
                                return;
                            }
                            CDACHServices port = UserDocboxPreferences.getPort();
                            port.sendClinicalDocument(cda, byteArrayOutputStream.toByteArray(), (Holder<Boolean>)success, (Holder<String>)errorMessage, (Holder<String>)documentId);
                            if (!((Boolean)success.value).booleanValue()) {
                                this.stop(Messages.DocboxArztArztAction_SendDocumentFailed + "\n" + (String)errorMessage.value);
                                return;
                            }
                        }
                        catch (Exception e) {
                            ExHandler.handle((Throwable)e);
                            this.stop(Messages.DocboxArztArztAction_SendDocumentFailed + "\n" + (String)errorMessage.value);
                            return;
                        }
                        done = true;
                        UiDesk.getDisplay().wake();
                    }
                });
                thread.start();
                while (!(this.done || UiDesk.getTopShell() != null && UiDesk.getTopShell().isDisposed())) {
                    if (UiDesk.getDisplay().readAndDispatch()) continue;
                    UiDesk.getDisplay().sleep();
                }
            }
        };
        BusyIndicator.showWhile((Display)UiDesk.getDisplay(), (Runnable)longJob);
        if (success != null && success.value != null && !((Boolean)success.value).booleanValue()) {
            MessageBox box = new MessageBox(UiDesk.getDisplay().getActiveShell(), 1);
            box.setText(Messages.UserDocboxPreferences_ConnectionTestWithDocbox);
            box.setMessage((String)errorMessage.value);
            box.open();
        } else {
            super.okPressed();
            Activator.docboxBackgroundJob.schedule();
        }
    }

    private byte[] getClincicalDocumentSerialized(ClinicalDocumentType cda) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet type='text/xsl' href='./Terminvereinbarung.xsl'?>\n" + this.docboxCDA.marshallIntoString(cda.getClinicalDocument());
        try {
            return xml.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            ExHandler.handle((Throwable)e);
            return null;
        }
    }

    private ByteArrayOutputStream getArztArztPdf(byte[] xmlData) {
        if (xmlData == null) {
            return null;
        }
        ByteArrayOutputStream pdfOut = new ByteArrayOutputStream();
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference fopFactoryRef = bundleContext.getServiceReference(IFormattedOutputFactory.class);
        if (fopFactoryRef != null) {
            try {
                IFormattedOutputFactory fopFactory = (IFormattedOutputFactory)bundleContext.getService(fopFactoryRef);
                IFormattedOutput foOutputt = fopFactory.getFormattedOutputImplementation(IFormattedOutputFactory.ObjectType.XMLSTREAM, IFormattedOutputFactory.OutputType.PDF);
                ByteArrayInputStream stream = new ByteArrayInputStream(xmlData);
                URL xsl = CDACHServices_Service.class.getResource("/rsc/ch/docbox/ws/cdachservices/ArztArzt.xsl");
                foOutputt.transform((Object)stream, xsl.openStream(), (OutputStream)pdfOut);
            }
            catch (IllegalStateException e) {
                ExHandler.handle((Throwable)e);
            }
            catch (IOException e) {
                ExHandler.handle((Throwable)e);
            }
            bundleContext.ungetService(fopFactoryRef);
        }
        return pdfOut;
    }

    private ClinicalDocumentType getArztArztCda(Fall fall, String title, String message, String filename, String[] attachments) {
        try {
            this.addVersicherung(fall, this.docboxCDA);
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
        }
        Date birthday = null;
        if (!"".equals(this.patient.getGeburtsdatum())) {
            TimeTool ttBirthday = new TimeTool(this.patient.getGeburtsdatum());
            birthday = ttBirthday.getTime();
        }
        POCDMT000040RecordTarget recordTarget = this.docboxCDA.getRecordTarget(this.patient.getPatCode(), null, this.patient.getAnschrift().getStrasse(), this.patient.getAnschrift().getPlz(), this.patient.getAnschrift().getOrt(), this.patient.get("Telefon1"), this.patient.get("Telefon2"), this.patient.getNatel(), this.patient.getMailAddress(), this.patient.getVorname(), this.patient.getName(), "w".equals(this.patient.getGeschlecht()), "m".equals(this.patient.getGeschlecht()), false, birthday);
        POCDMT000040Author author = this.docboxCDA.getAuthor(CoreHub.actMandant.get("Titel"), CoreHub.actMandant.getVorname(), CoreHub.actMandant.getName(), CoreHub.actMandant.getNatel(), null, null, CoreHub.actMandant.getMailAddress(), null, null, null);
        POCDMT000040Custodian custodian = this.docboxCDA.getCustodian("", this.docboxCDA.getAddress(CoreHub.actMandant.getAnschrift().getStrasse(), null, CoreHub.actMandant.getAnschrift().getPlz(), CoreHub.actMandant.getAnschrift().getOrt(), "WP"), null, null, null, null);
        POCDMT000040InformationRecipient informationRecipient = null;
        if (this.kontakt != null) {
            String organization = this.kontakt.get("Bezeichnung3");
            if (this.kontakt.get("istAnwender").equals("1")) {
                organization = "";
            }
            informationRecipient = this.docboxCDA.getInformationRecipient(this.kontakt.get("Titel"), this.kontakt.get("Bezeichnung2"), this.kontakt.get("Bezeichnung1"), DocboxContact.getDocboxIdFor(this.kontakt), this.docboxCDA.getOrganization(organization, null, null, null, this.kontakt.getAnschrift().getStrasse(), this.kontakt.getAnschrift().getPlz(), this.kontakt.getAnschrift().getOrt()));
        }
        this.docboxCDA.addComponentToBody("Notiz", message, "NOTIZ");
        Vector<String> attachmentsCda = new Vector<String>();
        attachmentsCda.add(filename);
        if (attachments != null) {
            String[] stringArray = attachments;
            int n = attachments.length;
            int n2 = 0;
            while (n2 < n) {
                String attach = stringArray[n2];
                attachmentsCda.add(attach);
                ++n2;
            }
        }
        this.docboxCDA.addAttachmentsDescriptionToBody(attachmentsCda);
        ClinicalDocumentType _addReferral_document = new ClinicalDocumentType();
        _addReferral_document.setClinicalDocument(this.docboxCDA.getClinicalDocument(title, recordTarget, author, custodian, informationRecipient, this.docboxCDA.getCodeReferral(), null, DocboxCDA.DOCBOXCDATYPE.Docbox_Arzt_Arzt));
        return _addReferral_document;
    }

    private void addVersicherung(Fall fall, DocboxCDA docboxCDA) {
        if (fall != null) {
            if ("UVG".equals(fall.getAbrechnungsSystem())) {
                try {
                    docboxCDA.addUnfallversicherung(fall.getCostBearer().getLabel());
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                }
                try {
                    docboxCDA.addUnfallversicherungPolicenummer(fall.getRequiredString("Unfallnummer"));
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                }
            }
            if ("KVG".equals(fall.getAbrechnungsSystem())) {
                try {
                    docboxCDA.addKrankenkasse(fall.getCostBearer().getLabel());
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                }
                try {
                    docboxCDA.addKrankenkassePolicenummer(fall.getRequiredString("Versicherungsnummer"));
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        }
    }
}

