/*
 * Decompiled with CFR 0.152.
 */
package ch.docbox.cdach;

import ch.docbox.cdach.CdaNamespaceContext;
import ch.docbox.cdach.DocboxCDA;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CdaChValidator {
    private XPathFactory factory;
    private XPath xpath;
    private Document doc;
    private String xmlFileName;
    private Map<String, XPathExpression> expressionCache = new HashMap<String, XPathExpression>();

    public CdaChValidator() {
        this.factory = XPathFactory.newInstance();
        this.xpath = this.factory.newXPath();
        this.xpath.setNamespaceContext(new CdaNamespaceContext());
    }

    public String getFieldValue(String expression) {
        Object result = null;
        try {
            XPathExpression xpathCheckTypeId = this.expressionCache.get(expression);
            if (xpathCheckTypeId == null) {
                xpathCheckTypeId = this.xpath.compile(expression);
                this.expressionCache.put(expression, xpathCheckTypeId);
            }
            result = xpathCheckTypeId.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            System.out.println(e);
        }
        if (result == null) {
            return null;
        }
        NodeList nodes = (NodeList)result;
        if (nodes != null && nodes.item(0) != null) {
            return nodes.item(0).getNodeValue();
        }
        Node node = (Node)result;
        return node.getNodeValue();
    }

    public String setPatientDocument(String document) {
        this.xmlFileName = document;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
            this.doc = docBuilder.parse(new ByteArrayInputStream(this.xmlFileName.getBytes("UTF-8")));
        }
        catch (SAXException e) {
            System.err.println(e);
            return e.toString();
        }
        catch (ParserConfigurationException e) {
            System.err.println(e);
            return e.toString();
        }
        catch (IOException e) {
            System.err.println(e);
            return e.toString();
        }
        return null;
    }

    public String getPatientLastName() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:name/cda:family";
        return this.getFieldValue(str);
    }

    public String getPatientFirstName() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/cda:name/cda:given";
        return this.getFieldValue(str);
    }

    public String getCity() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:addr/cda:city";
        return this.getFieldValue(str);
    }

    public String getPatientNumber() {
        String str = "//cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:id[@root = '" + DocboxCDA.getOidPraxisSoftwareId() + "' or string-length(normalize-space(@root)) = 0]/@extension";
        return this.getFieldValue(str);
    }
}

