/*
 * Decompiled with CFR 0.152.
 */
package ch.berchtold.emanuel.privatrechnung.views;

import ch.berchtold.emanuel.privatrechnung.model.IPrivatLeistung;
import ch.berchtold.emanuel.privatrechnung.model.PrivatModelServiceHolder;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class PrivatLeistungContentProvider
implements ViewerConfigurer.ICommonViewerContentProvider,
ITreeContentProvider {
    private CommonViewer commonViewer;
    private INamedQuery<IPrivatLeistung> childrenQuery;
    private String nameFilter;
    private String codeFilter;

    public PrivatLeistungContentProvider(CommonViewer commonViewer) {
        this.commonViewer = commonViewer;
        this.childrenQuery = PrivatModelServiceHolder.get().getNamedQuery(IPrivatLeistung.class, new String[]{"parent"});
    }

    public Object[] getElements(Object inputElement) {
        List roots = this.childrenQuery.executeWithParameters(this.childrenQuery.getParameterMap(new Object[]{"parent", "NIL"}));
        return roots.toArray(new Object[roots.size()]);
    }

    public void changed(HashMap<String, String> values) {
        this.nameFilter = values.get("name");
        this.codeFilter = values.get("shortName");
        this.commonViewer.notify(CommonViewer.Message.update_keeplabels);
    }

    public void reorder(String field) {
    }

    public void selected() {
    }

    public void init() {
    }

    public void startListening() {
        this.commonViewer.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public void stopListening() {
        this.commonViewer.getConfigurer().getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IPrivatLeistung) {
            IPrivatLeistung parentLeistung = (IPrivatLeistung)parentElement;
            List<IPrivatLeistung> ret = this.childrenQuery.executeWithParameters(this.childrenQuery.getParameterMap(new Object[]{"parent", parentLeistung.getCode()}));
            ret = this.getFiltered(ret);
            return ret.toArray(new Object[ret.size()]);
        }
        return null;
    }

    private List<IPrivatLeistung> getFiltered(List<IPrivatLeistung> ret) {
        if (StringUtils.isNotBlank((CharSequence)this.nameFilter)) {
            ret = ret.stream().filter(pl -> this.hasChildren(pl) || pl.getText().toLowerCase().contains(this.nameFilter.toLowerCase())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)this.codeFilter)) {
            ret = ret.stream().filter(pl -> this.hasChildren(pl) || pl.getCode().toLowerCase().contains(this.codeFilter.toLowerCase())).collect(Collectors.toList());
        }
        return ret;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof IPrivatLeistung) {
            IPrivatLeistung parentLeistung = (IPrivatLeistung)parentElement;
            List<IPrivatLeistung> ret = this.childrenQuery.executeWithParameters(this.childrenQuery.getParameterMap(new Object[]{"parent", parentLeistung.getCode()}));
            return !(ret = this.getFiltered(ret)).isEmpty();
        }
        return false;
    }
}

