/*
 * Decompiled with CFR 0.152.
 */
package ch.berchtold.emanuel.privatrechnung.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.preferences.inputs.ComboFieldEditor;
import ch.elexis.core.ui.preferences.inputs.KontaktFieldEditor;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.rgw.io.Settings;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    Settings cfg = CoreHub.localCfg;
    List<Mandant> lMandanten;
    ComboFieldEditor cfe;
    StringFieldEditor sfESR;
    StringFieldEditor sf1st;
    StringFieldEditor sf2nd;
    StringFieldEditor sfESRNr;
    StringFieldEditor sfESRKd;
    IntegerFieldEditor ifh1;
    IntegerFieldEditor if2nd;
    KontaktFieldEditor kfBank;
    Mandant selected;
    static final String doSelect = "bitte w\u00e4hlen";

    public Preferences() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(this.cfg));
    }

    protected void createFieldEditors() {
        this.lMandanten = Hub.getMandantenList();
        String[] fields = new String[this.lMandanten.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = this.lMandanten.get(i).getLabel();
            ++i;
        }
        this.cfe = new ComboFieldEditor("privatrechnung_berchtold", "Mandant", fields, this.getFieldEditorParent());
        this.sfESR = new StringFieldEditor("privatrechnung_berchtold/templateESR", "Vorlage mit ESR", this.getFieldEditorParent());
        this.sf1st = new StringFieldEditor("privatrechnung_berchtold/templateBill", "Erste Folgeseite", this.getFieldEditorParent());
        this.ifh1 = new IntegerFieldEditor("privatrechnung_berchtold/templateBillHeight", "Verf\u00fcgbare H\u00f6he erste Seite (cm)", this.getFieldEditorParent());
        this.sf2nd = new StringFieldEditor("privatrechnung_berchtold/templateBill2", "Vorlage weitere Seiten", this.getFieldEditorParent());
        this.if2nd = new IntegerFieldEditor("privatrechnung_berchtold/templateBillHeight2", "Verf\u00fcgbare H\u00f6he Folgeseiten (cm)", this.getFieldEditorParent());
        this.kfBank = new KontaktFieldEditor(new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.LOCAL), "privatrechnung_berchtold/bank", "Bank", this.getFieldEditorParent());
        this.sfESRNr = new StringFieldEditor("privatrechnung_berchtold/esrIdentity", "ESR-Teilnehmernummer", this.getFieldEditorParent());
        this.sfESRKd = new StringFieldEditor("privatrechnung_berchtold/esrUser", "ESR-Kundennummer", this.getFieldEditorParent());
        this.addField((FieldEditor)this.cfe);
        this.addField((FieldEditor)this.sfESR);
        this.addField((FieldEditor)this.sf1st);
        this.addField((FieldEditor)this.ifh1);
        this.addField((FieldEditor)this.sf2nd);
        this.addField((FieldEditor)this.if2nd);
        this.addField((FieldEditor)this.kfBank);
        this.addField((FieldEditor)this.sfESRNr);
        this.addField((FieldEditor)this.sfESRKd);
        this.cfe.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String mandLabel;
                Mandant m;
                if (Preferences.this.selected != null) {
                    Preferences.this.flush(Preferences.this.selected);
                }
                if ((m = Preferences.this.getMandant(mandLabel = Preferences.this.cfe.getCombo().getText())) != null) {
                    Preferences.this.selected = m;
                    Preferences.this.load(Preferences.this.selected);
                }
            }
        });
        this.selected = null;
    }

    public void flush(Mandant m) {
        if (m != null) {
            String id = m.getId();
            this.cfg.set("privatrechnung_berchtold/templateESR/" + id, this.sfESR.getStringValue());
            this.cfg.set("privatrechnung_berchtold/templateBill/" + id, this.sf1st.getStringValue());
            this.cfg.set("privatrechnung_berchtold/templateBillHeight/" + id, this.ifh1.getStringValue());
            this.cfg.set("privatrechnung_berchtold/templateBill2/" + id, this.sf2nd.getStringValue());
            this.cfg.set("privatrechnung_berchtold/templateBillHeight2/" + id, this.if2nd.getStringValue());
            Kontakt kBank = this.kfBank.getValue();
            if (kBank != null) {
                this.cfg.set("privatrechnung_berchtold/bank/" + id, this.kfBank.getValue().getId());
            }
            this.cfg.set("privatrechnung_berchtold/esrIdentity/" + id, this.sfESRNr.getStringValue());
            this.cfg.set("privatrechnung_berchtold/esrUser/" + id, this.sfESRKd.getStringValue());
        }
    }

    public void load(Mandant m) {
        if (m != null) {
            String id = m.getId();
            this.sfESR.setStringValue(this.cfg.get("privatrechnung_berchtold/templateESR/" + id, ""));
            this.sf1st.setStringValue(this.cfg.get("privatrechnung_berchtold/templateBill/" + id, ""));
            this.ifh1.setStringValue(this.cfg.get("privatrechnung_berchtold/templateBillHeight/" + id, ""));
            this.sf2nd.setStringValue(this.cfg.get("privatrechnung_berchtold/templateBill2/" + id, ""));
            this.if2nd.setStringValue(this.cfg.get("privatrechnung_berchtold/templateBillHeight2/" + id, ""));
            this.kfBank.set(Kontakt.load((String)this.cfg.get("privatrechnung_berchtold/bank/" + id, "")));
            this.sfESRNr.setStringValue(this.cfg.get("privatrechnung_berchtold/esrIdentity/" + id, ""));
            this.sfESRKd.setStringValue(this.cfg.get("privatrechnung_berchtold/esrUser/" + id, ""));
        }
    }

    public void init(IWorkbench workbench) {
    }

    public Mandant getMandant(String label) {
        for (Mandant m : this.lMandanten) {
            if (!m.getLabel().equals(label)) continue;
            return m;
        }
        return null;
    }

    public boolean performOk() {
        if (this.selected != null) {
            this.flush(this.selected);
        }
        CoreHub.localCfg.flush();
        return true;
    }
}

