/*
 * Decompiled with CFR 0.152.
 */
package ch.berchtold.emanuel.privatrechnung.model.internal;

import ch.berchtold.emanuel.privatrechnung.model.IPrivatLeistung;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PrivatRechnungCodeElementServiceContribution
implements ICodeElementServiceContribution {
    @Reference(target="(service.model.name=ch.berchtold.emanuel.privatrechnung.model)")
    private IModelService modelService;

    public String getSystem() {
        return "Privattarif";
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.SERVICE;
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        INamedQuery codeQuery = this.modelService.getNamedQuery(IPrivatLeistung.class, new String[]{"code"});
        List codes = codeQuery.executeWithParameters(codeQuery.getParameterMap(new Object[]{"code", code}));
        if (codes != null && !codes.isEmpty()) {
            LocalDate date = this.getDate(context);
            for (IPrivatLeistung iLaborLeistung : codes) {
                if (!iLaborLeistung.isValidOn(date)) continue;
                return Optional.of(iLaborLeistung);
            }
        }
        return Optional.empty();
    }

    private LocalDate getDate(Map<Object, Object> context) {
        Object date = context.get(ICodeElementService.ContextKeys.DATE);
        if (date instanceof LocalDate) {
            return (LocalDate)date;
        }
        IEncounter encounter = (IEncounter)context.get(ICodeElementService.ContextKeys.CONSULTATION);
        if (encounter != null) {
            return encounter.getDate();
        }
        return LocalDate.now();
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        return null;
    }
}

