/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.weblinks.preferences;

import at.medevit.elexis.weblinks.model.WebLinkElement;
import at.medevit.elexis.weblinks.model.WebLinkElementUtil;
import at.medevit.elexis.weblinks.preferences.Messages;
import at.medevit.elexis.weblinks.preferences.WebLinkEditor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WebLinkPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List<WebLinkElement> elements;
    private List<WebLinkEditor> editors = new ArrayList<WebLinkEditor>();
    private Composite editorsComposite;
    private Composite prefAreaComposite;

    public void init(IWorkbench workbench) {
        this.elements = WebLinkElementUtil.loadElements();
    }

    protected Control createContents(Composite parent) {
        this.prefAreaComposite = new Composite(parent, 0);
        this.prefAreaComposite.setLayout((Layout)new GridLayout());
        Button addBtn = new Button(this.prefAreaComposite, 8);
        addBtn.setText(Messages.WebLinkPreferencePage_0);
        addBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebLinkPreferencePage.this.elements.add(new WebLinkElement(Long.toString(Calendar.getInstance().getTimeInMillis())));
                WebLinkPreferencePage.this.refreshEditors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editorsComposite = new Composite(this.prefAreaComposite, 0);
        this.editorsComposite.setLayout((Layout)new GridLayout());
        this.editorsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.refreshEditors();
        return this.prefAreaComposite;
    }

    public void refreshEditors() {
        for (WebLinkEditor editor : this.editors) {
            editor.dispose();
        }
        for (WebLinkElement element : this.elements) {
            WebLinkEditor editor = new WebLinkEditor(element, this, this.editorsComposite, 0);
            editor.setLayoutData(new GridData(4, 0x1000000, true, false));
            this.editors.add(editor);
        }
        this.prefAreaComposite.layout(true, true);
    }

    public boolean performOk() {
        WebLinkElementUtil.saveElements(this.elements);
        return true;
    }

    public List<WebLinkElement> getElements() {
        return this.elements;
    }
}

