/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.weblinks.model;

import at.medevit.elexis.weblinks.model.WebLinkElement;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WebLinkElementUtil {
    private static final String CFG_WEBLINK = "elexis.weblink";
    private static final String CFG_WEBLINK_TEXT = "elexis.weblink.text";
    private static final String CFG_WEBLINK_LINK = "elexis.weblink.link";
    private static final String CFG_WEBLINK_IDS = "elexis.weblink.ids";
    private static final String ID_DELIMITER = "||";
    private static final String ID_DELIMITER_ESCAPED = "\\|\\|";
    private static HashMap<String, String> placeholders = new HashMap();

    public static String replacePlaceholders(String url) {
        while (WebLinkElementUtil.hasPlaceholder(url)) {
            url = WebLinkElementUtil.replacePlaceholder(url);
        }
        return url;
    }

    private static String replacePlaceholder(String url) {
        StringBuilder sb = new StringBuilder();
        int startIdx = url.indexOf(91);
        int endIdx = url.indexOf(93);
        sb.append(url.substring(0, startIdx));
        String placeholder = url.substring(startIdx + 1, endIdx);
        if (placeholder != null) {
            sb.append(WebLinkElementUtil.getPlaceholder(placeholder));
        }
        sb.append(url.substring(endIdx + 1));
        return sb.toString();
    }

    public static String getPlaceholder(String placeholder) {
        return placeholders.get(placeholder);
    }

    public static void setPlaceholder(String placeholder, String value) {
        placeholders.put(placeholder, value);
    }

    private static boolean hasPlaceholder(String url) {
        int startIdx = url.indexOf(91);
        int endIdx = url.indexOf(93);
        return startIdx != -1 && endIdx != -1;
    }

    public static List<WebLinkElement> loadElements() {
        List<String> ids = WebLinkElementUtil.loadIds();
        ArrayList<WebLinkElement> ret = new ArrayList<WebLinkElement>();
        for (String id : ids) {
            ret.add(new WebLinkElement(id));
        }
        return ret;
    }

    public static void saveElements(List<WebLinkElement> elements) {
        ArrayList<String> ids = new ArrayList<String>();
        for (WebLinkElement element : elements) {
            element.save();
            ids.add(element.id);
        }
        WebLinkElementUtil.saveIds(ids);
    }

    private static List<String> loadIds() {
        String allIds = ConfigServiceHolder.getUser((String)CFG_WEBLINK_IDS, (String)"");
        String[] ids = allIds.split(ID_DELIMITER_ESCAPED);
        ArrayList<String> ret = new ArrayList<String>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.isEmpty()) {
                ret.add(id);
            }
            ++n2;
        }
        return ret;
    }

    private static void saveIds(List<String> ids) {
        StringBuilder sb = new StringBuilder();
        if (ids.isEmpty()) {
            ConfigServiceHolder.setUser((String)CFG_WEBLINK_IDS, (String)"");
        } else {
            for (String string : ids) {
                sb.append(string);
                sb.append(ID_DELIMITER);
            }
            sb.setLength(sb.length() - ID_DELIMITER.length());
            ConfigServiceHolder.setUser((String)CFG_WEBLINK_IDS, (String)sb.toString());
        }
    }

    public static String getTextConfig(String id) {
        return "elexis.weblink.text." + id;
    }

    public static String getLinkConfig(String id) {
        return "elexis.weblink.link." + id;
    }
}

