/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.swissmedic;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SwissmedicSearchAction
extends Action
implements IKonsExtension,
IHandler {
    public static final String ID = "at.medevit.elexis.swissmedic";
    private static SwissmedicSearchAction instance;

    public String connect(IRichTextDisplay tf) {
        return ID;
    }

    public SwissmedicSearchAction() {
        super("Swissmedic suchen ...");
    }

    public boolean doLayout(StyleRange n, String provider, String id) {
        return false;
    }

    public boolean doXRef(String refProvider, String refID) {
        return false;
    }

    public void run() {
        Optional selectedMedication = ContextServiceHolder.get().getTyped(IPrescription.class);
        if (selectedMedication.isPresent()) {
            IPrescription medication = (IPrescription)selectedMedication.get();
            String ean = null;
            String num = "";
            IArticle article = medication.getArticle();
            if (article != null) {
                if (medication.getArticle().isProduct()) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Swissmedic", (String)"Es ist ein Produkt ausgew\u00e4hlt. F\u00fcr die Suche wird die GTIN eines Artikels ben\u00f6tigt.");
                    return;
                }
                ean = medication.getArticle().getGtin();
            }
            if (ean != null && !ean.isEmpty() && ean.length() >= 9) {
                num = ean.substring(4, 9);
            }
            if (StringUtils.isNotBlank((CharSequence)num)) {
                String url = "http://www.swissmedicinfo.ch/ShowText.aspx?textType=FI&lang=DE&authNr=" + num;
                Program.launch((String)url);
            } else {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Swissmedic", (String)("F\u00fcr Artikel " + (article != null ? article.getLabel() : " NOT_FOUND ") + " ist keine GTIN hinterlegt. Diese wird f\u00fcr die Suche ben\u00f6tigt."));
            }
        } else {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Swissmedic", (String)"Keine Medikation ausgew\u00e4hlt.");
        }
    }

    public IAction[] getActions() {
        return new IAction[]{this};
    }

    public void insert(Object o, int pos) {
    }

    public void removeXRef(String refProvider, String refID) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (instance != null) {
            instance.run();
        }
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

