/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.outbox.ui.command;

import at.medevit.elexis.outbox.model.IOutboxElement;
import at.medevit.elexis.outbox.model.IOutboxElementService;
import at.medevit.elexis.outbox.ui.OutboxServiceComponent;
import at.medevit.elexis.outbox.ui.part.model.PatientOutboxElements;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.data.Patient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.LoggerFactory;

public class OutboxSendHandler
extends AbstractHandler
implements IHandler {
    private File attachmentsFolder;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection && !((StructuredSelection)selection).isEmpty()) {
            List<IOutboxElement> iOutboxElements = ((StructuredSelection)selection).toList();
            HashSet<String> patientIds = new HashSet<String>();
            if (iOutboxElements.size() == 1 && iOutboxElements.get(0) instanceof PatientOutboxElements) {
                iOutboxElements = ((PatientOutboxElements)iOutboxElements.get(0)).getElements();
            }
            for (Object e2 : iOutboxElements) {
                IPatient p;
                if (!(e2 instanceof IOutboxElement) || (p = ((IOutboxElement)e2).getPatient()) == null) continue;
                patientIds.add(p.getId());
            }
            if (patientIds.size() > 1) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warnung", (String)"Es d\u00fcrfen nur Outbox Elemente eines Patienten ausgew\u00e4hlt werden.");
                return null;
            }
            String string = patientIds.stream().findFirst().orElse(null);
            this.sendOutboxElements(event, string != null ? Patient.load((String)string) : null, iOutboxElements);
            iOutboxElements.stream().forEach(e -> ContextServiceHolder.get().postEvent("info/elexis/model/update", e));
        }
        return null;
    }

    private void sendOutboxElements(ExecutionEvent event, Patient patient, List<?> iOutboxElements) {
        ArrayList<File> attachments = new ArrayList<File>();
        File tmpDir = CoreHub.getTempDir();
        this.attachmentsFolder = new File(tmpDir, "_outbox" + System.currentTimeMillis() + "_");
        if (!this.attachmentsFolder.exists()) {
            this.attachmentsFolder.mkdir();
        }
        for (Object iOutboxElement : iOutboxElements) {
            Optional<File> tmpFile;
            if (!(iOutboxElement instanceof IOutboxElement) || !(tmpFile = this.createTempFile((IOutboxElement)iOutboxElement)).isPresent()) continue;
            File file = tmpFile.get();
            attachments.add(file);
        }
        if (!attachments.isEmpty()) {
            ICommandService commandService = (ICommandService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ICommandService.class);
            try {
                String attachmentsString = this.getAttachmentsString(attachments);
                if (event.getCommand().getId().endsWith("sendAsMailXDM")) {
                    Object obj = this.createXDM(patient, commandService, attachmentsString);
                    if (obj instanceof String) {
                        this.sendMailWithXdm(patient, iOutboxElements, commandService, (String)obj);
                    } else {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Fehler", (String)"Der XDM Container konnte nicht erzeugt werden.\nBitte \u00fcberpr\u00fcfen Sie die Log Datei.");
                    }
                } else {
                    this.sendMailWithFiles(patient, iOutboxElements, commandService, attachmentsString);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("ch.elexis.core.mail.ui.sendMail not found", ex);
            }
        }
        this.removeTempAttachments();
    }

    private void sendMailWithFiles(Patient patient, List<?> iOutboxElements, ICommandService commandService, String attachmentsString) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        if (this.openSendMailDlg(patient, iOutboxElements, commandService, attachmentsString)) {
            for (Object iOutboxElement : iOutboxElements) {
                if (!(iOutboxElement instanceof IOutboxElement)) continue;
                OutboxServiceComponent.get().changeOutboxElementState((IOutboxElement)iOutboxElement, IOutboxElementService.State.SENT);
            }
        }
    }

    private void sendMailWithXdm(Patient patient, List<?> iOutboxElements, ICommandService commandService, String retInfo) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        String[] retInfos = retInfo.split(":::");
        if (retInfos.length > 1 && this.openSendMailDlg(patient, iOutboxElements, commandService, retInfos[0])) {
            StringBuilder warnings = new StringBuilder();
            for (Object iOutboxElement : iOutboxElements) {
                if (!(iOutboxElement instanceof IOutboxElement)) continue;
                IOutboxElement outboxElement = (IOutboxElement)iOutboxElement;
                String lblOutBoxElement = outboxElement.getLabel();
                boolean outboxElementSent = false;
                String[] stringArray = retInfos;
                int n = retInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    String info = stringArray[n2];
                    if (info.endsWith(lblOutBoxElement)) {
                        outboxElementSent = true;
                    }
                    ++n2;
                }
                if (outboxElementSent) {
                    OutboxServiceComponent.get().changeOutboxElementState((IOutboxElement)iOutboxElement, IOutboxElementService.State.SENT);
                    continue;
                }
                warnings.append("\n");
                warnings.append(lblOutBoxElement);
            }
            if (warnings.length() > 0) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warnung", (String)("Folgende Outbox Elemente konnten nicht versendet werden:\n" + String.valueOf(warnings)));
            }
        }
    }

    private Object createXDM(Patient patient, ICommandService commandService, String attachmentsString) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        Command xdmCommand = commandService.getCommand("at.medevit.elexis.ehc.ui.vacdoc.CreateXdmHandler");
        if (xdmCommand.isDefined()) {
            ParameterizedCommand parametrizedCommmand;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("at.medevit.elexis.ehc.ui.vacdoc.tmp.dir", this.attachmentsFolder.getAbsolutePath());
            params.put("at.medevit.elexis.ehc.ui.vacdoc.attachments", attachmentsString);
            if (patient != null) {
                params.put("at.medevit.elexis.ehc.ui.vacdoc.patient.id", patient.getId());
            }
            if ((parametrizedCommmand = ParameterizedCommand.generateCommand((Command)xdmCommand, params)) != null) {
                Object obj = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
                return obj;
            }
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Fehler", (String)"Es wurde kein Plugin zum erstellen von XDM Dateien gefunden.");
        }
        return null;
    }

    private boolean openSendMailDlg(Patient patient, List<?> iOutboxElements, ICommandService commandService, String attachmentsString) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        Command sendMailCommand = commandService.getCommand("ch.elexis.core.mail.ui.sendMail");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ch.elexis.core.mail.ui.sendMail.attachments", attachmentsString);
        if (patient != null) {
            params.put("ch.elexis.core.mail.ui.sendMail.subject", "Patient: " + patient.getLabel());
        }
        ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailCommand, params);
        Object obj = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
        return Boolean.TRUE.equals(obj);
    }

    private Optional<File> createTempFile(IOutboxElement outboxElement) {
        try {
            return OutboxServiceComponent.get().createTempFileWithContents(this.attachmentsFolder, outboxElement);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Fehler", (String)"Fehler beim versenden der Dokumente.");
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Could not export Outbox.", (Throwable)e);
            return Optional.empty();
        }
    }

    private void removeTempAttachments() {
        if (this.attachmentsFolder != null) {
            try {
                FileUtils.deleteDirectory((File)this.attachmentsFolder);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Cannot delete attachments folder at {}.", (Object)this.attachmentsFolder.getAbsolutePath(), (Object)e);
            }
        }
    }

    private String getAttachmentsString(List<File> attachments) {
        StringBuilder sb = new StringBuilder();
        for (File file : attachments) {
            if (sb.length() > 0) {
                sb.append(":::");
            }
            sb.append(file.getAbsolutePath());
        }
        return sb.toString();
    }
}

