/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.outbox.ui.part.provider;

import at.medevit.elexis.outbox.model.IOutboxElement;
import at.medevit.elexis.outbox.ui.part.model.PatientOutboxElements;
import at.medevit.elexis.outbox.ui.part.provider.OutboxElementUiExtension;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.icons.Images;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class OutboxElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private OutboxElementUiExtension extension = new OutboxElementUiExtension();

    public String getText(Object element) {
        if (element instanceof PatientOutboxElements) {
            return ((PatientOutboxElements)element).toString();
        }
        if (element instanceof IOutboxElement) {
            String text = this.extension.getText((IOutboxElement)element);
            if (text != null) {
                return text;
            }
            return "unbekannt";
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof PatientOutboxElements) {
            IPatient pat = ((PatientOutboxElements)element).getPatient();
            if (pat != null) {
                if (pat.getGender().equals((Object)Gender.MALE)) {
                    return Images.IMG_MANN.getImage();
                }
                return Images.IMG_FRAU.getImage();
            }
            return Images.IMG_QUESTION_MARK.getImage();
        }
        if (element instanceof IOutboxElement) {
            Image image = this.extension.getImage((IOutboxElement)element);
            if (image != null) {
                return image;
            }
            return Images.IMG_QUESTION_MARK.getImage();
        }
        return null;
    }

    public Color getForeground(Object element) {
        Color color;
        if (element instanceof IOutboxElement && (color = this.extension.getForeground((IOutboxElement)element)) != null) {
            return color;
        }
        return Display.getCurrent().getSystemColor(2);
    }

    public Color getBackground(Object element) {
        Color color;
        if (element instanceof IOutboxElement && (color = this.extension.getBackground((IOutboxElement)element)) != null) {
            return color;
        }
        return Display.getCurrent().getSystemColor(1);
    }
}

