/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.outbox.ui.part;

import at.medevit.elexis.outbox.model.IOutboxElement;
import at.medevit.elexis.outbox.model.IOutboxElementService;
import at.medevit.elexis.outbox.ui.OutboxServiceComponent;
import at.medevit.elexis.outbox.ui.part.action.OutboxFilterAction;
import at.medevit.elexis.outbox.ui.part.model.PatientOutboxElements;
import at.medevit.elexis.outbox.ui.part.provider.IOutboxElementUiProvider;
import at.medevit.elexis.outbox.ui.part.provider.OutboxElementContentProvider;
import at.medevit.elexis.outbox.ui.part.provider.OutboxElementLabelProvider;
import at.medevit.elexis.outbox.ui.part.provider.OutboxElementUiExtension;
import at.medevit.elexis.outbox.ui.part.provider.OutboxViewerComparator;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;

public class OutboxView
extends ViewPart {
    private Text filterText;
    private TreeViewer viewer;
    private boolean reloadPending;
    private OutboxElementViewerFilter filter = new OutboxElementViewerFilter();
    private OutboxElementContentProvider contentProvider;
    private boolean setAutoSelectPatient;

    @Optional
    @Inject
    void mandatorChanged(IMandator mandator) {
        Display.getDefault().asyncExec(() -> this.reload());
    }

    @Optional
    @Inject
    void updateOutboxElement(@UIEventTopic(value="info/elexis/model/update") IOutboxElement element) {
        this.contentProvider.refreshElement(element);
        PatientOutboxElements patientElements = this.contentProvider.getPatientOutboxElements(element);
        if (patientElements != null) {
            this.viewer.refresh((Object)patientElements);
        } else {
            this.viewer.refresh();
        }
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite filterComposite = new Composite(composite, 0);
        GridData data = new GridData(768);
        filterComposite.setLayoutData((Object)data);
        filterComposite.setLayout((Layout)new GridLayout(2, false));
        this.filterText = new Text(filterComposite, 128);
        this.filterText.setMessage("Filter");
        data = new GridData(768);
        this.filterText.setLayoutData((Object)data);
        this.filterText.addModifyListener(e -> {
            if (this.filterText.getText().length() > 1) {
                this.filter.setSearchText(this.filterText.getText());
                this.viewer.refresh();
            } else {
                this.filter.setSearchText("");
                this.viewer.refresh();
            }
        });
        ToolBarManager menuManager = new ToolBarManager(8388928);
        menuManager.createControl(filterComposite);
        this.viewer = new TreeViewer(composite, 2818);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        this.viewer.getControl().setLayoutData((Object)gd);
        ViewerFilter[] filters = new ViewerFilter[]{this.filter};
        this.viewer.setFilters(filters);
        this.contentProvider = new OutboxElementContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new OutboxElementLabelProvider());
        this.viewer.setComparator((ViewerComparator)new OutboxViewerComparator());
        this.viewer.addDoubleClickListener(event -> {
            Object selectedObj;
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            if (!selection.isEmpty() && (selectedObj = selection.getFirstElement()) instanceof IOutboxElement) {
                OutboxElementUiExtension extension = new OutboxElementUiExtension();
                extension.fireDoubleClicked((IOutboxElement)selectedObj);
                this.updateOutboxElement((IOutboxElement)selectedObj);
            }
        });
        this.viewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && !selection.isEmpty() && this.setAutoSelectPatient) {
                Object selectedElement = ((StructuredSelection)selection).getFirstElement();
                if (selectedElement instanceof IOutboxElement) {
                    ContextServiceHolder.get().setTyped((Object)((IOutboxElement)selectedElement).getPatient());
                } else if (selectedElement instanceof PatientOutboxElements) {
                    ContextServiceHolder.get().setActivePatient(((PatientOutboxElements)selectedElement).getPatient());
                }
            }
        });
        this.addFilterActions(menuManager);
        OutboxServiceComponent.get().addUpdateListener(element -> Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OutboxView.this.updateOutboxElement(element);
            }
        }));
        this.reload();
        MenuManager ctxtMenuManager = new MenuManager();
        Menu menu = ctxtMenuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(ctxtMenuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.setAutoSelectPatientState(ConfigServiceHolder.getUser((String)"outbox/patient/autoselect", (boolean)false));
    }

    public void setAutoSelectPatientState(boolean value) {
        this.setAutoSelectPatient = value;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("at.medevit.elexis.outbox.ui.autoSelectPatient");
        command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)value);
        ConfigServiceHolder.setUser((String)"outbox/patient/autoselect", (boolean)value);
    }

    private void addFilterActions(ToolBarManager menuManager) {
        OutboxElementUiExtension extension = new OutboxElementUiExtension();
        List<IOutboxElementUiProvider> providers = extension.getProviders();
        for (IOutboxElementUiProvider iOutboxElementUiProvider : providers) {
            ViewerFilter extensionFilter = iOutboxElementUiProvider.getFilter();
            if (extensionFilter == null) continue;
            OutboxFilterAction action = new OutboxFilterAction((StructuredViewer)this.viewer, extensionFilter, iOutboxElementUiProvider.getFilterImage());
            menuManager.add((IAction)action);
        }
        menuManager.update(true);
    }

    public void setFocus() {
        this.filterText.setFocus();
        if (this.reloadPending) {
            this.reload();
        }
    }

    private List<IOutboxElement> getOpenOutboxElements(IOutboxElementService.State state) {
        List openElements = OutboxServiceComponent.get().getOutboxElements((IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null), null, state);
        return openElements;
    }

    public void reload() {
        if (!this.viewer.getControl().isVisible()) {
            this.reloadPending = true;
            return;
        }
        TreePath[] expanded = this.viewer.getExpandedTreePaths();
        this.viewer.setInput(this.getOpenOutboxElements(null));
        this.reloadPending = false;
        this.viewer.refresh();
        this.viewer.setExpandedTreePaths(expanded);
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    private class OutboxElementViewerFilter
    extends ViewerFilter {
        protected String searchString;
        protected LabelProvider labelProvider = new OutboxElementLabelProvider();

        private OutboxElementViewerFilter() {
        }

        public void setSearchText(String s) {
            this.searchString = s;
        }

        public boolean isActive() {
            return this.searchString != null && !this.searchString.isEmpty();
        }

        private boolean isSelect(Object leaf) {
            String label = this.labelProvider.getText(leaf);
            return label != null && label.contains(this.searchString);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString == null || this.searchString.length() == 0) {
                return true;
            }
            StructuredViewer sviewer = (StructuredViewer)viewer;
            ITreeContentProvider provider = (ITreeContentProvider)sviewer.getContentProvider();
            Object[] children = provider.getChildren(element);
            if (children != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.select(viewer, element, child)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return this.isSelect(element);
        }
    }
}

