/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.outbox.ui;

import at.medevit.elexis.outbox.model.IOutboxElement;
import at.medevit.elexis.outbox.model.IOutboxElementService;
import at.medevit.elexis.outbox.model.OutboxElementType;
import at.medevit.elexis.outbox.ui.OutboxServiceComponent;
import at.medevit.elexis.outbox.ui.TaskServiceComponent;
import at.medevit.elexis.outbox.ui.filter.NotSentOutboxFilter;
import at.medevit.elexis.outbox.ui.part.provider.IOutboxElementUiProvider;
import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.LoggerFactory;

public class CoreOutboxElementLabelProvider
implements IOutboxElementUiProvider {
    private CoreLabelProvider labelProvider = new CoreLabelProvider();
    private CoreColorProvider colorProvider = new CoreColorProvider();
    private Map<String, IIdentifiedRunnable> identifiedRunnablesMap = this.buildIdentifiedRunnablesMap();

    private Map<String, IIdentifiedRunnable> buildIdentifiedRunnablesMap() {
        List available = TaskServiceComponent.get().getIdentifiedRunnables();
        if (available != null && !available.isEmpty()) {
            HashMap<String, IIdentifiedRunnable> ret = new HashMap<String, IIdentifiedRunnable>();
            available.stream().forEach(ir -> {
                IIdentifiedRunnable iIdentifiedRunnable = ret.put(ir.getId(), (IIdentifiedRunnable)ir);
            });
            return ret;
        }
        return Collections.emptyMap();
    }

    @Override
    public ImageDescriptor getFilterImage() {
        return Images.IMG_MAIL_SEND.getImageDescriptor();
    }

    @Override
    public ViewerFilter getFilter() {
        return new NotSentOutboxFilter();
    }

    @Override
    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public IColorProvider getColorProvider() {
        return this.colorProvider;
    }

    @Override
    public boolean isProviderFor(IOutboxElement element) {
        OutboxElementType elementType = OutboxElementType.parseType((String)element.getUri());
        if (OutboxElementType.DOC.equals((Object)elementType)) {
            return true;
        }
        if (OutboxElementType.DB.equals((Object)elementType)) {
            return element.getObject() instanceof ITaskDescriptor;
        }
        return false;
    }

    @Override
    public void doubleClicked(IOutboxElement element) {
        IDocument document;
        OutboxElementType elementType = OutboxElementType.parseType((String)element.getUri());
        if (OutboxElementType.DB.equals((Object)elementType)) {
            ITaskDescriptor taskDescriptor;
            if (element.getObject() instanceof ITaskDescriptor && "sendMailFromContext".equals((taskDescriptor = (ITaskDescriptor)element.getObject()).getIdentifiedRunnableId())) {
                try {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command sendMailTaskCommand = commandService.getCommand("ch.elexis.core.mail.ui.sendMailTask");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("ch.elexis.core.mail.ui.sendMailTaskDescriptorId", taskDescriptor.getId());
                    ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailTaskCommand, params);
                    Boolean success = (Boolean)((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
                    if (success.booleanValue()) {
                        OutboxServiceComponent.get().changeOutboxElementState(element, IOutboxElementService.State.SENT);
                    }
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger(this.getClass()).warn("Send mail Task command not available", (Throwable)ex);
                }
            }
        } else if (OutboxElementType.DOC.equals((Object)elementType) && (document = (IDocument)element.getObject()) != null) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.core.ui.documents.views.DocumentsView");
            }
            catch (PartInitException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not open documents view", (Throwable)e);
            }
        }
    }

    @Override
    public void delete(IOutboxElement element) {
        OutboxElementType elementType = OutboxElementType.parseType((String)element.getUri());
        if (OutboxElementType.DB.equals((Object)elementType) && element.getObject() instanceof ITaskDescriptor) {
            ITaskDescriptor taskDescriptor = (ITaskDescriptor)element.getObject();
            try {
                TaskServiceComponent.get().removeTaskDescriptor(taskDescriptor);
            }
            catch (TaskException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Error removing mail Task", (Throwable)e);
            }
        }
    }

    class CoreColorProvider
    implements IColorProvider {
        CoreColorProvider() {
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            if (((IOutboxElement)element).getState() == IOutboxElementService.State.SENT) {
                return CoreUiUtil.getColorForString((String)"d3d3d3");
            }
            return null;
        }
    }

    class CoreLabelProvider
    extends LabelProvider {
        private Image taskImage;

        CoreLabelProvider() {
        }

        public String getText(Object element) {
            OutboxElementType elementType = OutboxElementType.parseType((String)((IOutboxElement)element).getUri());
            if (OutboxElementType.DB.equals((Object)elementType) && ((IOutboxElement)element).getObject() instanceof ITaskDescriptor) {
                return this.getTaskDescriptorText((ITaskDescriptor)((IOutboxElement)element).getObject());
            }
            return ((IOutboxElement)element).getLabel();
        }

        private String getTaskDescriptorText(ITaskDescriptor taskDescriptor) {
            MailMessage msg;
            StringBuilder sb = new StringBuilder();
            IIdentifiedRunnable ir = CoreOutboxElementLabelProvider.this.identifiedRunnablesMap.get(taskDescriptor.getIdentifiedRunnableId());
            Optional execution = TaskServiceComponent.get().findLatestExecution(taskDescriptor);
            if (execution.isPresent()) {
                sb.append("versendet am " + ((ITask)execution.get()).getFinishedAt().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
            } else {
                sb.append(ir.getLocalizedDescription());
            }
            if ("sendMailFromContext".equals(taskDescriptor.getIdentifiedRunnableId()) && (msg = MailMessage.fromMap((Map)((Map)taskDescriptor.getRunContext().get("message")))) != null) {
                sb.append(" an ").append(msg.getTo());
                if (StringUtils.isNotBlank((CharSequence)msg.getCc())) {
                    sb.append(", cc ").append(msg.getCc());
                }
                return sb.toString();
            }
            return sb.toString();
        }

        public Image getImage(Object element) {
            OutboxElementType elementType = OutboxElementType.parseType((String)((IOutboxElement)element).getUri());
            if (OutboxElementType.DOC.equals((Object)elementType)) {
                return Images.IMG_DOCUMENT_TEXT.getImage();
            }
            if (OutboxElementType.DB.equals((Object)elementType) && ((IOutboxElement)element).getObject() instanceof ITaskDescriptor) {
                return this.getTaskImage();
            }
            return null;
        }

        private Image getTaskImage() {
            if (this.taskImage == null) {
                try {
                    this.taskImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/ch.elexis.core.ui.tasks/rsc/icons/screwdriver.png")).createImage();
                }
                catch (MalformedURLException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Error loading task image ", (Throwable)e);
                }
            }
            return this.taskImage;
        }
    }
}

