/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.medietikette.command;

import at.medevit.elexis.medietikette.Messages;
import at.medevit.elexis.medietikette.data.DataAccessor;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.dialogs.EtiketteDruckenDialog;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintMediEtiketteUi
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(PrintMediEtiketteUi.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Class<PrintMediEtiketteUi> clazz = PrintMediEtiketteUi.class;
        synchronized (PrintMediEtiketteUi.class) {
            ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection strucSelection = (IStructuredSelection)selection;
                List<IPrescription> prescriptions = this.getPrescriptionsFromSelection(strucSelection);
                List<IArticle> artikels = this.getArtikelsFromSelection(strucSelection);
                for (IPrescription prescription : prescriptions) {
                    DataAccessor.setSelectedPrescription(prescription);
                    DataAccessor.setSelectedArticel(prescription.getArticle());
                    this.print(event);
                    DataAccessor.setSelectedPrescription(null);
                    DataAccessor.setSelectedArticel(null);
                }
                for (IArticle artikel : artikels) {
                    DataAccessor.setSelectedArticel(artikel);
                    this.print(event);
                    DataAccessor.setSelectedPrescription(null);
                    DataAccessor.setSelectedArticel(null);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void print(ExecutionEvent event) {
        Kontakt kontakt = (Kontakt)ElexisEventDispatcher.getSelected(Patient.class);
        EtiketteDruckenDialog dlg = new EtiketteDruckenDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), kontakt, "Medietikette");
        dlg.setTitle(Messages.PrintMediEtiketteUi_DialogTitel);
        dlg.setMessage(Messages.PrintMediEtiketteUi_DialogMessage);
        if (CoreHub.localCfg.get("Drucker/Etiketten/Choose", true)) {
            dlg.setBlockOnOpen(true);
            dlg.open();
            return;
        }
        dlg.setBlockOnOpen(false);
        dlg.open();
        if (dlg.doPrint()) {
            dlg.close();
            return;
        }
        StatusManager.getManager().handle((IStatus)new ElexisStatus(4, "at.medevit.elexis.medietikette", 1, Messages.PrintMediEtiketteUi_PrintError, 2), 4);
    }

    private List<IArticle> getArtikelsFromSelection(IStructuredSelection strucSelection) {
        List selection = strucSelection.toList();
        ArrayList<IArticle> ret = new ArrayList<IArticle>();
        for (Object object : selection) {
            IBilled verrechnet;
            IBillable verrechenbar;
            if (!(object instanceof IBilled) || !((verrechenbar = (verrechnet = (IBilled)object).getBillable()) instanceof IArticle)) continue;
            ret.add((IArticle)verrechenbar);
        }
        return ret;
    }

    private List<IPrescription> getPrescriptionsFromSelection(IStructuredSelection strucSelection) {
        List selection = strucSelection.toList();
        ArrayList<IPrescription> ret = new ArrayList<IPrescription>();
        for (Object object : selection) {
            if (object instanceof IPrescription) {
                ret.add((IPrescription)object);
                continue;
            }
            if (!object.getClass().getName().equals("ch.elexis.core.ui.medication.views.MedicationTableViewerItem")) continue;
            try {
                IPrescription pres;
                Method method = object.getClass().getMethod("getPrescription", new Class[0]);
                if (method == null || (pres = (IPrescription)method.invoke(object, new Object[0])) == null) continue;
                ret.add(pres);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.warn("Could not get selected prescription.", (Throwable)e);
            }
        }
        return ret;
    }
}

