/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.loinc.model.impl;

import at.medevit.elexis.loinc.model.ILoincCodeService;
import at.medevit.elexis.loinc.model.LoincCode;
import ch.elexis.data.Query;
import ch.rgw.tools.VersionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoincCodeService
implements ILoincCodeService {
    private static Logger logger = LoggerFactory.getLogger(LoincCodeService.class);
    private Map<Integer, String> fieldMapping;
    private Integer codeMapping = -1;
    public static final VersionInfo TOP2000VERSION = new VersionInfo("1.1.0");
    public static final VersionInfo CLINICALVERSION = new VersionInfo("1.0.0");

    @Override
    public LoincCode getByCode(String code) {
        Query qbe = new Query(LoincCode.class);
        qbe.add("ID", "!=", "VERSION");
        qbe.add("ID", "!=", "TOP2000VERSION");
        qbe.add("ID", "!=", "CLINICALVERSION");
        qbe.add("code", "=", code);
        List res = qbe.execute();
        if (res.isEmpty()) {
            logger.debug("Code [" + code + "] not found");
            return null;
        }
        return (LoincCode)((Object)res.get(0));
    }

    @Override
    public List<LoincCode> getAllCodes() {
        Query qbe = new Query(LoincCode.class);
        qbe.add("ID", "!=", "VERSION");
        qbe.add("ID", "!=", "TOP2000VERSION");
        qbe.add("ID", "!=", "CLINICALVERSION");
        return qbe.execute();
    }

    @Override
    public void importFromCsv(InputStream csv, Map<Integer, String> fieldMapping) throws IOException {
        String line;
        logger.info("Import from CSV stream " + String.valueOf(csv));
        this.initMapping(fieldMapping);
        BufferedReader reader = new BufferedReader(new InputStreamReader(csv));
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split(",", -1);
            if (parts[this.codeMapping].matches("[0-9\\-]*")) {
                LoincCode existing = this.getByCode(parts[0]);
                if (existing != null) {
                    this.merge(existing, parts);
                    continue;
                }
                logger.debug("Creating object [" + parts[this.codeMapping] + "]");
                this.create(parts);
                continue;
            }
            logger.warn("Import skipping object [" + parts[this.codeMapping] + "]");
        }
    }

    private void create(String[] parts) {
        LoincCode code = new LoincCode(parts[this.codeMapping], null, null, null, null);
        int i = 0;
        while (i < this.fieldMapping.size()) {
            if (i >= parts.length) {
                code.set(this.fieldMapping.get(i), "");
            }
            code.set(this.fieldMapping.get(i), parts[i]);
            ++i;
        }
    }

    private void merge(LoincCode existing, String[] parts) {
        int i = 0;
        while (i < this.fieldMapping.size()) {
            existing.set(this.fieldMapping.get(i), parts[i]);
            ++i;
        }
    }

    private void initMapping(Map<Integer, String> fieldMapping) {
        this.fieldMapping = fieldMapping;
        int i = 0;
        while (i < fieldMapping.size()) {
            if (fieldMapping.get(i).equals("code")) {
                this.codeMapping = i;
                break;
            }
            ++i;
        }
        if (this.codeMapping == -1) {
            throw new IllegalStateException("Fieldmapping is missing the code field.");
        }
    }

    @Override
    public void updateData() {
        logger.info("Update Top 2000 to version " + TOP2000VERSION.version());
        logger.info("Update Top 2000 from version " + LoincCode.getDataVersion("TOP2000VERSION").version());
        if (TOP2000VERSION.isNewer(LoincCode.getDataVersion("TOP2000VERSION"))) {
            try {
                this.importFromCsv(LoincCodeService.loadTop2000(), LoincCodeService.getTop2000FieldMapping());
                LoincCode.setDataVersion("TOP2000VERSION", TOP2000VERSION.version());
            }
            catch (IOException e) {
                logger.error("Top 2000 import failed.", (Throwable)e);
            }
        }
        logger.info("Update Clinical to version " + CLINICALVERSION.version());
        logger.info("Update Clinical from version " + LoincCode.getDataVersion("CLINICALVERSION").version());
        if (CLINICALVERSION.isNewer(LoincCode.getDataVersion("CLINICALVERSION"))) {
            try {
                this.importFromCsv(LoincCodeService.loadClinical(), LoincCodeService.getClinicalFieldMapping());
                LoincCode.setDataVersion("CLINICALVERSION", CLINICALVERSION.version());
            }
            catch (IOException e) {
                logger.error("Clinical import failed.", (Throwable)e);
            }
        }
    }

    private static InputStream loadClinical() {
        return LoincCodeService.class.getResourceAsStream("/rsc/LOINC_CLINICAL.CSV");
    }

    private static InputStream loadTop2000() {
        return LoincCodeService.class.getResourceAsStream("/rsc/TOP_2000_COMMON_LAB_RESULTS_SI_LOINC_V1-1.CSV");
    }

    private static Map<Integer, String> getClinicalFieldMapping() {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        ret.put(0, "code");
        ret.put(1, "longname");
        ret.put(2, "shortname");
        ret.put(3, "class");
        return ret;
    }

    private static Map<Integer, String> getTop2000FieldMapping() {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        ret.put(0, "code");
        ret.put(1, "longname");
        ret.put(2, "shortname");
        ret.put(3, "class");
        return ret;
    }
}

