/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.model.impl;

import at.medevit.elexis.inbox.model.IInboxElementsProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementsProviderExtension {
    private static Logger logger = LoggerFactory.getLogger(ElementsProviderExtension.class);
    private static List<IInboxElementsProvider> instances;

    public static synchronized void activateAll() {
        if (instances == null) {
            ElementsProviderExtension.updateInstances();
        }
        for (IInboxElementsProvider iInboxElementsProvider : instances) {
            iInboxElementsProvider.activate();
        }
    }

    public static synchronized void deactivateAll() {
        if (instances == null) {
            ElementsProviderExtension.updateInstances();
        }
        for (IInboxElementsProvider iInboxElementsProvider : instances) {
            iInboxElementsProvider.deactivate();
        }
    }

    private static void updateInstances() {
        instances = new ArrayList<IInboxElementsProvider>();
        IExtensionRegistry exr = Platform.getExtensionRegistry();
        IExtensionPoint exp = exr.getExtensionPoint("at.medevit.elexis.inbox.elementsprovider");
        if (exp != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = exp.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elems;
                IExtension ex = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elems = ex.getConfigurationElements();
                int n3 = elems.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (el.getName().equals("provider")) {
                        try {
                            instances.add((IInboxElementsProvider)el.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            logger.error("Error creating IInboxElementsProvider " + String.valueOf((Object)e));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

