/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.ui.dbcheck;

import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.ui.InboxServiceHolder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import java.time.LocalDate;
import java.time.ZoneId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class RemoveInvalidInboxEntries
extends ExternalMaintenance {
    private boolean removeOldEntries;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        IInboxElement element;
        IQueryCursor entries;
        Object var7_9;
        Throwable throwable;
        IQuery inboxQuery;
        int removedOld = 0;
        int removedInvalid = 0;
        this.getRemoveOldEntries();
        if (this.removeOldEntries) {
            inboxQuery = InboxServiceHolder.getModelService().getQuery(IInboxElement.class, true);
            inboxQuery.and("lastupdate", IQuery.COMPARATOR.LESS, (Object)(LocalDate.now().minusDays(7L).atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * 1000L));
            throwable = null;
            var7_9 = null;
            try {
                entries = inboxQuery.executeAsCursor();
                try {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Removing " + entries.size() + " inbox elements");
                    pm.beginTask("Bitte warten, alte Inbox Eintr\u00e4ge werden gel\u00f6scht", entries.size());
                    while (entries.hasNext()) {
                        element = (IInboxElement)entries.next();
                        InboxServiceHolder.getModelService().remove((Identifiable)element);
                        ++removedOld;
                        pm.worked(1);
                        if (!pm.isCanceled()) continue;
                        return this.getReturnMessage(removedOld, removedInvalid);
                    }
                }
                finally {
                    if (entries != null) {
                        entries.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        inboxQuery = InboxServiceHolder.getModelService().getQuery(IInboxElement.class);
        inboxQuery.and("state", IQuery.COMPARATOR.NOT_EQUALS, (Object)Integer.toString(IInboxElementService.State.SEEN.ordinal()));
        throwable = null;
        var7_9 = null;
        try {
            entries = inboxQuery.executeAsCursor();
            try {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Checking " + entries.size() + " inbox elements");
                pm.beginTask("Bitte warten, Inbox Eintr\u00e4ge werden \u00fcberpr\u00fcft", entries.size());
                while (entries.hasNext()) {
                    element = (IInboxElement)entries.next();
                    if (element.getObject() == null) {
                        InboxServiceHolder.getModelService().remove((Identifiable)element);
                        ++removedInvalid;
                        pm.worked(1);
                    }
                    if (!pm.isCanceled()) continue;
                    return this.getReturnMessage(removedOld, removedInvalid);
                }
            }
            finally {
                if (entries != null) {
                    entries.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return this.getReturnMessage(removedOld, removedInvalid);
    }

    private String getReturnMessage(int removedOld, int removedInvalid) {
        return "Es wurden [" + removedOld + "] alte Inbox Eintr\u00e4ge gel\u00f6scht, und [" + removedInvalid + "] nicht mehr valide Inbox Eintr\u00e4ge gel\u00f6scht";
    }

    private void getRemoveOldEntries() {
        Display.getDefault().syncExec(() -> {
            this.removeOldEntries = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Alte Eintr\u00e4ge l\u00f6schen", (String)"Sollen Inbox Eintr\u00e4ge die \u00e4lter als 7 Tage sind aus der DB entfernt werden?");
        });
    }

    public String getMaintenanceDescription() {
        return "Nicht mehr aktive und alte Inbox Eintr\u00e4ge entfernen.";
    }
}

